/* FORMACAO DE DBAs */
/* SQL Server 2005  */

/* DEM - Niveis de Isolamento */

-- Criacao das tabelas

CREATE TABLE [dbo].[agencia] (
	[num_agencia] [tinyint] NOT NULL ,
	[nom_agencia] [varchar] (20)  NOT NULL ,
	[cidade_agencia] [varchar] (30)  NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[aplicacao] (
	[cod_aplicacao] [tinyint] NOT NULL ,
	[tipo_aplicacao] [char] (3)  NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[aplicacao_conta] (
	[cod_aplicacao] [tinyint] NOT NULL ,
	[num_agencia] [tinyint] NOT NULL ,
	[num_conta] [smallint] NOT NULL ,
	[saldo_aplicacao] [money] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[cliente] (
	[cpf_cliente] [bigint] NOT NULL ,
	[nom_cliente] [varchar] (50)  NOT NULL ,
	[dtc_nascimento] [smalldatetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[cliente_conta] (
	[cpf_cliente] [bigint] NOT NULL ,
	[num_agencia] [tinyint] NOT NULL ,
	[num_conta] [smallint] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[conta] (
	[num_agencia] [tinyint] NOT NULL ,
	[num_conta] [smallint] NOT NULL ,
	[saldo_conta] [money] NOT NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[agencia] ADD 
	CONSTRAINT [ix_agencia01] PRIMARY KEY  NONCLUSTERED 
	(
		[num_agencia]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[aplicacao] ADD 
	CONSTRAINT [ix_aplicacao01] PRIMARY KEY  NONCLUSTERED 
	(
		[cod_aplicacao]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[aplicacao_conta] ADD 
	CONSTRAINT [ix_aplicacao_conta01] PRIMARY KEY NONCLUSTERED 
	(
		[cod_aplicacao],
		[num_agencia],
		[num_conta]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[cliente] ADD 
	CONSTRAINT [ix_cliente01] PRIMARY KEY  NONCLUSTERED 
	(
		[cpf_cliente]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[cliente_conta] ADD 
	CONSTRAINT [ix_cliente_conta01] PRIMARY KEY  NONCLUSTERED 
	(
		[cpf_cliente],
		[num_agencia],
		[num_conta]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[conta] ADD 
	CONSTRAINT [ix_conta01] PRIMARY KEY NONCLUSTERED 
	(
		[num_agencia],
		[num_conta]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[aplicacao_conta] ADD 
	CONSTRAINT [fk_aplicacao_conta_aplicacao] FOREIGN KEY 
	(
		[cod_aplicacao]
	) REFERENCES [dbo].[aplicacao] (
		[cod_aplicacao]
	),
	CONSTRAINT [fk_aplicacao_conta_conta] FOREIGN KEY 
	(
		[num_agencia],
		[num_conta]
	) REFERENCES [dbo].[conta] (
		[num_agencia],
		[num_conta]
	)
GO

ALTER TABLE [dbo].[cliente_conta] ADD 
	CONSTRAINT [fk_cliente_conta_cliente] FOREIGN KEY 
	(
		[cpf_cliente]
	) REFERENCES [dbo].[cliente] (
		[cpf_cliente]
	),
	CONSTRAINT [fk_cliente_conta_conta] FOREIGN KEY 
	(
		[num_agencia],
		[num_conta]
	) REFERENCES [dbo].[conta] (
		[num_agencia],
		[num_conta]
	)
GO

ALTER TABLE [dbo].[conta] ADD 
	CONSTRAINT [fk_conta_agencia] FOREIGN KEY 
	(
		[num_agencia]
	) REFERENCES [dbo].[agencia] (
		[num_agencia]
	)
GO

ALTER TABLE agencia ADD dtc_atualizacao SMALLDATETIME NOT NULL 
CONSTRAINT df_agencia_dtc_atualizacao DEFAULT (getdate())
GO 
ALTER TABLE aplicacao ADD dtc_atualizacao SMALLDATETIME NOT NULL 
CONSTRAINT df_aplicacao_dtc_atualizacao DEFAULT (getdate())
GO 
ALTER TABLE aplicacao_conta ADD dtc_atualizacao SMALLDATETIME NOT NULL 
CONSTRAINT df_aplicacao_conta_dtc_atualizacao DEFAULT (getdate())
GO 
ALTER TABLE cliente ADD dtc_atualizacao SMALLDATETIME NOT NULL 
CONSTRAINT df_cliente_dtc_atualizacao DEFAULT (getdate())
GO 
ALTER TABLE cliente_conta ADD dtc_atualizacao SMALLDATETIME NOT NULL 
CONSTRAINT df_cliente_conta_dtc_atualizacao DEFAULT (getdate())
GO 
ALTER TABLE conta ADD dtc_atualizacao SMALLDATETIME NOT NULL 
CONSTRAINT df_conta_dtc_atualizacao DEFAULT (getdate())
GO 

ALTER TABLE conta ADD tipo_conta CHAR(1) NOT NULL 
CONSTRAINT df_conta_tipo_conta DEFAULT ('C')
GO 

ALTER TABLE conta ADD CONSTRAINT ck_conta_tipo_conta 
CHECK(tipo_conta = 'C' OR tipo_conta = 'P')
GO 

-- Carga das tabelas

insert into agencia (num_agencia,nom_agencia,cidade_agencia,dtc_atualizacao)
values (1,'Federacao','Salvador', getdate())

insert into agencia (num_agencia,nom_agencia,cidade_agencia,dtc_atualizacao)
values (2,'CAB','Salvador', getdate())

insert into agencia (num_agencia,nom_agencia,cidade_agencia,dtc_atualizacao)
values (3,'Brotas','Salvador', getdate())

insert into conta (num_agencia,num_conta,saldo_conta,dtc_atualizacao,tipo_conta)
values (1,10,2000, getdate(),'C')

insert into conta (num_agencia,num_conta,saldo_conta,dtc_atualizacao,tipo_conta)
values (2,11,3000, getdate(),'P')

insert into conta (num_agencia,num_conta,saldo_conta,dtc_atualizacao,tipo_conta)
values (2,12,6000, getdate(),'C')

insert into conta (num_agencia,num_conta,saldo_conta,dtc_atualizacao,tipo_conta)
values (3,13,1000, getdate(),'C')

insert into conta (num_agencia,num_conta,saldo_conta,dtc_atualizacao,tipo_conta)
values (3,14,10000, getdate(),'P')

insert into cliente (cpf_cliente,nom_cliente,dtc_nascimento,dtc_atualizacao)
values (11111111122, 'Ana','1948/03/22',getdate())

insert into cliente (cpf_cliente,nom_cliente,dtc_nascimento,dtc_atualizacao)
values (33333333344, 'Paulo','1960/08/15',getdate())

insert into cliente (cpf_cliente,nom_cliente,dtc_nascimento,dtc_atualizacao)
values (55555555566, 'Jose','1975/11/05',getdate())

insert into cliente_conta (cpf_cliente,num_agencia,num_conta,dtc_atualizacao)
values (11111111122, 1,10,getdate())

insert into cliente_conta (cpf_cliente,num_agencia,num_conta,dtc_atualizacao)
values (33333333344, 2,11,getdate())

insert into cliente_conta (cpf_cliente,num_agencia,num_conta,dtc_atualizacao)
values (33333333344, 2,12,getdate())

insert into cliente_conta (cpf_cliente,num_agencia,num_conta,dtc_atualizacao)
values (55555555566, 3,13,getdate())

insert into cliente_conta (cpf_cliente,num_agencia,num_conta,dtc_atualizacao)
values (55555555566, 3,14,getdate())

insert into aplicacao (cod_aplicacao, tipo_aplicacao, dtc_atualizacao)
values (1, 'RDB',getdate())

insert into aplicacao (cod_aplicacao, tipo_aplicacao, dtc_atualizacao)
values (2, 'CDB',getdate())

insert into aplicacao (cod_aplicacao, tipo_aplicacao, dtc_atualizacao)
values (3, 'RDB',getdate())

insert into aplicacao (cod_aplicacao, tipo_aplicacao, dtc_atualizacao)
values (4, 'CDB',getdate())

insert into aplicacao (cod_aplicacao, tipo_aplicacao, dtc_atualizacao)
values (5, 'CDB',getdate())

insert into aplicacao_conta (num_agencia, num_conta, cod_aplicacao, saldo_aplicacao, dtc_atualizacao)
values (1, 10, 1, 500,getdate())

insert into aplicacao_conta (num_agencia, num_conta, cod_aplicacao, saldo_aplicacao, dtc_atualizacao)
values (1, 10, 2,-1500,getdate())

insert into aplicacao_conta (num_agencia, num_conta, cod_aplicacao, saldo_aplicacao, dtc_atualizacao)
values (2, 12, 3,-800, getdate())

insert into aplicacao_conta (num_agencia, num_conta, cod_aplicacao, saldo_aplicacao, dtc_atualizacao)
values (2, 12, 4, 2000, getdate())

insert into aplicacao_conta (num_agencia, num_conta, cod_aplicacao, saldo_aplicacao, dtc_atualizacao)
values (3, 13, 5,-1200, getdate())

