#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtWidgets/QGraphicsEllipseItem>

#include "diagram1.h"
#include "diagram2.h"
#include "implementation1.h"
#include "implementation2.h"

#include "iabstraction.h"
#include "iimplementation.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    _abstraction(0),
    _implementation(0)
{
    ui->setupUi(this);
    QGraphicsScene *scene = new QGraphicsScene;
    ui->graphicsView->setScene(scene);
    QGraphicsEllipseItem *item = scene->addEllipse(0, 0, 100, 100);
    item->setFlags(QGraphicsItem::ItemIsMovable | QGraphicsItem::ItemIsSelectable);

    ui->cbbAbstraction->addItem("Diagram1", QVariant::fromValue((IAbstraction *)(new Diagram1)));
    ui->cbbAbstraction->addItem("Diagram2", QVariant::fromValue((IAbstraction *)(new Diagram2)));

    ui->cbbImplementation->addItem("Implementation1", QVariant::fromValue((IImplementation *)(new Implementation1)));
    ui->cbbImplementation->addItem("Implementation2", QVariant::fromValue((IImplementation *)(new Implementation2)));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_pushButton_clicked()
{
    qDebug() << ui->pushButton->text();
    ui->webView->setUrl(ui->lineEdit->text());
}

void MainWindow::on_cbbAbstraction_currentIndexChanged(int index)
{
    _abstraction = ui->cbbAbstraction->itemData(index).value<IAbstraction *>();
    if (_abstraction) {
        ui->graphicsView->scene()->clear();
        foreach(QAbstractGraphicsShapeItem  *item, _abstraction->graphicItems()) {
            if (_implementation)
                item->setBrush(_implementation->brush());
            ui->graphicsView->scene()->addItem(item);
        }
    }
}

void MainWindow::on_cbbImplementation_currentIndexChanged(int index)
{
    _implementation = ui->cbbImplementation->itemData(index).value<IImplementation *>();
    if (_implementation) {
        foreach(QGraphicsItem  *item, ui->graphicsView->scene()->items()) {
            ((QAbstractGraphicsShapeItem *)(item))->setBrush(_implementation->brush());
        }
    }
}
