/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class PolygonShape
extends Shape {
    private static boolean m_debug = false;
    public final Vec2 m_centroid = new Vec2();
    public final Vec2[] m_vertices;
    public final Vec2[] m_normals;
    public int m_vertexCount;
    private final Vec2 pool1 = new Vec2();
    private final Vec2 pool2 = new Vec2();
    private final Vec2 pool3 = new Vec2();
    private final Vec2 pool4 = new Vec2();
    private final Vec2 pool5 = new Vec2();
    private final Vec2 pool6 = new Vec2();
    private Transform poolt1 = new Transform();

    public PolygonShape() {
        int i;
        this.m_type = ShapeType.POLYGON;
        this.m_vertexCount = 0;
        this.m_vertices = new Vec2[Settings.maxPolygonVertices];
        for (i = 0; i < this.m_vertices.length; ++i) {
            this.m_vertices[i] = new Vec2();
        }
        this.m_normals = new Vec2[Settings.maxPolygonVertices];
        for (i = 0; i < this.m_normals.length; ++i) {
            this.m_normals[i] = new Vec2();
        }
        this.m_radius = Settings.polygonRadius;
        this.m_centroid.setZero();
    }

    @Override
    public final Shape clone() {
        PolygonShape shape = new PolygonShape();
        shape.m_centroid.set(this.m_centroid);
        for (int i = 0; i < shape.m_normals.length; ++i) {
            shape.m_normals[i].set(this.m_normals[i]);
            shape.m_vertices[i].set(this.m_vertices[i]);
        }
        shape.m_radius = this.m_radius;
        shape.m_vertexCount = this.m_vertexCount;
        return shape;
    }

    public final int getSupport(Vec2 d) {
        int bestIndex = 0;
        float bestValue = Vec2.dot(this.m_vertices[0], d);
        for (int i = 1; i < this.m_vertexCount; ++i) {
            float value = Vec2.dot(this.m_vertices[i], d);
            if (!(value > bestValue)) continue;
            bestIndex = i;
            bestValue = value;
        }
        return bestIndex;
    }

    public final Vec2 getSupportVertex(Vec2 d) {
        int bestIndex = 0;
        float bestValue = Vec2.dot(this.m_vertices[0], d);
        for (int i = 1; i < this.m_vertexCount; ++i) {
            float value = Vec2.dot(this.m_vertices[i], d);
            if (!(value > bestValue)) continue;
            bestIndex = i;
            bestValue = value;
        }
        return this.m_vertices[bestIndex];
    }

    public final void set(Vec2[] vertices, int count) {
        assert (2 <= count && count <= Settings.maxPolygonVertices);
        this.m_vertexCount = count;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            if (this.m_vertices[i] == null) {
                this.m_vertices[i] = new Vec2();
            }
            this.m_vertices[i].set(vertices[i]);
        }
        Vec2 edge = this.pool1;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            int i1 = i;
            int i2 = i + 1 < this.m_vertexCount ? i + 1 : 0;
            edge.set(this.m_vertices[i2]).subLocal(this.m_vertices[i1]);
            assert (edge.lengthSquared() > 1.4210855E-14f);
            Vec2.crossToOut(edge, 1.0f, this.m_normals[i]);
            this.m_normals[i].normalize();
        }
        if (m_debug) {
            Vec2 r = this.pool2;
            for (int i = 0; i < this.m_vertexCount; ++i) {
                int i1 = i;
                int i2 = i + 1 < this.m_vertexCount ? i + 1 : 0;
                edge.set(this.m_vertices[i2]).subLocal(this.m_vertices[i1]);
                for (int j = 0; j < this.m_vertexCount; ++j) {
                    if (j == i1 || j == i2) continue;
                    r.set(this.m_vertices[j]).subLocal(this.m_vertices[i1]);
                    float s = Vec2.cross(edge, r);
                    assert (s > 0.0f);
                }
            }
        }
        this.computeCentroidToOut(this.m_vertices, this.m_vertexCount, this.m_centroid);
    }

    public final void setAsBox(float hx, float hy) {
        this.m_vertexCount = 4;
        this.m_vertices[0].set(-hx, -hy);
        this.m_vertices[1].set(hx, -hy);
        this.m_vertices[2].set(hx, hy);
        this.m_vertices[3].set(-hx, hy);
        this.m_normals[0].set(0.0f, -1.0f);
        this.m_normals[1].set(1.0f, 0.0f);
        this.m_normals[2].set(0.0f, 1.0f);
        this.m_normals[3].set(-1.0f, 0.0f);
        this.m_centroid.setZero();
    }

    public final void setAsBox(float hx, float hy, Vec2 center, float angle) {
        this.m_vertexCount = 4;
        this.m_vertices[0].set(-hx, -hy);
        this.m_vertices[1].set(hx, -hy);
        this.m_vertices[2].set(hx, hy);
        this.m_vertices[3].set(-hx, hy);
        this.m_normals[0].set(0.0f, -1.0f);
        this.m_normals[1].set(1.0f, 0.0f);
        this.m_normals[2].set(0.0f, 1.0f);
        this.m_normals[3].set(-1.0f, 0.0f);
        this.m_centroid.set(center);
        Transform xf = this.poolt1;
        xf.position.set(center);
        xf.R.set(angle);
        for (int i = 0; i < this.m_vertexCount; ++i) {
            Transform.mulToOut(xf, this.m_vertices[i], this.m_vertices[i]);
            Mat22.mulToOut(xf.R, this.m_normals[i], this.m_normals[i]);
        }
    }

    public final void setAsEdge(Vec2 v1, Vec2 v2) {
        this.m_vertexCount = 2;
        this.m_vertices[0].set(v1);
        this.m_vertices[1].set(v2);
        this.m_centroid.set(v1).addLocal(v2).mulLocal(0.5f);
        this.m_normals[0].set(v2).subLocal(v1);
        Vec2.crossToOut(this.m_normals[0], 1.0f, this.m_normals[0]);
        this.m_normals[0].normalize();
        this.m_normals[1].set(this.m_normals[0]).negateLocal();
    }

    @Override
    public final boolean testPoint(Transform xf, Vec2 p) {
        Vec2 pLocal = this.pool1;
        pLocal.set(p).subLocal(xf.position);
        Mat22.mulTransToOut(xf.R, pLocal, pLocal);
        if (m_debug) {
            System.out.println("--testPoint debug--");
            System.out.println("Vertices: ");
            for (int i = 0; i < this.m_vertexCount; ++i) {
                System.out.println(this.m_vertices[i]);
            }
            System.out.println("pLocal: " + pLocal);
        }
        Vec2 temp = this.pool2;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            temp.set(pLocal).subLocal(this.m_vertices[i]);
            float dot = Vec2.dot(this.m_normals[i], temp);
            if (!(dot > 0.0f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void computeAABB(AABB argAabb, Transform argXf) {
        Vec2 lower = this.pool1;
        Vec2 upper = this.pool2;
        Vec2 v = this.pool3;
        Transform.mulToOut(argXf, this.m_vertices[0], lower);
        upper.set(lower);
        for (int i = 1; i < this.m_vertexCount; ++i) {
            Transform.mulToOut(argXf, this.m_vertices[i], v);
            Vec2.minToOut(lower, v, lower);
            Vec2.maxToOut(upper, v, upper);
        }
        argAabb.lowerBound.x = lower.x - this.m_radius;
        argAabb.lowerBound.y = lower.y - this.m_radius;
        argAabb.upperBound.x = upper.x + this.m_radius;
        argAabb.upperBound.y = upper.y + this.m_radius;
    }

    public final int getVertexCount() {
        return this.m_vertexCount;
    }

    public final Vec2 getVertex(int index) {
        assert (0 <= index && index < this.m_vertexCount);
        return this.m_vertices[index];
    }

    @Override
    public final boolean raycast(RayCastOutput argOutput, RayCastInput argInput, Transform argXf) {
        Vec2 p1 = this.pool1;
        Vec2 p2 = this.pool2;
        Vec2 d = this.pool3;
        Vec2 temp = this.pool4;
        p1.set(argInput.p1).subLocal(argXf.position);
        Mat22.mulTransToOut(argXf.R, p1, p1);
        p2.set(argInput.p2).subLocal(argXf.position);
        Mat22.mulTransToOut(argXf.R, p2, p2);
        d.set(p2).subLocal(p1);
        if (this.m_vertexCount == 2) {
            Vec2 v1 = this.m_vertices[0];
            Vec2 v2 = this.m_vertices[1];
            Vec2 normal = this.m_normals[0];
            temp.set(v1).subLocal(p1);
            float numerator = Vec2.dot(normal, temp);
            float denominator = Vec2.dot(normal, d);
            if (denominator == 0.0f) {
                return false;
            }
            float t = numerator / denominator;
            if (t < 0.0f || 1.0f < t) {
                return false;
            }
            Vec2 q = this.pool5;
            Vec2 r = this.pool6;
            temp.set(d).mulLocal(t);
            q.set(p1).addLocal(temp);
            r.set(v2).subLocal(v1);
            float rr = Vec2.dot(r, r);
            if (rr == 0.0f) {
                return false;
            }
            temp.set(q).subLocal(v1);
            float s = Vec2.dot(temp, r) / rr;
            if (s < 0.0f || 1.0f < s) {
                return false;
            }
            argOutput.fraction = t;
            if (numerator > 0.0f) {
                argOutput.normal.set(normal).mulLocal(-1.0f);
            } else {
                argOutput.normal.set(normal);
            }
            return true;
        }
        float lower = 0.0f;
        float upper = argInput.maxFraction;
        int index = -1;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            temp.set(this.m_vertices[i]).subLocal(p1);
            float numerator = Vec2.dot(this.m_normals[i], temp);
            float denominator = Vec2.dot(this.m_normals[i], d);
            if (denominator == 0.0f) {
                if (numerator < 0.0f) {
                    return false;
                }
            } else if (denominator < 0.0f && numerator < lower * denominator) {
                lower = numerator / denominator;
                index = i;
            } else if (denominator > 0.0f && numerator < upper * denominator) {
                upper = numerator / denominator;
            }
            if (!(upper < lower)) continue;
            return false;
        }
        assert (0.0f <= lower && lower <= argInput.maxFraction);
        if (index >= 0) {
            argOutput.fraction = lower;
            Mat22.mulToOut(argXf.R, this.m_normals[index], argOutput.normal);
            return true;
        }
        return false;
    }

    public final void computeCentroidToOut(Vec2[] vs, int count, Vec2 out) {
        assert (count >= 3);
        out.set(0.0f, 0.0f);
        float area = 0.0f;
        if (count == 2) {
            out.set(vs[0]).addLocal(vs[1]).mulLocal(0.5f);
            return;
        }
        Vec2 pRef = this.pool1;
        pRef.setZero();
        Vec2 e1 = this.pool2;
        Vec2 e2 = this.pool3;
        float inv3 = 0.33333334f;
        for (int i = 0; i < count; ++i) {
            Vec2 p1 = pRef;
            Vec2 p2 = vs[i];
            Vec2 p3 = i + 1 < count ? vs[i + 1] : vs[0];
            e1.set(p2).subLocal(p1);
            e2.set(p3).subLocal(p1);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            e1.set(p1).addLocal(p2).addLocal(p3).mulLocal(triangleArea * 0.33333334f);
            out.addLocal(e1);
        }
        assert (area > 1.1920929E-7f);
        out.mulLocal(1.0f / area);
    }

    @Override
    public void computeMass(MassData massData, float density) {
        assert (this.m_vertexCount >= 2);
        if (this.m_vertexCount == 2) {
            massData.center.set(this.m_vertices[0]).addLocal(this.m_vertices[1]).mulLocal(0.5f);
            massData.mass = 0.0f;
            massData.I = 0.0f;
            return;
        }
        Vec2 center = this.pool1;
        center.setZero();
        float area = 0.0f;
        float I = 0.0f;
        Vec2 pRef = this.pool2;
        pRef.setZero();
        float k_inv3 = 0.33333334f;
        Vec2 e1 = this.pool3;
        Vec2 e2 = this.pool4;
        for (int i = 0; i < this.m_vertexCount; ++i) {
            Vec2 p1 = pRef;
            Vec2 p2 = this.m_vertices[i];
            Vec2 p3 = i + 1 < this.m_vertexCount ? this.m_vertices[i + 1] : this.m_vertices[0];
            e1.set(p2);
            e1.subLocal(p1);
            e2.set(p3);
            e2.subLocal(p1);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            center.x += triangleArea * 0.33333334f * (p1.x + p2.x + p3.x);
            center.y += triangleArea * 0.33333334f * (p1.y + p2.y + p3.y);
            float px = p1.x;
            float py = p1.y;
            float ex1 = e1.x;
            float ey1 = e1.y;
            float ex2 = e2.x;
            float ey2 = e2.y;
            float intx2 = 0.33333334f * (0.25f * (ex1 * ex1 + ex2 * ex1 + ex2 * ex2) + (px * ex1 + px * ex2)) + 0.5f * px * px;
            float inty2 = 0.33333334f * (0.25f * (ey1 * ey1 + ey2 * ey1 + ey2 * ey2) + (py * ey1 + py * ey2)) + 0.5f * py * py;
            I += D * (intx2 + inty2);
        }
        massData.mass = density * area;
        assert (area > 1.1920929E-7f);
        center.mulLocal(1.0f / area);
        massData.center.set(center);
        massData.I = I * density;
    }

    public Vec2[] getVertices() {
        return this.m_vertices;
    }

    public Vec2[] getNormals() {
        return this.m_normals;
    }

    public Vec2 centroid(Transform xf) {
        return Transform.mul(xf, this.m_centroid);
    }

    public Vec2 centroidToOut(Transform xf, Vec2 out) {
        Transform.mulToOut(xf, this.m_centroid, out);
        return out;
    }
}

