/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.shapes;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;

public class CircleShape
extends Shape {
    public final Vec2 m_p;
    private final Vec2 pool1 = new Vec2();
    private final Vec2 pool2 = new Vec2();
    private final Vec2 pool3 = new Vec2();

    public CircleShape() {
        this.m_type = ShapeType.CIRCLE;
        this.m_p = new Vec2();
        this.m_radius = 0.0f;
    }

    @Override
    public final Shape clone() {
        CircleShape shape = new CircleShape();
        shape.m_p.set(this.m_p);
        shape.m_radius = this.m_radius;
        return shape;
    }

    public final int getSupport(Vec2 d) {
        return 0;
    }

    public final Vec2 getSupportVertex(Vec2 d) {
        return this.m_p;
    }

    public final int getVertexCount() {
        return 1;
    }

    public final Vec2 getVertex(int index) {
        assert (index == 0);
        return this.m_p;
    }

    @Override
    public final boolean testPoint(Transform transform, Vec2 p) {
        Vec2 center = this.pool1;
        Mat22.mulToOut(transform.R, this.m_p, center);
        center.addLocal(transform.position);
        Vec2 d = center.subLocal(p).negateLocal();
        return Vec2.dot(d, d) <= this.m_radius * this.m_radius;
    }

    @Override
    public final boolean raycast(RayCastOutput argOutput, RayCastInput argInput, Transform argTransform) {
        Vec2 position = this.pool1;
        Vec2 s = this.pool2;
        Vec2 r = this.pool3;
        Mat22.mulToOut(argTransform.R, this.m_p, position);
        position.addLocal(argTransform.position);
        s.set(argInput.p1).subLocal(position);
        float b = Vec2.dot(s, s) - this.m_radius * this.m_radius;
        r.set(argInput.p2).subLocal(argInput.p1);
        float c = Vec2.dot(s, r);
        float rr = Vec2.dot(r, r);
        float sigma = c * c - rr * b;
        if (sigma < 0.0f || rr < 1.1920929E-7f) {
            return false;
        }
        float a = -(c + MathUtils.sqrt(sigma));
        if (0.0f <= a && a <= argInput.maxFraction * rr) {
            argOutput.fraction = a /= rr;
            argOutput.normal.set(r).mulLocal(a);
            argOutput.normal.addLocal(s);
            argOutput.normal.normalize();
            return true;
        }
        return false;
    }

    @Override
    public final void computeAABB(AABB argAabb, Transform argTransform) {
        Vec2 p = this.pool1;
        Mat22.mulToOut(argTransform.R, this.m_p, p);
        p.addLocal(argTransform.position);
        argAabb.lowerBound.x = p.x - this.m_radius;
        argAabb.lowerBound.y = p.y - this.m_radius;
        argAabb.upperBound.x = p.x + this.m_radius;
        argAabb.upperBound.y = p.y + this.m_radius;
    }

    @Override
    public final void computeMass(MassData massData, float density) {
        massData.mass = density * (float)Math.PI * this.m_radius * this.m_radius;
        massData.center.set(this.m_p);
        massData.I = massData.mass * (0.5f * this.m_radius * this.m_radius + Vec2.dot(this.m_p, this.m_p));
    }
}

