/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.RayCastOutput;
import org.jbox2d.collision.broadphase.BroadPhase;
import org.jbox2d.collision.broadphase.DynamicTreeNode;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.collision.shapes.ShapeType;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Filter;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactEdge;

public class Fixture {
    public final AABB m_aabb = new AABB();
    public float m_density;
    public Fixture m_next = null;
    public Body m_body = null;
    public Shape m_shape = null;
    public float m_friction;
    public float m_restitution;
    public DynamicTreeNode m_proxy = null;
    public final Filter m_filter;
    public boolean m_isSensor;
    public Object m_userData = null;
    private final AABB pool1 = new AABB();
    private final AABB pool2 = new AABB();

    public Fixture() {
        this.m_filter = new Filter();
    }

    public ShapeType getType() {
        return this.m_shape.getType();
    }

    public Shape getShape() {
        return this.m_shape;
    }

    public boolean isSensor() {
        return this.m_isSensor;
    }

    public void setSensor(boolean sensor) {
        this.m_isSensor = sensor;
    }

    public void setFilterData(Filter filter) {
        this.m_filter.set(filter);
        if (this.m_body == null) {
            return;
        }
        ContactEdge edge = this.m_body.getContactList();
        while (edge != null) {
            Contact contact = edge.contact;
            Fixture fixtureA = contact.getFixtureA();
            Fixture fixtureB = contact.getFixtureB();
            if (fixtureA == this || fixtureB == this) {
                contact.flagForFiltering();
            }
            edge = edge.next;
        }
    }

    public Filter getFilterData() {
        return this.m_filter;
    }

    public Body getBody() {
        return this.m_body;
    }

    public Fixture getNext() {
        return this.m_next;
    }

    public void setDensity(float density) {
        assert (density >= 0.0f);
        this.m_density = density;
    }

    public float getDensity() {
        return this.m_density;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object data) {
        this.m_userData = data;
    }

    public boolean testPoint(Vec2 p) {
        return this.m_shape.testPoint(this.m_body.m_xf, p);
    }

    public boolean raycast(RayCastOutput output, RayCastInput input) {
        return this.m_shape.raycast(output, input, this.m_body.m_xf);
    }

    public void getMassData(MassData massData) {
        this.m_shape.computeMass(massData, this.m_density);
    }

    public float getFriction() {
        return this.m_friction;
    }

    public void setFriction(float friction) {
        this.m_friction = friction;
    }

    public float getRestitution() {
        return this.m_restitution;
    }

    public void setRestitution(float restitution) {
        this.m_restitution = restitution;
    }

    public AABB getAABB() {
        return this.m_aabb;
    }

    public void create(Body body, FixtureDef def) {
        this.m_userData = def.userData;
        this.m_friction = def.friction;
        this.m_restitution = def.restitution;
        this.m_body = body;
        this.m_next = null;
        this.m_filter.set(def.filter);
        this.m_isSensor = def.isSensor;
        this.m_shape = def.shape.clone();
        this.m_density = def.density;
    }

    public void destroy() {
        assert (this.m_proxy == null);
        this.m_shape = null;
    }

    public void createProxy(BroadPhase broadPhase, Transform xf) {
        assert (this.m_proxy == null);
        this.m_shape.computeAABB(this.m_aabb, xf);
        this.m_proxy = broadPhase.createProxy(this.m_aabb, this);
    }

    public void destroyProxy(BroadPhase broadPhase) {
        if (this.m_proxy == null) {
            return;
        }
        broadPhase.destroyProxy(this.m_proxy);
        this.m_proxy = null;
    }

    protected void synchronize(BroadPhase broadPhase, Transform transform1, Transform transform2) {
        if (this.m_proxy == null) {
            return;
        }
        this.m_shape.computeAABB(this.pool1, transform1);
        this.m_shape.computeAABB(this.pool2, transform2);
        this.m_aabb.lowerBound.x = this.pool1.lowerBound.x < this.pool2.lowerBound.x ? this.pool1.lowerBound.x : this.pool2.lowerBound.x;
        this.m_aabb.lowerBound.y = this.pool1.lowerBound.y < this.pool2.lowerBound.y ? this.pool1.lowerBound.y : this.pool2.lowerBound.y;
        this.m_aabb.upperBound.x = this.pool1.upperBound.x > this.pool2.upperBound.x ? this.pool1.upperBound.x : this.pool2.upperBound.x;
        this.m_aabb.upperBound.y = this.pool1.upperBound.y > this.pool2.upperBound.y ? this.pool1.upperBound.y : this.pool2.upperBound.y;
        Vec2 disp = this.pool1.lowerBound;
        disp.x = transform2.position.x - transform1.position.x;
        disp.y = transform2.position.y - transform1.position.y;
        broadPhase.moveProxy(this.m_proxy, this.m_aabb, disp);
    }
}

