// Agenda Telefnica - Um exemplo de manipulao de
// arquivos utilizando a Linguagem "C"
// Faculdade Anhanguera de Jundia - Outubro de 2008

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ARQUIVO "agenda.txt"
#define TAM 100

using namespace std;

// Definir a estrutura que ser utilizada na criao e leitura 
// do arquivo
struct agenda
{ char nome[20];
  char telefone[20];
};

// Manipulador (HANDLE) para o arquivo
FILE *arquivo;

// Prottipo das funes que sero utilizadas pelo programa
void inserir();
void exibir();
void ordenar_e_exibir();
char *repetir (char caracter, int tamanho);

int main (int argc, char *argv[])
{ char opcao;
  do
  { system("CLS");
    printf("Agenda: (1) Incluir (2) Exibir (3) Ordenar e exibir (0) Fim. Opcao ?");
    // Antes de cada operao de leitura do teclado  importante 
    // utilizar o comando fflush para limpar o buffer do teclado
    fflush(stdin);
    opcao = getchar();
    if (opcao == '1')
      inserir();
    else if (opcao == '2')
      exibir();
    else if (opcao == '3')
      ordenar_e_exibir();
  } while (opcao != '0');
  return (0);
}
void inserir()
{ struct agenda a;
  if (arquivo = fopen(ARQUIVO, "a"))
  { // fopen - Abrir um arquivo
    // "r" - Abrir o arquivo para leitura, o arquivo dever 
    // existir previamente.
    // "w" - Cria e abre o arquivo para escrita. Se o arquivo 
    // existe o mesmo  apagado, se no existe  criado.
    // "a" - Inserir (Append) dados ao arquivo. Se o arquivo no 
    // existe o mesmo  criado, quando o arquivo existe as novas 
    // informaes so inseridas ao final do mesmo.
    printf("\nIncluir\n\n");
    printf("Nome....: "); fflush(stdin); gets(a.nome);
    printf("Telefone: "); fflush(stdin); gets(a.telefone);
    // fwrite - Escrever um registro no arquivo que foi aberto
    fwrite(&a, sizeof(a), 1, arquivo);
    // fclose - Fechar o arquivo que est aberto
    fclose(arquivo);
  }
  else
  { // Quando no  possvel abrir o arquivo a funo fopen
    // retorna NULO sendo, neste caso, necessrio fazer o 
    // tratamento de erro.
    printf("Erro: Nao foi possivel abrir o arquivo!\n");
    system ("PAUSE");
  }
}

void exibir()
{ struct agenda a;
  if (arquivo = fopen(ARQUIVO, "r"))
  { printf("\nExibir\n\n");
    printf("Nome                 Telefone\n");
    printf("%s\n", repetir('-', 40));
    // fread - realiza a leitura de um registro do arquivo e
    // armazena em uma varivel, quando colocado dentro de
    // uma estrutura de repetio realiza a leitura at
    // atingir o fim do arquivo (EOF)
    while (fread(&a, sizeof(agenda), 1, arquivo))
      printf("%-20s %-20s\n", a.nome, a.telefone);
    fclose(arquivo);
    printf("%s\n\n", repetir('-', 40));
  }
  else
  { printf("Erro: Nao foi possivel abrir o arquivo!\n");
  }
  system ("PAUSE");
}
void ordenar_e_exibir()
{ struct agenda a[TAM];
  struct agenda auxiliar;
  int i, j, menor, registros;

  if (arquivo = fopen(ARQUIVO, "r"))
  { registros = 0;
    // Ler o arquivo e armazenar na estrutura (vetor)
    while (fread(&a[registros], sizeof(agenda), 1, arquivo))
    { // Identificar quantos registros (linhas) foram lidos
      registros++;
    }
    fclose(arquivo);

    // Ordenar a estrutura aplicando, neste exemplo, o algoritmo
    // de ordenao por seleo e utilizando, como chave, o nome
    for (i = 0; i < (registros - 1); i++)
    { menor = i;
      for (j = i + 1; j < registros; j++)
      { if (strcmp(a[j].nome, a[menor].nome) < 0)
          menor = j;
      }
      auxiliar = a[menor];
      a[menor] = a[i];
      a[i] = auxiliar;
    }

    i = 0;
    // Imprimir o vetor contendo a estrutura j ordenada
    printf("\nExibir ordenado\n\n");
    printf("Nome                 Telefone\n");
    printf("%s\n", repetir('-', 40));
    for (i = 0; i < registros; i++)
    { printf("%-20s %-20s\n", a[i].nome, a[i].telefone);
    }
    printf("%s\n\n", repetir('-', 40));
  }
  else
  { printf("Erro: Nao foi possivel abrir o arquivo!\n");
  }
  system ("PAUSE");
}

 
char *repetir (char caracter, int tamanho)
{ // Retorna uma string contendo "n" vezes o caracter que 
  // foi passado como parmetro
  char *resultado = (char *) malloc(tamanho + 1);
  char *retorno = resultado;
  for (int i = 0; i < tamanho; i++)
    *resultado++ = caracter;
  *resultado = (char) NULL;
  return (retorno);
}
