package br.ifba.ads.inf008.imc.ui;

import java.io.FileNotFoundException;
import java.io.IOException;

import br.ifba.ads.inf008.imc.model.CalculaIMCApp;
import br.ifba.ads.inf008.imc.model.FichaIMC;
import br.ifba.ads.inf008.imc.model.ICalculaIMCApp;

public abstract class IMCUI {
	

	protected ICalculaIMCApp app;
	
	public IMCUI() throws FileNotFoundException, ClassNotFoundException, IOException{
		this.app = new CalculaIMCApp();
	}		
	
	public abstract void run(String[] args) throws Exception;

	public void salvar(String nome, double peso, long altura) throws Exception{
		this.app.salvar(nome, peso, altura);		
	}
	
	public void calcularIMC(String nome, double peso, long altura){
		FichaIMC ficha = this.app.calcularIMC(nome, peso, altura);
		this.printFichaApp(ficha);
	}

	public void calcularIMC(String nome) throws Exception{
		FichaIMC ficha = this.app.calcularIMC(nome);
		this.printFichaApp(ficha);
	}	
	
	public void printFichaApp(FichaIMC ficha){
		System.out.println("**********************************************************");
		System.out.println("Nome: " + ficha.getNome());
		System.out.println("IMC: " + ficha.getImc());
		System.out.println("Classificacao: " + ficha.getClassificacaoIMC());
		System.out.println("**********************************************************");
	}

}
