package jdbc.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TesteConexaoPostGres {
	
	private final String uri = "jdbc:postgresql://localhost:5432/postgres";
	private final String selectPessoa = "SELECT nome, peso, altura FROM PESSOA";
	private final String insertPessoa = "INSERT INTO PESSOA (NOME, PESO, ALTURA) VALUES (?, ?, ?)";	
	private Connection conn;
	private Statement stmt;
	private PreparedStatement pStmt;	
	private ResultSet rSet;
	
	
	public void registrarDrive() throws ClassNotFoundException, SQLException{
		Class.forName("org.postgresql.Driver");
//		DriverManager.registerDriver(new org.postgresql.Driver());
		this.conn = DriverManager.getConnection(uri);
	}
	
	public void consultarBanco() throws SQLException{
		this.stmt = this.conn.createStatement();
		this.rSet = this.stmt.executeQuery(selectPessoa);

	}
	
	
	public void inserirBanco() throws SQLException{
		this.pStmt = this.conn.prepareStatement(insertPessoa);
		this.pStmt.setString(1, "JOAO");
		this.pStmt.setDouble(2, 80.0);		
		this.pStmt.setLong(3, 180);
		int i = this.pStmt.executeUpdate();
		
		System.out.println(i + " linhas afetadas");

	}
		
	
	public void processarRSet() throws SQLException{
		String nome;
		double peso;
		long altura;
		
		while(this.rSet.next()){
			nome = this.rSet.getString("nome");
			peso = this.rSet.getDouble("peso");
			altura = this.rSet.getLong("altura");
			System.out.println(nome + " - " + peso + " - " + altura);
		}
		
	}	
	
	public void fecharBanco() throws SQLException{
		this.rSet.close();
		this.stmt.close();
		this.conn.close();
	}	
	
	public void rodar() throws ClassNotFoundException, SQLException{
		this.registrarDrive();
//		this.consultarBanco();
		this.inserirBanco();
//		this.processarRSet();
		this.fecharBanco();
		
	}
	
	public static void main(String[] args) throws ClassNotFoundException, SQLException {
		(new TesteConexaoPostGres()).rodar();
		System.out.println("Finalizando...");
	}
	

}
