#include <stdio.h>
#define WIDTH 10
#define HEIGHT 10
#define CHANNELS 3 
#define RED 0
#define GREEN 1
#define BLUE 2

void main() {
    int rgbImage[HEIGHT][WIDTH][CHANNELS]; 
    int grayScaleImage[HEIGHT][WIDTH]; 
    int iCont, jCont;
    int r, g, b, gray;
    
/*
    for (iCont = 0; iCont < HEIGHT; iCont++)
        for (jCont = 0; jCont < WIDTH; jCont++)
		  scanf("%d %d %d", &rgbImage[iCont][jCont][RED], &rgbImage[iCont][jCont][GREEN], &rgbImage[iCont][jCont][BLUE]);
*/


    //Preenchendo a imagem RGB com dados fictícios...substituir por ler os valores
    for (iCont = 0; iCont < HEIGHT; iCont++) {
        for (jCont = 0; jCont < WIDTH; jCont++) {
            rgbImage[iCont][jCont][RED] = (iCont * 100 + jCont) % 256;       // R
            rgbImage[iCont][jCont][GREEN] = (iCont * 200 + jCont) % 256;   // G
            rgbImage[iCont][jCont][BLUE] = (iCont * 300 + jCont) % 256;   // B
        }    
    }

    //Exemplo específico da questão: R=200, G=150, B=100 -> Cinza=159
    rgbImage[0][0][0] = 200;
    rgbImage[0][0][1] = 150;
    rgbImage[0][0][2] = 100;


    for (iCont = 0; iCont < HEIGHT; iCont++) {
        for (jCont = 0; jCont < WIDTH; jCont++) {
            r = rgbImage[iCont][jCont][RED];
            g = rgbImage[iCont][jCont][GREEN];
            b = rgbImage[iCont][jCont][BLUE];
            gray = 0.299 * r + 0.587 * g + 0.114 * b;
            grayScaleImage[iCont][jCont] = gray;
        }
    }


    for (iCont = 0; iCont < HEIGHT; iCont++) {
        for (jCont = 0; jCont < WIDTH; jCont++) {
            printf("%03x ", grayScaleImage[iCont][jCont]);
        }
        printf("\n");
    }

}