/*
 * Decompiled with CFR 0.152.
 */
package principal.cli;

import controlador.Diagrama;
import controlador.Editor;
import desenho.FormaElementar;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import principal.cli.MasterCli;
import principal.cli.Sintaxe;
import principal.cli.Variavel;
import util.Utilidades;

public class CliDiagramaProcessador {
    public HashMap<String, String> Ambiente = new HashMap();
    public final String varScrPosX = "amb.scr.x";
    public final String varScrPosY = "amb.scr.y";
    public final String varObjW = "amb.obj.w";
    public final String varObjH = "amb.obj.h";
    public final MasterCli CLI;
    public final String cmdSAIR = "sair";
    public final String cmdLISTAR = "listar";
    public final String cmdSET = "set";
    public final String cmdCLEAR = "cls";
    public final String msgNOTHING = "$$NOTHING$$123##123##CARLOS.H.CANDIDO";
    public final String msgOK = "ok";
    public final String msgERRO = "erro";
    public final ArrayList<Sintaxe> Comandos = new ArrayList();
    public HashMap<String, Variavel> Vars = new HashMap();
    public final String varPrefix = "$$var_";
    private boolean entradaTexto = false;
    String promptNormal = "";
    String promptEntradaTexto = ".>";
    StringBuilder buffer = new StringBuilder();
    private String erroMsg = "";
    private boolean writeNothing = false;
    private boolean lastCmdErro = false;
    private boolean justNewLine = true;
    private Diagrama diag = null;

    public void SetDirectVar(String var, String value) {
        this.Ambiente.put(var, value);
    }

    public void carregueVarsAmbiente() {
        this.Ambiente.put("amb.scr.x", "200");
        this.Ambiente.put("amb.scr.y", "200");
        this.Ambiente.put("amb.obj.w", "120");
        this.Ambiente.put("amb.obj.h", "58");
    }

    public CliDiagramaProcessador(MasterCli cli) {
        this.CLI = cli;
        this.promptNormal = cli.getPrompt();
        this.Comandos.add(new Sintaxe("sair"));
        this.Comandos.add(new Sintaxe("listar"));
        this.Comandos.add(new Sintaxe("cls"));
        Sintaxe cmdset = new Sintaxe("set");
        Sintaxe cmdamb = cmdset.AddProx("ambient");
        cmdamb.AddProx(new String[][]{{"amb.scr.x", "variavelnum"}, {"amb.scr.y", "variavelnum"}, {"amb.obj.w", "variavelnum"}, {"amb.obj.h", "variavelnum"}});
        this.Comandos.add(cmdset);
        this.carregueVarsAmbiente();
    }

    public void setEntradaTexto(boolean entradaTexto) {
        this.entradaTexto = entradaTexto;
        if (entradaTexto) {
            this.CLI.setPrompt(this.promptEntradaTexto);
            this.buffer = new StringBuilder();
        } else {
            this.CLI.setPrompt(this.promptNormal);
        }
    }

    public boolean isEntradaTexto() {
        return this.entradaTexto;
    }

    private String processaChavesParenteses(String comm) {
        ArrayList<String> pilha = new ArrayList<String>();
        char last = '!';
        for (char a : comm.toCharArray()) {
            if (a == '{' || a == '(') {
                last = a;
                pilha.add(String.valueOf(a));
                continue;
            }
            if (a != '}' && a != 41) continue;
            if (a == '}' && last == '{' || a == ')' && last == '(') {
                if (pilha.isEmpty()) {
                    return "erro";
                }
                pilha.remove(pilha.size() - 1);
                if (pilha.isEmpty()) continue;
                last = ((String)pilha.get(pilha.size() - 1)).charAt(0);
                continue;
            }
            return "erro";
        }
        if (!pilha.isEmpty()) {
            return "TXT";
        }
        return "$$NOTHING$$123##123##CARLOS.H.CANDIDO";
    }

    public boolean isWriteNothing() {
        return this.writeNothing;
    }

    public String processeComando(String comm) {
        String res;
        if (comm.isEmpty()) {
            return "$$NOTHING$$123##123##CARLOS.H.CANDIDO";
        }
        this.writeNothing = false;
        this.setJustNewLine(true);
        this.setLastCmdErro(false);
        this.Vars.clear();
        if (this.isEntradaTexto()) {
            this.buffer.append(comm);
            comm = this.buffer.toString();
            res = this.processaChavesParenteses(comm);
            if (res.equals("erro")) {
                this.setEntradaTexto(false);
                this.setLastCmdErro(true);
                return Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcli001");
            }
            if (res.equals("TXT")) {
                this.buffer.append("\n");
                return "$$NOTHING$$123##123##CARLOS.H.CANDIDO";
            }
            comm = this.buffer.toString();
            this.setEntradaTexto(false);
        } else {
            res = this.processaChavesParenteses(comm);
            if (res.equals("TXT")) {
                this.setEntradaTexto(true);
                this.buffer.append(comm).append("\n");
                return "$$NOTHING$$123##123##CARLOS.H.CANDIDO";
            }
            if (res.equals("erro")) {
                this.setLastCmdErro(true);
                return Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcli001");
            }
        }
        ArrayList<String> cmds = this.processadorMor(comm);
        if (this.isLastCmdErro()) {
            return this.getmsgErro() + " " + Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcli001");
        }
        if (!cmds.isEmpty() && this.RunCMD(cmds)) {
            if (this.writeNothing) {
                return "$$NOTHING$$123##123##CARLOS.H.CANDIDO";
            }
            return this.getmsgOk();
        }
        if (this.isLastCmdErro()) {
            return Utilidades.EncapsuleMsg("msgcli002", this.getmsgErro(), this.getErroMsg());
        }
        return Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcli003");
    }

    public boolean isCMD(String incmd, String comando) {
        String[] cmds;
        for (String str : cmds = this.getComando(comando).split("\\|")) {
            if (!str.equals(incmd)) continue;
            return true;
        }
        return false;
    }

    public void setErroMsg(String erroMsg) {
        this.erroMsg = erroMsg;
    }

    public boolean isLastCmdErro() {
        return this.lastCmdErro;
    }

    public void setLastCmdErro(boolean lastCmdErro) {
        this.lastCmdErro = lastCmdErro;
    }

    public String getErroMsg() {
        return this.erroMsg;
    }

    public String doCancel() {
        this.Vars.clear();
        this.setEntradaTexto(false);
        return "^D";
    }

    public String getComando(String partCap) {
        return Editor.fromConfiguracao.getValor("Controler.cli.cmd." + partCap.toLowerCase());
    }

    public String getSintaxe(String partCap) {
        return Editor.fromConfiguracao.getValor("Controler.cli.exp." + partCap.toLowerCase());
    }

    public String getPrincipalCMD(String partCap) {
        return this.getSintaxe(partCap).split("\\|")[0];
    }

    public String getDica(String partCapDica) {
        return Editor.fromConfiguracao.getValor("Controler.cli.dica." + partCapDica.toLowerCase());
    }

    public String getMsg(String partCapDica) {
        return Editor.fromConfiguracao.getValor("Controler.cli.msg." + partCapDica.toLowerCase());
    }

    public String getmsgOk() {
        return this.getMsg("ok");
    }

    public String getmsgErro() {
        return this.getMsg("erro");
    }

    public boolean isJustNewLine() {
        return this.justNewLine;
    }

    public void setJustNewLine(boolean justNewLine) {
        this.justNewLine = justNewLine;
    }

    public ArrayList<String> processadorMor(String comm) {
        ArrayList<String> res = new ArrayList<String>();
        if (comm.isEmpty()) {
            return res;
        }
        this.setLastCmdErro(false);
        String tmp = this.processaChavesParenteses(comm);
        if (tmp.equals("erro")) {
            this.setLastCmdErro(true);
            return res;
        }
        comm = this.removaConteiner(comm, this.Vars);
        String[] comms = comm.replaceAll(" +", " ").split(" ");
        res = new ArrayList<String>(Arrays.asList(comms));
        return res;
    }

    public String removaConteiner(String comm, HashMap<String, Variavel> vars) {
        int ini = -1;
        char cp = '!';
        int idx = -1;
        String bkp = comm;
        for (char a : comm.toCharArray()) {
            ++idx;
            if (a != '{' && a != 40) continue;
            cp = a;
            ini = idx;
            break;
        }
        if (ini > -1) {
            char achar = cp == '{' ? (char)'}' : ')';
            int qtd = 0;
            idx = -1;
            int fim = -1;
            for (char a : comm.toCharArray()) {
                ++idx;
                if (a == cp) {
                    ++qtd;
                }
                if (a == achar) {
                    --qtd;
                }
                if (idx <= ini || qtd != 0) continue;
                fim = idx;
                break;
            }
            String tmp = comm.substring(ini + 1, fim);
            Variavel var = new Variavel();
            var.setNome("$$var_" + String.valueOf(this.Vars.size()));
            var.setOriginal(comm.substring(ini, fim + 1));
            var.setValor(tmp);
            this.Vars.put(var.getNome(), var);
            comm = (ini > 0 ? comm.substring(0, ini) + " " : "") + var.getNome() + " " + (fim < comm.length() - 1 ? comm.substring(fim + 1) : "");
        }
        if (comm.equals(bkp)) {
            return comm;
        }
        return this.removaConteiner(comm, vars);
    }

    public String DoAutoComplete(String palavra) {
        if (this.isEntradaTexto()) {
            return "";
        }
        if ((palavra = palavra.trim()).isEmpty()) {
            return "";
        }
        this.setLastCmdErro(false);
        this.Vars.clear();
        ArrayList<String> comm = this.processadorMor(palavra);
        if (this.isLastCmdErro()) {
            return "";
        }
        int nv = -1;
        Sintaxe hlp = null;
        for (Sintaxe sx : this.Comandos) {
            int tmp = sx.getNivelDeValidade(comm);
            if (tmp <= nv) continue;
            hlp = sx;
            nv = tmp;
        }
        if (hlp != null) {
            String res = hlp.AutoComplete(comm);
            return this.restoreVars(res);
        }
        return "";
    }

    public boolean RunCMD(ArrayList<String> comm) {
        Sintaxe hlp = null;
        int nv = -1;
        for (Sintaxe sx : this.Comandos) {
            ArrayList<Sintaxe> cadeia;
            if (sx.isValido(cadeia = new ArrayList<Sintaxe>(), comm)) {
                return this.ProcesseComandoValido(cadeia, comm);
            }
            int tmp = sx.getNivelDeValidade(comm);
            if (tmp <= nv) continue;
            hlp = sx;
            nv = tmp;
        }
        if (hlp != null) {
            this.CLI.doShowMsg(Utilidades.EncapsuleMsg("msgcli004", hlp.getSintaxe(comm)));
        }
        return false;
    }

    public boolean ProcesseComandoValido(ArrayList<Sintaxe> cadeia, ArrayList<String> comm) {
        Sintaxe sx = cadeia.get(0);
        if (sx.getComando().equals("sair")) {
            this.CLI.Sair();
            return true;
        }
        if (sx.getComando().equals("cls")) {
            this.CLI.Clear();
            this.writeNothing = true;
            return true;
        }
        if (sx.getComando().equals("listar")) {
            for (Sintaxe sx2 : this.Comandos) {
                StringBuilder r = new StringBuilder();
                sx2.Listar(r, "");
                this.CLI.doShowMsg(r.toString());
            }
            for (String k : this.Ambiente.keySet()) {
                this.CLI.doShowMsg(this.getBestCMD(k) + "=" + this.Ambiente.get(k));
            }
            return true;
        }
        if (sx.getComando().equals("set")) {
            return this.processeComandoSet(cadeia, comm);
        }
        return false;
    }

    private String restoreVars(String cmd) {
        for (String k : this.Vars.keySet()) {
            String javaReplaceDollarDaErro = "\\$\\$" + k.substring(2);
            cmd = cmd.replaceFirst(javaReplaceDollarDaErro, this.Vars.get(k).getOriginal());
        }
        return cmd;
    }

    public Point restoreVarToPoint(String var) {
        try {
            String res = this.Vars.get(var).getValor();
            String[] spt = res.trim().replaceAll(" ", "").split(",");
            if (spt.length < 2) {
                return new Point(-1, -1);
            }
            int x = Integer.parseInt(spt[0]);
            int y = Integer.parseInt(spt[1]);
            if (x < 0 || y < 0) {
                return new Point(-1, -1);
            }
            return new Point(x, y);
        }
        catch (NullPointerException | NumberFormatException numberFormatException) {
            return new Point(-1, -1);
        }
    }

    public Diagrama getDiag() {
        return this.diag;
    }

    public void setDiag(Diagrama diag) {
        this.diag = diag;
    }

    protected boolean processeComandoSet(ArrayList<Sintaxe> cadeia, ArrayList<String> comm) {
        Sintaxe sx = cadeia.get(1);
        if (sx.getComando().equals("ambient")) {
            this.CLI.doShowMsg(this.getBestCMD(cadeia.get(2).getComando()) + " = " + this.Empilhe(cadeia.get(2).getComando(), comm.get(3)));
            if (!this.isLastCmdErro()) {
                return true;
            }
        }
        return false;
    }

    public String Empilhe(String comando, String var) {
        String res = this.Vars.get(var).getValor().trim();
        String tmp = Utilidades.TryIntStr(res, "0");
        this.Ambiente.put(comando, res);
        if (!tmp.equals(res)) {
            this.setLastCmdErro(true);
            this.CLI.doShowMsg(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcli005"));
        }
        return res;
    }

    public int getAmbientInteger(String var) {
        return Integer.parseInt(this.Ambiente.get(var));
    }

    public String getBestCMD(String partCap) {
        return Editor.fromConfiguracao.getValor("Controler.cli.exp." + partCap.toLowerCase()).split("\\|")[0];
    }

    public boolean IsCommandGetID(String txt) {
        return txt.matches("GET\\(*[0-9]\\)");
    }

    public FormaElementar GetByID(String var) {
        String r;
        String tmp;
        if (this.IsCommandGetID(var.toUpperCase()) && !(tmp = Utilidades.TryIntStr(r = var.substring(4, var.length() - 1).trim(), "-1")).equals("-1")) {
            return this.getDiag().FindByID(Integer.parseInt(r));
        }
        return null;
    }
}

