/*
 * Decompiled with CFR 0.152.
 */
package diagramas.fluxo;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Desenhador;
import desenho.formas.Forma;
import desenho.formas.Legenda;
import desenho.linhas.Linha;
import desenho.linhas.PontoDeLinha;
import desenho.preAnyDiagrama.PreLigacaoSeta;
import diagramas.conceitual.Texto;
import diagramas.fluxo.FluxConector;
import diagramas.fluxo.FluxDecisao;
import diagramas.fluxo.FluxDocumento;
import diagramas.fluxo.FluxIniFim;
import diagramas.fluxo.FluxLigacao;
import diagramas.fluxo.FluxNota;
import diagramas.fluxo.FluxProcesso;
import diagramas.fluxo.FluxSeta;
import diagramas.fluxo.FluxTexto;
import diagramas.fluxo.FluxVDocumentos;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public class DiagramaFluxo
extends Diagrama {
    private static final long serialVersionUID = 8966014390922983766L;
    private final Class[] classesDoDiagrama = new Class[]{FluxIniFim.class, FluxProcesso.class, FluxConector.class, FluxDecisao.class, FluxDocumento.class, FluxVDocumentos.class, FluxNota.class, FluxLigacao.class, FluxSeta.class, FluxTexto.class, Texto.class, Desenhador.class, Legenda.class};

    public DiagramaFluxo(Editor omaster) {
        super(omaster);
        this.setTipo(Diagrama.TipoDeDiagrama.tpFluxo);
        this.meusComandos.add(Controler.Comandos.cmdFluxIniFim.name());
        this.meusComandos.add(Controler.Comandos.cmdFluxProcesso.name());
        this.meusComandos.add(Controler.Comandos.cmdFluxConector.name());
        this.meusComandos.add(Controler.Comandos.cmdFluxDecisao.name());
        this.meusComandos.add(Controler.Comandos.cmdFluxDocumento.name());
        this.meusComandos.add(Controler.Comandos.cmdFluxLigacao.name());
        this.meusComandos.add(Controler.Comandos.cmdFluxSeta.name());
        this.meusComandos.add(Controler.Comandos.cmdFluxVDocumentos.name());
        this.meusComandos.add(Controler.Comandos.cmdFluxNota.name());
    }

    @Override
    public Class[] getCassesDoDiagrama() {
        return this.classesDoDiagrama;
    }

    @Override
    protected FormaElementar RealiseComando(Point posi) {
        this.ClearSelect(false);
        FormaElementar resu = null;
        Controler.Comandos com = this.getComando();
        switch (com) {
            case cmdFluxIniFim: {
                FluxIniFim fif = new FluxIniFim(this, FluxIniFim.class.getSimpleName());
                fif.SetBounds(posi.x, posi.y, 80, 30);
                fif.Reenquadre();
                resu = fif;
                break;
            }
            case cmdFluxSeta: 
            case cmdFluxLigacao: {
                if (this.cliq1 == null) {
                    Elementar res = this.CaptureFromPoint(posi);
                    FormaElementar obj1 = null;
                    if (res instanceof FormaElementar) {
                        obj1 = (FormaElementar)res;
                    }
                    this.cliq1 = new Diagrama.clickForma(obj1, posi);
                    return null;
                }
                if (this.cliq2 == null) {
                    FormaElementar obj2 = null;
                    Elementar res = this.CaptureFromPoint(posi);
                    if (res instanceof FormaElementar) {
                        obj2 = (FormaElementar)res;
                    }
                    this.cliq2 = new Diagrama.clickForma(obj2, posi);
                }
                PreLigacaoSeta linha = com == Controler.Comandos.cmdFluxSeta ? new FluxSeta(this) : new FluxLigacao(this);
                resu = linha;
                Point pt1 = this.cliq1.getPonto();
                Point pt2 = this.cliq2.getPonto();
                linha.Inicie(new Rectangle(pt2.x, pt2.y, pt1.x - pt2.x, pt1.y - pt2.y));
                if (com != Controler.Comandos.cmdFluxSeta) break;
                Forma pa = linha.getFormaPontaA();
                Forma pb = linha.getFormaPontaB();
                this.prepareLinha(pa, linha);
                this.prepareLinha(pb, linha);
                break;
            }
            case cmdFluxProcesso: {
                FluxProcesso fp = new FluxProcesso(this, FluxProcesso.class.getSimpleName());
                fp.SetBounds(posi.x, posi.y, 120, 58);
                fp.Reenquadre();
                resu = fp;
                break;
            }
            case cmdFluxDocumento: {
                FluxDocumento fdo = new FluxDocumento(this, FluxDocumento.class.getSimpleName());
                fdo.SetBounds(posi.x, posi.y, 120, 58);
                fdo.Reenquadre();
                resu = fdo;
                break;
            }
            case cmdFluxVDocumentos: {
                FluxVDocumentos fdos = new FluxVDocumentos(this, FluxVDocumentos.class.getSimpleName());
                fdos.SetBounds(posi.x, posi.y, 120, 58);
                fdos.Reenquadre();
                resu = fdos;
                break;
            }
            case cmdFluxNota: {
                FluxNota fdosn = new FluxNota(this, FluxNota.class.getSimpleName());
                fdosn.SetBounds(posi.x, posi.y, 120, 80);
                fdosn.Reenquadre();
                resu = fdosn;
                break;
            }
            case cmdFluxDecisao: {
                FluxDecisao fd = new FluxDecisao(this, FluxDecisao.class.getSimpleName());
                fd.SetBounds(posi.x, posi.y, 100, 40);
                fd.Reenquadre();
                resu = fd;
                break;
            }
            case cmdFluxConector: {
                FluxConector fc = new FluxConector(this, FluxConector.class.getSimpleName());
                fc.SetBounds(posi.x, posi.y, 30, 30);
                fc.Reenquadre();
                resu = fc;
            }
        }
        if (resu == null) {
            resu = super.RealiseComando(posi);
        } else {
            this.cliq1 = null;
            this.cliq2 = null;
            if (!this.master.isControlDown()) {
                this.setComando(null);
            } else {
                this.setComando(com);
            }
            resu.BringToFront();
        }
        return resu;
    }

    private void prepareLinha(Forma formaPonta, PreLigacaoSeta linha) {
        if (formaPonta instanceof FluxDecisao) {
            ArrayList<PontoDeLinha> lst = formaPonta.getListaDePontosLigados();
            int i = 0;
            while (i < lst.size()) {
                if (!(lst.get(i).getDono() instanceof FluxSeta)) {
                    lst.remove(i);
                    continue;
                }
                ++i;
            }
            if (lst.size() == 2) {
                Linha l = lst.get(0).getDono() == linha ? lst.get(1).getDono() : lst.get(0).getDono();
                ((FluxSeta)linha).setPositivo(!((FluxSeta)l).isPositivo());
            }
            ((FluxSeta)linha).getTexto().setSize(new Dimension(40, 20));
        }
    }
}

