/*
 * Decompiled with CFR 0.152.
 */
package diagramas.conceitual;

import controlador.Diagrama;
import controlador.inspector.InspectorProperty;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.linhas.PontoDeLinha;
import desenho.preAnyDiagrama.PreCardinalidade;
import desenho.preAnyDiagrama.PreEntidade;
import desenho.preAnyDiagrama.PreLigacao;
import desenho.preAnyDiagrama.PreRelacionamento;
import diagramas.conceitual.Cardinalidade;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XMLGenerate;

public class Ligacao
extends PreLigacao {
    private static final long serialVersionUID = -8105972246347830149L;

    public Ligacao(Diagrama modelo) {
        super(modelo);
    }

    public Ligacao(Diagrama modelo, Cardinalidade aCard) {
        super(modelo, aCard);
    }

    public void SuperInicie(int tlPt, Point ptPrimeiro, Point ptFinal) {
        this.Inicie(tlPt, ptPrimeiro, ptFinal);
        this.AnexePontos();
        this.OrganizeLinha();
        this.reSetBounds();
    }

    public void SuperSetInteligente(boolean sn) {
        this.SetInteligente(sn);
        this.OrganizeLinha();
    }

    public boolean LigaComEntFraca() {
        return this.isDuplaLinha();
    }

    public boolean LigaRelacaoEntidade() {
        Forma fa = this.getFormaPontaA();
        Forma fb = this.getFormaPontaB();
        return !(!(fa instanceof PreEntidade) && !(fb instanceof PreEntidade) || !(fa instanceof PreRelacionamento) && !(fb instanceof PreRelacionamento));
    }

    public String getPapel() {
        if (this.getCard() != null) {
            return this.getCard().getPapel();
        }
        return "";
    }

    public void setPapel(String papel) {
        if (this.getCard() != null) {
            this.getCard().setPapel(papel);
        }
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        for (InspectorProperty iip : res) {
            if (iip.tipo != InspectorProperty.TipoDeProperty.tpNumero) continue;
            iip.tipo = InspectorProperty.TipoDeProperty.tpApenasLeituraTexto;
        }
        res.add(InspectorProperty.PropertyFactoryCor("forecolor", "setForeColor", this.getForeColor()));
        res.add(InspectorProperty.PropertyFactorySN("linha.auto", "SuperSetInteligente", this.isInteligente()));
        if (this.LigaRelacaoEntidade()) {
            res.add(InspectorProperty.PropertyFactorySeparador("mer"));
            res.add(InspectorProperty.PropertyFactoryTexto("cardinalidade.papel", "setPapel", this.getPapel()));
            res.add(InspectorProperty.PropertyFactorySN("linha.entidadefraca", "setDuplaLinha", this.LigaComEntFraca()));
        }
        return res;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        NodeList nl = me.getElementsByTagName("Bounds");
        me.removeChild(nl.item(0));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Inteligente", this.isInteligente()));
        if (!this.getForeColor().equals(Elementar.defaultColor)) {
            me.appendChild(XMLGenerate.ValorColor(doc, "ForeColor", this.getForeColor()));
        }
        me.appendChild(XMLGenerate.ValorInteger(doc, "Largura", (int)this.getLargura()));
        Element lig = doc.createElement("Ligacoes");
        XMLGenerate.AtributoRefFormElementar(lig, "PontaA", this.getFormaPontaA());
        XMLGenerate.AtributoRefFormElementar(lig, "PontaB", this.getFormaPontaB());
        me.appendChild(lig);
        Element sbPontos = doc.createElement("Pontos");
        for (PontoDeLinha pl : this.getPontos()) {
            sbPontos.appendChild(XMLGenerate.ValorPoint(doc, "Ponto", pl.getLocation()));
        }
        me.appendChild(sbPontos);
        PreCardinalidade card = this.getCard();
        if (card != null) {
            card.ToXlm(doc, me);
        }
    }

    @Override
    public boolean CommitXML(Element me, HashMap<Element, FormaElementar> mapa) {
        FormaElementar resB;
        Element lig = XMLGenerate.FindByNodeName(me, "Ligacoes");
        String idPt = lig.getAttribute("PontaA");
        FormaElementar resA = XMLGenerate.FindWhoHasID(idPt, mapa);
        if (resA instanceof Forma) {
            this.getPontaA().SetEm((Forma)resA);
        }
        if ((resB = XMLGenerate.FindWhoHasID(idPt = lig.getAttribute("PontaB"), mapa)) instanceof Forma) {
            this.getPontaB().SetEm((Forma)resB);
        }
        if (resA instanceof Forma) {
            ((Forma)resA).PosicionePonto(this.getPontaA());
        }
        if (resB instanceof Forma) {
            ((Forma)resB).PosicionePonto(this.getPontaB());
        }
        this.OrganizeLinha();
        this.PrepareCardinalidade();
        return super.CommitXML(me, mapa);
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        int l;
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        this.setInteligente(XMLGenerate.getValorBooleanFrom(me, "Inteligente"));
        Color c = XMLGenerate.getValorColorFrom(me, "ForeColor");
        if (c != null) {
            this.setForeColor(c);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Largura")) != -1) {
            this.setLargura(l);
        }
        NodeList ptLst = me.getElementsByTagName("Pontos");
        Element pontos = (Element)ptLst.item(0);
        ptLst = pontos.getChildNodes();
        this.Inicie(ptLst.getLength() - 2, new Point(20, 20), new Point(40, 40));
        ArrayList<PontoDeLinha> arrpontos = this.getPontos();
        for (int i = 0; i < ptLst.getLength(); ++i) {
            Point p = XMLGenerate.getValorPoint((Element)ptLst.item(i));
            arrpontos.get(i).setLocation(p);
        }
        ptLst = me.getElementsByTagName(Cardinalidade.class.getSimpleName());
        if (ptLst.getLength() > 0) {
            Element ecard = (Element)ptLst.item(0);
            this.addCard();
            PreCardinalidade card = this.getCard();
            if (card != null) {
                card.LoadFromXML(ecard, colando);
            }
        }
        return true;
    }

    private void removeCar() {
        PreCardinalidade card = this.getCard();
        if (card == null) {
            return;
        }
        this.setCard(null);
        card.Fixe(null);
        card.setCanBeDeleted(true);
        this.getMaster().Remove(card, true);
    }

    private void addCard() {
        PreCardinalidade card = this.getCard();
        if (card != null) {
            return;
        }
        this.setCard(new Cardinalidade(this.getMaster(), "Cardinalidade"));
    }

    @Override
    public void PrepareCardinalidade() {
        if (this.getPontaA() == null || this.getPontaB() == null) {
            this.removeCar();
            return;
        }
        if (!this.getPontaA().isEstaLigado() || !this.getPontaB().isEstaLigado()) {
            PreCardinalidade card = this.getCard();
            if (card != null) {
                card.Fixe(null);
            }
            return;
        }
        boolean t1 = this.getFormaPontaA() instanceof PreEntidade;
        boolean t1b = this.getFormaPontaB() instanceof PreRelacionamento;
        if (t1 && t1b) {
            this.addCard();
            PreCardinalidade card = this.getCard();
            card.setVisible(true);
            card.Fixe(this.getPontaA());
            card.Posicione();
            return;
        }
        boolean t2 = this.getFormaPontaB() instanceof PreEntidade;
        boolean t2b = this.getFormaPontaA() instanceof PreRelacionamento;
        if (t2 && t2b) {
            this.addCard();
            PreCardinalidade card = this.getCard();
            card.setVisible(true);
            card.Fixe(this.getPontaB());
            card.Posicione();
            return;
        }
        this.removeCar();
    }
}

