/*
 * Decompiled with CFR 0.152.
 */
package diagramas.conceitual;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.formas.Forma;
import desenho.preAnyDiagrama.PreEntidade;
import desenho.preAnyDiagrama.PreEspecializacao;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Especializacao
extends PreEspecializacao {
    private static final long serialVersionUID = 3595682719755602909L;

    public Especializacao(Diagrama modelo) {
        super(modelo);
        this.nodic = false;
        this.paintParcial = true;
    }

    public Especializacao(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.nodic = false;
        this.paintParcial = true;
    }

    @Override
    public boolean isParcial() {
        return this.getListaDeFormasLigadas().size() > 1 && this.LigadaAoPontoPrincipal() != null && super.isParcial();
    }

    public boolean isTotal() {
        return !this.isParcial() && this.LigadaAoPontoPrincipal() != null;
    }

    public void setTotal(boolean sn) {
        this.setParcial(!sn);
    }

    public boolean isNaoExclusiva() {
        PreEntidade tmp = this.LigadaAoPontoPrincipal();
        return this.getListaDeFormasLigadas().size() > 1 && tmp != null && tmp.getListaDeFormasLigadas().stream().filter(f -> f instanceof Especializacao).map(e -> (Especializacao)e).filter(e -> e.LigadaAoPontoPrincipal() == tmp).count() > 1L;
    }

    public boolean isExclusiva() {
        PreEntidade tmp = this.LigadaAoPontoPrincipal();
        return this.getListaDeFormasLigadas().size() > 1 && tmp != null && tmp.getListaDeFormasLigadas().stream().filter(f -> f instanceof Especializacao).map(e -> (Especializacao)e).filter(e -> e.LigadaAoPontoPrincipal() == tmp).count() == 1L;
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        res.add(InspectorProperty.PropertyFactoryMenu("direcao", "setDirecaoFromInspector", this.getDirecaoForInspector(), Editor.fromConfiguracao.getLstDirecao(Controler.Comandos.cmdEspecializacao)));
        if (!this.isExclusiva() && !this.isNaoExclusiva() || !this.isParcial() && !this.isTotal()) {
            res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("especializacao.formacao", Editor.fromConfiguracao.getValor("Inspector.obj.especializacao.malformada")));
        } else {
            res.add(InspectorProperty.PropertyFactorySN("especializacao.parcial", "setParcial", this.isParcial()));
            res.add(InspectorProperty.PropertyFactorySN("especializacao.total", "setTotal", this.isTotal()));
            res.add(InspectorProperty.PropertyFactoryApenasLeituraSN("especializacao.exclusiva", this.isExclusiva()));
            res.add(InspectorProperty.PropertyFactoryApenasLeituraSN("especializacao.naoexclusiva", this.isNaoExclusiva()));
        }
        PreEntidade pe = this.LigadaAoPontoPrincipal();
        if (pe != null) {
            res.add(InspectorProperty.PropertyFactoryActionSelect(Editor.fromConfiguracao.getValor("Inspector.obj.especializacao.apartirde"), pe.getTexto(), String.valueOf(pe.getID())));
        } else {
            res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("especializacao.apartirde", "{}"));
        }
        return res;
    }

    @Override
    protected boolean FinderLinked(Forma quem, Forma origem) {
        ArrayList<Forma> outras = this.getListaDeFormasLigadas(origem);
        for (Forma f : outras) {
            if (f == quem) {
                return true;
            }
            List esp = f.getListaDeFormasLigadas(Especializacao.class).stream().filter(o -> o != this).map(o -> (Especializacao)o).collect(Collectors.toList());
            if (!esp.stream().anyMatch(f2 -> f2.FinderLinked(quem, f))) continue;
            return true;
        }
        return false;
    }
}

