/*
 * Decompiled with CFR 0.152.
 */
package desenho.formas;

import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.linhas.PontoDeLinha;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.DesenhadorDeTexto;
import util.TratadorDeImagens;
import util.Utilidades;
import util.XMLGenerate;

public class Legenda
extends Forma {
    private static final long serialVersionUID = -706529994751090967L;
    private final ArrayList<ItemDeLegenda> Itens = new ArrayList();
    private Color BorderColor = Color.LIGHT_GRAY;
    private TipoLegenda tipo = TipoLegenda.tpCores;
    private int altura = 22;
    private int alturaTitulo = 22;

    public Legenda(Diagrama modelo) {
        super(modelo);
        this.SetTexto(Editor.fromConfiguracao.getValor("diagrama.Legenda"));
    }

    public void addLegenda(String res, Color c) {
        this.addLegenda(res, c, 0);
    }

    public void addLegenda(String res, Color c, int tag) {
        this.getItens().add(new ItemDeLegenda(res, c, tag));
        int tam = (this.altura + 4) * this.getItens().size() + this.alturaTitulo;
        if (tam != this.getHeight()) {
            this.setHeight(tam);
            this.Reposicione();
        } else {
            this.InvalidateArea();
        }
    }

    protected void AddLegenda(String res, Color c, int tag) {
        this.getItens().add(new ItemDeLegenda(res, c, tag));
    }

    @Override
    public void mouseDblClicked(MouseEvent e) {
        super.mouseDblClicked(e);
        if (this.getTipo() == TipoLegenda.tpCores) {
            this.LoadColorList();
        }
    }

    public void LoadColorList() {
        ArrayList co = new ArrayList();
        this.getMaster().getListaDeItens().stream().forEach(fe -> fe.PoluleColors(co));
        this.getItens().stream().map(it -> co.indexOf(it.cor)).filter(tmp -> tmp > -1).forEach(tmp -> co.remove(tmp));
        co.stream().forEach(c -> this.addLegenda("?", (Color)c));
        this.DoMuda();
    }

    public void setTextLegenda(int selectedIndex, String res) {
        this.getItens().get((int)selectedIndex).texto = res;
    }

    public void RefreshInpector() {
        if (this.isSelecionado()) {
            this.getMaster().getEditor().PerformInspectorFor(this);
            this.InvalidateArea();
        }
    }

    public boolean canShowEditor() {
        return this.getTipo() != TipoLegenda.tpObjetos;
    }

    private void SelecioneLegenda(MouseEvent e) {
        boolean ja = false;
        for (ItemDeLegenda leg : this.getItens()) {
            Rectangle r;
            leg.setSelecionada(false);
            if (ja || !(r = new Rectangle(this.getLeft(), leg.Area.x, this.getWidth(), leg.Area.y)).contains(e.getPoint())) continue;
            ja = true;
            leg.setSelecionada(true);
        }
        this.InvalidateArea();
    }

    public void SelecioneLegenda(int idx) {
        boolean ja = false;
        int i = -1;
        for (ItemDeLegenda leg : this.getItens()) {
            leg.setSelecionada(false);
            if (ja || ++i != idx) continue;
            ja = true;
            leg.setSelecionada(true);
        }
        this.InvalidateArea();
    }

    public ArrayList<ItemDeLegenda> getItens() {
        return this.Itens;
    }

    public void RemoveLegenda(int index) {
        try {
            this.getItens().remove(index);
            this.InvalidateArea();
        }
        catch (Exception e) {
            return;
        }
        int tam = (this.altura + 4) * this.getItens().size() + 2 * this.altura - 4;
        if (tam != this.getHeight()) {
            this.setHeight(tam);
            this.Reposicione();
        } else {
            this.InvalidateArea();
        }
    }

    public Color getBorderColor() {
        return this.isDisablePainted() ? this.disabledColor : this.BorderColor;
    }

    public void setBorderColor(Color BorderColor) {
        this.BorderColor = BorderColor;
        this.InvalidateArea();
    }

    @Override
    public void SetTexto(String Texto2) {
        super.SetTexto(Texto2);
    }

    @Override
    public DesenhadorDeTexto getTextoFormatado() {
        DesenhadorDeTexto dz = super.getTextoFormatado();
        dz.setCentrarTextoVertical(false);
        dz.setCentrarTextoHorizontal(true);
        dz.LimitarAreaDePintura = true;
        dz.CorretorPosicao = new Point(0, 6);
        return dz;
    }

    public TipoLegenda getTipo() {
        return this.tipo;
    }

    public void setTipo(TipoLegenda tipo) {
        if (this.tipo != tipo) {
            this.tipo = tipo;
            this.getItens().clear();
            this.DoMuda();
            this.InvalidateArea();
        }
    }

    public void SetTipo(int tpForInspector) {
        try {
            this.setTipo(TipoLegenda.values()[tpForInspector]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void DoPaint(Graphics2D g) {
        super.DoPaint(g);
        Rectangle rec = this.getArea();
        Color bkpc = g.getColor();
        g.setColor(this.getBorderColor());
        g.drawRect(rec.x, rec.y, rec.width, rec.height);
        Rectangle bkp = g.getClipBounds();
        g.clipRect(rec.x, rec.y, rec.width, rec.height);
        Font fn = this.getFont();
        Font font = new Font(fn.getFontName(), fn.getStyle(), fn.getSize() - 2);
        fn = g.getFont();
        g.setFont(font);
        this.altura = g.getFontMetrics().getHeight() + g.getFontMetrics().getDescent();
        this.alturaTitulo = this.altura + this.altura / 2;
        Composite originalComposite = g.getComposite();
        float alfa = 0.8f;
        g.setComposite(AlphaComposite.getInstance(3, alfa));
        if (this.getTipo() == TipoLegenda.tpObjetos) {
            this.altura = Math.max(32, this.altura);
        }
        int posi = this.altura + this.alturaTitulo + rec.y;
        int lft = rec.x + 2;
        for (ItemDeLegenda it : this.getItens()) {
            if (it.isSelecionada()) {
                g.setColor(this.isDisablePainted() ? this.disabledColor : new Color(204, 204, 255, 50));
                g.fillRect(lft, posi - this.altura - 2, this.getWidth(), this.altura + 4);
            }
            g.setColor(this.isDisablePainted() ? this.disabledColor : it.cor);
            switch (this.getTipo()) {
                case tpLinhas: {
                    int moveleft = 3 * this.altura;
                    g.fillRoundRect(lft, posi - this.altura / 2 - 2, moveleft - 2, 4, 2, 2);
                    g.setColor(bkpc);
                    g.drawString(it.texto, lft + moveleft, posi - 6);
                    break;
                }
                case tpObjetos: {
                    ImageIcon img = Editor.fromControler().getImagemNormal(this.getMaster().getCassesDoDiagrama()[it.getTag()].getSimpleName());
                    g.drawImage(TratadorDeImagens.ReColorBlackImg(img, it.getCor()), lft, posi - this.altura, null);
                    int moveleft = this.altura + 2;
                    g.drawString(it.texto, lft + moveleft, posi - this.altura / 2 + 6);
                    break;
                }
                default: {
                    int moveleft = this.altura;
                    g.fillRect(lft, posi - this.altura, this.altura - 4, this.altura - 4);
                    g.setColor(bkpc);
                    g.drawRect(lft, posi - this.altura, this.altura - 4, this.altura - 4);
                    g.drawString(it.texto, lft + moveleft, posi - 6);
                }
            }
            it.Area = new Point(posi - this.altura - 2, this.altura + 4);
            posi += this.altura + 4;
        }
        g.setComposite(originalComposite);
        g.setClip(bkp);
        g.setFont(fn);
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        res.add(InspectorProperty.PropertyFactoryCor("bordercolor", "setBorderColor", this.getBorderColor()));
        res.add(InspectorProperty.PropertyFactoryMenu("legenda.tipo", "SetTipo", this.getTipo().ordinal(), Editor.fromConfiguracao.getLstTipoLegenda()).AddCondicao(new String[]{String.valueOf(TipoLegenda.tpCores.ordinal())}, new String[]{FormaElementar.nomeComandos.cmdDoAnyThing.name()}).AddCondicao(new String[]{String.valueOf(TipoLegenda.tpCores.ordinal()), String.valueOf(TipoLegenda.tpLinhas.ordinal())}, new String[]{FormaElementar.nomeComandos.cmdDlgLegenda.name()}));
        res.add(InspectorProperty.PropertyFactorySeparador("desenho"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDlgLegenda.name()));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdAdicionarSubItem.name()).setTag(-1));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "legenda.capturar").setTag(124));
        InspectorProperty tmp = InspectorProperty.FindByProperty(res, "setTextoAdicional");
        if (tmp != null) {
            res.remove(tmp);
        }
        tmp = InspectorProperty.FindByProperty(res, "setForeColor");
        tmp.ReSetCaptionFromConfig("texto.forecolor");
        int i = 0;
        for (ItemDeLegenda it : this.getItens()) {
            if (it.isSelecionada()) {
                res.add(InspectorProperty.PropertyFactorySeparador("legenda.legenda.sel", false));
            } else {
                res.add(InspectorProperty.PropertyFactorySeparador("legenda.legenda", true));
            }
            res.add(InspectorProperty.PropertyFactoryTexto("legenda.texto", "setLegendaTexto", it.getTexto()).setTag(i));
            res.add(InspectorProperty.PropertyFactoryCor("legenda.cor", "setLegendaCor", it.getCor()).setTag(i));
            if (!this.canShowEditor()) {
                ArrayList<String> objs = new ArrayList<String>();
                for (Class cl : this.getMaster().getCassesDoDiagrama()) {
                    objs.add(Editor.fromConfiguracao.getValor("diagrama." + cl.getSimpleName() + ".nome"));
                }
                res.add(InspectorProperty.PropertyFactoryMenu("legenda.objs", "setLegendaTag", it.getTag(), objs).setTag(i));
            }
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdExcluirSubItem.name()).setTag(i));
            ++i;
        }
        return res;
    }

    public void setLegendaTexto(String txt) {
        if (this.getMaster().getEditor().getInspectorEditor().getSelecionado() == null) {
            return;
        }
        int tag = this.getMaster().getEditor().getInspectorEditor().getSelecionado().getTag();
        ItemDeLegenda leg = this.getItens().get(tag);
        leg.texto = txt;
        this.DoMuda();
        this.SelecioneLegenda(tag);
        this.InvalidateArea();
    }

    public void setLegendaTag(int tg) {
        if (this.getMaster().getEditor().getInspectorEditor().getSelecionado() == null) {
            return;
        }
        int tag = this.getMaster().getEditor().getInspectorEditor().getSelecionado().getTag();
        ItemDeLegenda leg = this.getItens().get(tag);
        leg.setTag(tg);
        this.DoMuda();
        this.SelecioneLegenda(tag);
        this.InvalidateArea();
    }

    public void setLegendaCor(Color cor) {
        if (this.getMaster().getEditor().getInspectorEditor().getSelecionado() == null) {
            return;
        }
        int tag = this.getMaster().getEditor().getInspectorEditor().getSelecionado().getTag();
        ItemDeLegenda leg = this.getItens().get(tag);
        leg.cor = cor;
        this.DoMuda();
        this.SelecioneLegenda(tag);
        this.InvalidateArea();
    }

    @Override
    protected void DoPaintDoks(Graphics2D g) {
    }

    @Override
    public boolean CanLiga(PontoDeLinha aThis) {
        return false;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorText(doc, "Diagrama", this.getMaster().getTipoDeDiagramaFormatado()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Tipo", this.getTipo().ordinal()));
        Element sbItens = doc.createElement("Itens");
        for (ItemDeLegenda il : this.getItens()) {
            sbItens.appendChild(XMLGenerate.ValorLegenda(doc, il.getTexto(), "Texto", il.getCor(), "Cor", il.getTag(), "Tag"));
        }
        me.appendChild(sbItens);
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        String tpdiag = XMLGenerate.getValorTextoFrom(me, "Diagrama");
        this.SetTipo(XMLGenerate.getValorIntegerFrom(me, "Tipo"));
        if (this.getTipo() == TipoLegenda.tpObjetos && !this.getMaster().getTipoDeDiagramaFormatado().equals(tpdiag)) {
            return true;
        }
        NodeList ptLst = me.getElementsByTagName("Itens");
        Element eitens = (Element)ptLst.item(0);
        ptLst = eitens.getChildNodes();
        for (int i = 0; i < ptLst.getLength(); ++i) {
            Node tmp = ptLst.item(i);
            if (tmp.getNodeType() != 1) continue;
            Element e = (Element)ptLst.item(i);
            String txt = e.getAttribute("Texto");
            Color c = Utilidades.StringToColor(e.getAttribute("Cor"));
            int tag = Integer.valueOf(e.getAttribute("Tag"));
            this.AddLegenda(txt, c, tag);
        }
        this.InvalidateArea();
        return true;
    }

    @Override
    public void ExcluirSubItem(int idx) {
        super.ExcluirSubItem(idx);
        this.RemoveLegenda(idx);
    }

    @Override
    public void AdicionarSubItem(int idx) {
        this.addLegenda("?", Color.BLACK);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ItemDeLegenda leg2;
        ItemDeLegenda leg = null;
        if (this.isSelecionado()) {
            leg = this.getItens().stream().filter(it -> it.isSelecionada()).findAny().orElse(null);
        }
        if (this.isSelecionavel()) {
            this.SelecioneLegenda(e);
        }
        super.mousePressed(e);
        if (leg != null && (leg2 = (ItemDeLegenda)this.getItens().stream().filter(it -> it.isSelecionada()).findAny().orElse(null)) != null && leg != leg2) {
            this.getMaster().PerformInspector(true);
        }
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 124 && this.getTipo() == TipoLegenda.tpCores) {
            this.LoadColorList();
        }
    }

    public static enum TipoLegenda {
        tpCores,
        tpLinhas,
        tpObjetos;

    }

    public class ItemDeLegenda
    implements Serializable {
        protected int tag = 0;
        protected String texto;
        protected Color cor;
        private boolean selecionada = false;
        protected transient Point Area = new Point(0, 0);

        public ItemDeLegenda(String texto, Color cor, int tag) {
            this.texto = texto;
            this.cor = cor;
            this.tag = tag;
        }

        public void setTag(int tag) {
            this.tag = tag;
        }

        public int getTag() {
            return this.tag;
        }

        public String getTexto() {
            return this.texto;
        }

        public Color getCor() {
            return this.cor;
        }

        public boolean isSelecionada() {
            return this.selecionada;
        }

        public void setSelecionada(boolean selecionada) {
            this.selecionada = selecionada;
        }
    }
}

