/*
 * Decompiled with CFR 0.152.
 */
package desenho.formas;

import controlador.Diagrama;
import controlador.Editor;
import controlador.apoios.TreeItem;
import controlador.inspector.InspectorProperty;
import desenho.Elementar;
import desenho.ElementarListener;
import desenho.FormaElementar;
import desenho.PontoElementar;
import desenho.formas.PontoDeForma;
import desenho.linhas.Linha;
import desenho.linhas.PontoDeLinha;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DesenhadorDeTexto;
import util.Utilidades;
import util.XMLGenerate;

public class Forma
extends FormaElementar {
    private static final long serialVersionUID = 632178864799887969L;
    private PontoElementar[] Pontos = new PontoElementar[8];
    private transient boolean overMe = false;
    private String Texto = "";
    private DesenhadorDeTexto TextoFormatado;
    private String observacao = "";
    private String textoAdicional = "";
    transient boolean dragging = false;
    transient boolean jaSel = false;
    private transient double z = 0.0;
    protected boolean needRecalPts = true;
    protected Point pontoPosi4;
    protected Point pontoPosi5;
    protected Point pontoPosi6;
    protected Point pontoPosi7;
    protected Point pontoPosi0;
    protected Point pontoPosi1;
    protected Point pontoPosi2;
    protected Point pontoPosi3;
    private Forma principal = null;
    public boolean nodic = true;
    public boolean editFonte = true;
    protected final int CONST_ORG_DIAG = 70;
    protected boolean showOrgDiag = false;
    protected int INI_ORGDIAG = 0;

    public Forma(Diagrama diagrama) {
        super(diagrama);
        this.InitPontos();
        this.SetBounds(10, 10, 150, 100);
        this.setBackColor(new Color(255, 0, 0, 128));
    }

    private void InitPontos() {
        PontoElementar[] pontos = this.getPontos();
        for (int i = 0; i < pontos.length; ++i) {
            pontos[i] = new PontoDeForma(this);
        }
    }

    public Forma(Diagrama diagrama, String texto) {
        this(diagrama);
        this.SetTexto(diagrama.Nomeie(texto));
    }

    public PontoElementar[] getPontos() {
        return this.Pontos;
    }

    public void setPontos(PontoElementar[] Pontos) {
        this.Pontos = Pontos;
    }

    public boolean isOverMe() {
        return this.overMe;
    }

    @Override
    public void setOverMe(boolean overMe) {
        if (overMe != this.overMe) {
            this.overMe = overMe;
            this.InvalidateArea();
        }
    }

    public String getTexto() {
        return this.Texto;
    }

    public void setTexto(String Texto2) {
        this.SetTexto(Texto2);
        this.InvalidateArea();
    }

    public DesenhadorDeTexto getTextoFormatado() {
        if (this.TextoFormatado == null) {
            this.TextoFormatado = new DesenhadorDeTexto(this.getTexto(), this.getFont(), this.isCentrarTexto());
        }
        return this.TextoFormatado;
    }

    public void setTextoFormatado(DesenhadorDeTexto textoFormatado) {
        this.TextoFormatado = textoFormatado;
    }

    public void SetTexto(String Texto2) {
        if (this.Texto.equals(Texto2)) {
            return;
        }
        this.Texto = Texto2;
        this.getTextoFormatado().setTexto(Texto2);
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        if (!this.observacao.equals(observacao)) {
            this.observacao = observacao;
        }
    }

    public String getTextoAdicional() {
        return this.textoAdicional;
    }

    public void setTextoAdicional(String textoAdicional) {
        if (!this.textoAdicional.equals(textoAdicional)) {
            this.textoAdicional = textoAdicional;
        }
    }

    @Override
    public void setFont(Font font) {
        this.getTextoFormatado().setFont(font);
        super.setFont(font);
    }

    protected boolean isCentrarTexto() {
        return true;
    }

    public void menosLigacao(PontoDeLinha aThis) {
    }

    public void maisLigacao(PontoDeLinha aThis) {
    }

    protected void PropagueResizeParaLigacoes() {
        this.SendNotificacao(4);
    }

    @Override
    public void reSetBounds() {
        PontoElementar[] pontos = this.getPontos();
        int espacoI = 2;
        int mW = pontos[0].getWidth() + espacoI;
        int mH = pontos[0].getHeight() + espacoI;
        int H = pontos[2].getTop() - pontos[0].getTop() - (mH + espacoI);
        int W = pontos[2].getLeft() - pontos[0].getLeft() - (mW + espacoI);
        int L = pontos[0].getLeft() + mW;
        int T = pontos[0].getTop() + mH;
        if (W < 10 || H < 10) {
            this.Reposicione();
            return;
        }
        Rectangle ret = new Rectangle(this.getLeft() - L, this.getTop() - T, this.getWidth() - W, this.getHeight() - H);
        this.DoFormaResize(ret);
    }

    @Override
    public void reSetBounds(int posicao, int xleft, int ytop) {
        PontoElementar[] pontos = this.getPontos();
        switch (posicao) {
            case 0: {
                pontos[posicao].setLocation(xleft, ytop);
                break;
            }
            case 1: {
                pontos[posicao].setLocation(xleft, ytop);
                pontos[0].setTop(ytop);
                pontos[2].setLeft(xleft);
                break;
            }
            case 2: {
                pontos[posicao].setLocation(xleft, ytop);
                break;
            }
            case 3: {
                pontos[posicao].setLocation(xleft, ytop);
                pontos[2].setTop(ytop);
                pontos[0].setLeft(xleft);
                break;
            }
            case 4: {
                pontos[posicao].setTop(ytop);
                pontos[0].setTop(ytop);
                break;
            }
            case 5: {
                pontos[posicao].setLeft(xleft);
                pontos[2].setLeft(xleft);
                break;
            }
            case 6: {
                pontos[posicao].setTop(ytop);
                pontos[2].setTop(ytop);
                break;
            }
            case 7: {
                pontos[posicao].setLeft(xleft);
                pontos[0].setLeft(xleft);
            }
        }
        this.reSetBounds();
    }

    @Override
    public void setSelecionado(boolean selecionado) {
        super.setSelecionado(selecionado);
        PontoElementar[] pontos = this.getPontos();
        if (selecionado) {
            for (int i = 0; i < pontos.length; ++i) {
                pontos[i].setPosicao(i);
                pontos[i].setVisible(true);
            }
        } else {
            for (int i = 0; i < pontos.length; ++i) {
                pontos[i].setVisible(false);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        super.mouseDragged(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point enddown;
        this.dragging = false;
        boolean bkp = this.isRaiseMuda();
        if (bkp) {
            this.setRaiseMuda(false);
        }
        super.mouseReleased(e);
        if (bkp) {
            this.setRaiseMuda(true);
        }
        if (this.jaSel) {
            boolean combine;
            boolean bl = combine = this.getMaster().isShiftDown() || this.getMaster().isControlDown();
            if (combine) {
                this.getMaster().DiagramaDoSelecao(this, true, false);
            }
        }
        if (!(enddown = new Point(e.getX(), e.getY())).equals(this.getIniDown())) {
            this.DoMuda();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isSelecionado()) {
            this.getMaster().DiagramaDoSelecao(this, true, false);
            this.jaSel = false;
        } else {
            this.jaSel = true;
        }
        super.mousePressed(e);
    }

    @Override
    public void DoPontoCor(boolean verde) {
        PontoElementar[] pontos = this.getPontos();
        Color cor = verde ? this.getMaster().getPontoCorMultSel() : this.getMaster().getPontoCor();
        for (PontoElementar ponto : pontos) {
            ponto.setBackColor(cor);
        }
    }

    @Override
    public void Reposicione() {
        PontoElementar[] pontos = this.getPontos();
        if (pontos[0] == null) {
            return;
        }
        for (int i = 0; i < pontos.length; ++i) {
            pontos[i].setPosicao(i);
        }
    }

    @Override
    public void PinteSelecao(Graphics2D g) {
        super.PinteSelecao(g);
        if (!this.isSelecionado() || this.isPontosIsHide()) {
            return;
        }
        PontoElementar[] pontos = this.getPontos();
        Stroke bkp = g.getStroke();
        g.setStroke(new BasicStroke(1.0f, 1, 1, 2.0f, new float[]{2.0f, 2.0f}, 0.0f));
        g.setPaint(pontos[0].getBackColor());
        Point p1 = pontos[0].getCentro();
        Point p2 = pontos[2].getCentro();
        g.drawRect(p1.x, p1.y, p2.x - p1.x, p2.y - p1.y);
        g.setStroke(bkp);
    }

    public void DoFormaResize(Rectangle ret) {
        if (this.isSelecionado()) {
            this.getMaster().DoFormaResize(ret);
        }
    }

    public void ReciveFormaResize(Rectangle ret) {
        int H = this.getHeight() - ret.height;
        int W = this.getWidth() - ret.width;
        if (W < 10 && !this.isParte()) {
            W = 10;
        }
        if (H < 10 && !this.isParte()) {
            H = 10;
        }
        this.SetBounds(this.getLeft() - ret.x, this.getTop() - ret.y, W, H);
        this.Reposicione();
        this.PropagueResizeParaLigacoes();
    }

    @Override
    public void DoRaizeReenquadreReposicione() {
        this.getMaster().DoBaseReenquadreReposicione();
    }

    @Override
    public void DoRaiseMove(int movX, int movY) {
        super.DoRaiseMove(movX, movY);
        this.getMaster().ReciveProcessMove(this, movX, movY);
    }

    @Override
    public void DoMove(int movX, int movY) {
        super.DoMove(movX, movY);
        this.SendNotificacao(new Point(movX, movY), 2);
    }

    @Override
    protected void BeforeReenquadre(int movidoX, int movidoY) {
        super.BeforeReenquadre(movidoX, movidoY);
        this.SendNotificacao(new Point(movidoX, movidoY), 3);
    }

    @Override
    public void HidePontos(boolean esconde) {
        PontoElementar[] pontos;
        super.HidePontos(esconde);
        for (PontoElementar ponto : pontos = this.getPontos()) {
            ponto.setIsHide(esconde);
        }
        this.InvalidateArea(this.getSuperArea());
    }

    public Rectangle getSuperArea() {
        int espacoL = 2;
        int mW = this.getMaster().getPontoWidth() + espacoL;
        int mH = this.getMaster().getPontoHeigth() + espacoL;
        Rectangle rec = this.getClientRectangle().getBounds();
        rec.grow(mW, mH);
        return rec;
    }

    @Override
    public void DoPaint(Graphics2D g) {
        super.DoPaint(g);
        this.PinteTexto(g);
        if (this.dragging && this.getMaster().getEditor().isMostrarDimensoesAoMover()) {
            Stroke bkp = g.getStroke();
            Paint bkpP = g.getPaint();
            g.setStroke(new BasicStroke(1.0f, 1, 1, 2.0f, new float[]{2.0f, 2.0f}, 0.0f));
            g.setPaint(Color.gray);
            g.drawLine(0, this.getTop(), this.getMaster().getWidth(), this.getTop());
            g.drawLine(this.getLeft(), 0, this.getLeft(), this.getMaster().getHeight());
            Font bkpf = g.getFont();
            Font f = this.getMaster().getFont();
            g.setFont(new Font(f.getName(), 2, f.getSize() - 2));
            g.drawString("[" + String.valueOf(this.getLeft()) + "," + String.valueOf(this.getTop()) + "]", this.getLeft() + 4, this.getTop() - 4);
            g.setFont(bkpf);
            g.setStroke(bkp);
            g.setPaint(bkpP);
        }
        if (this.isOverMe()) {
            this.DoPaintDoks(g);
        }
    }

    protected void DoPaintDoks(Graphics2D g) {
        Rectangle rec = Utilidades.Grow(this.getBounds(), 1, 1, -1);
        Paint bkpP = g.getPaint();
        g.setPaint(Color.yellow);
        g.drawRect(rec.x, rec.y, rec.width, rec.height);
        g.setPaint(bkpP);
    }

    public void PinteTexto(Graphics2D g) {
        if (this.getMaster().getZoom() != this.z) {
            this.TextoFormatado = null;
            this.z = this.getMaster().getZoom();
        }
        this.getTextoFormatado().PinteTexto(g, this.getForeColor(), this.getArea(), this.getTexto());
    }

    public Rectangle getArea() {
        return this.getBounds();
    }

    public void PontoReciveDblClick(PontoDeLinha ponto, MouseEvent e) {
    }

    @Override
    public void ReSized() {
        super.ReSized();
        this.needRecalPts = true;
    }

    protected void calculePontos() {
        if (!this.needRecalPts) {
            return;
        }
        Rectangle r = new Rectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        this.pontoPosi4 = new Point(r.x + r.width / 2, r.y);
        this.pontoPosi5 = new Point(r.x + r.width, r.y + r.height / 2);
        this.pontoPosi6 = new Point(r.x + r.width / 2, r.y + r.height);
        this.pontoPosi7 = new Point(r.x, r.y + r.height / 2);
        this.pontoPosi0 = new Point(this.pontoPosi7.x, this.pontoPosi4.y);
        this.pontoPosi1 = new Point(this.pontoPosi5.x, this.pontoPosi4.y);
        this.pontoPosi2 = new Point(this.pontoPosi5.x, this.pontoPosi6.y);
        this.pontoPosi3 = new Point(this.pontoPosi7.x, this.pontoPosi6.y);
        this.needRecalPts = false;
    }

    public Point[] getPontosColaterais() {
        this.calculePontos();
        return new Point[]{this.pontoPosi7, this.pontoPosi4, this.pontoPosi5, this.pontoPosi6};
    }

    public Point[] getPontosLaterais() {
        this.calculePontos();
        return new Point[]{this.pontoPosi0, this.pontoPosi1, this.pontoPosi2, this.pontoPosi3};
    }

    public Point[] getPontosCalculados() {
        this.calculePontos();
        return new Point[]{this.pontoPosi7, this.pontoPosi4, this.pontoPosi5, this.pontoPosi6, this.pontoPosi0, this.pontoPosi1, this.pontoPosi2, this.pontoPosi3};
    }

    public void PosicionePonto(PontoDeLinha ponto) {
        Point centro = ponto.getCentro();
        int mx = this.retorneProximidade(centro);
        int recuo = -1;
        switch (mx) {
            case 0: {
                ponto.setLado(0);
                ponto.setLeft(this.getLeft() - ponto.getWidth() / 2 + recuo);
                break;
            }
            case 1: {
                ponto.setLado(1);
                ponto.setTop(this.getTop() - ponto.getHeight() / 2 + recuo);
                break;
            }
            case 2: {
                ponto.setLado(2);
                ponto.setLeft(this.getLeftWidth() - ponto.getWidth() / 2);
                break;
            }
            case 3: {
                ponto.setLado(3);
                ponto.setTop(this.getTopHeight() - ponto.getHeight() / 2);
            }
        }
    }

    public int retorneProximidade(Point centro) {
        Rectangle r = new Rectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        int[] vl = new int[4];
        vl[0] = centro.x - r.x;
        vl[2] = r.x + r.width - centro.x;
        vl[1] = centro.y - r.y;
        vl[3] = r.y + r.height - centro.y;
        int mx = 0;
        for (int i = 1; i < 4; ++i) {
            if (vl[mx] <= vl[i]) continue;
            mx = i;
        }
        return mx;
    }

    public void OrganizeLigacoes() {
        this.SendNotificacao(6);
    }

    public boolean CanLiga(PontoDeLinha aThis) {
        Linha l = aThis.getDono();
        return this.CanLiga(l.getOutraPonta(aThis.getEm()), l);
    }

    public boolean CanLiga(Forma forma, Linha lin) {
        return forma != this;
    }

    public ArrayList<PontoDeLinha> getListaDePontosLigados() {
        ArrayList<PontoDeLinha> res = new ArrayList<PontoDeLinha>();
        List<ElementarListener> lst = this.getListeners();
        if (lst != null) {
            for (ElementarListener el : lst) {
                if (!(el instanceof PontoDeLinha) || ((PontoDeLinha)el).getEm() != this) continue;
                res.add((PontoDeLinha)el);
            }
        }
        return res;
    }

    public List<Linha> getListaDeLigacoes() {
        return this.getListaDePontosLigados().stream().map(p -> p.getDono()).collect(Collectors.toList());
    }

    public ArrayList<Forma> getListaDeFormasLigadas(Forma exceto) {
        if (exceto == null) {
            return this.getListaDeFormasLigadas();
        }
        ArrayList<PontoDeLinha> pontos = this.getListaDePontosLigados();
        ArrayList<Forma> outrasPontas = new ArrayList<Forma>();
        for (PontoDeLinha pt : pontos) {
            Forma op = pt.getDono().getOutraPonta(this);
            if (op == null || op == exceto || outrasPontas.indexOf(op) != -1) continue;
            outrasPontas.add(op);
        }
        return outrasPontas;
    }

    public ArrayList<Forma> getListaDeFormasLigadasNaoExclusiva(Class destaClasse) {
        ArrayList<PontoDeLinha> pontos = this.getListaDePontosLigados();
        ArrayList<Forma> outrasPontas = new ArrayList<Forma>();
        for (PontoDeLinha pt : pontos) {
            Forma op = pt.getDono().getOutraPonta(this);
            if (op == null || !destaClasse.isAssignableFrom(op.getClass())) continue;
            outrasPontas.add(op);
        }
        return outrasPontas;
    }

    public ArrayList<Forma> getListaDeFormasLigadas(Class destaClasse) {
        ArrayList<PontoDeLinha> pontos = this.getListaDePontosLigados();
        ArrayList<Forma> outrasPontas = new ArrayList<Forma>();
        for (PontoDeLinha pt : pontos) {
            Forma op = pt.getDono().getOutraPonta(this);
            if (op == null || !destaClasse.isAssignableFrom(op.getClass()) || outrasPontas.indexOf(op) != -1) continue;
            outrasPontas.add(op);
        }
        return outrasPontas;
    }

    public ArrayList<Forma> getListaDeFormasLigadas() {
        ArrayList<PontoDeLinha> pontos = this.getListaDePontosLigados();
        ArrayList<Forma> outrasPontas = new ArrayList<Forma>();
        for (PontoDeLinha pt : pontos) {
            Forma op = pt.getDono().getOutraPonta(this);
            if (op == null || outrasPontas.indexOf(op) != -1) continue;
            outrasPontas.add(op);
        }
        return outrasPontas;
    }

    @Override
    public Elementar IsMeOrMine(Point p) {
        Elementar res = super.IsMeOrMine(p);
        if (res != null && res.isParte()) {
            return res.ProcessaComposicao();
        }
        return res;
    }

    @Override
    public Elementar IsMeOrMine(Point p, Elementar nor) {
        Elementar res = super.IsMeOrMine(p, nor);
        if (res != null && res.isParte()) {
            return res.ProcessaComposicao();
        }
        return res;
    }

    @Override
    public Elementar IsMeOrMineBase(Point p, Elementar nor) {
        Elementar res = super.IsMeOrMineBase(p, nor);
        if (res != null && res.isParte()) {
            return res.ProcessaComposicao();
        }
        return res;
    }

    @Override
    public Elementar ProcessaComposicao() {
        if (this.principal == null) {
            return this;
        }
        return this.principal;
    }

    @Override
    public Elementar getPrincipal() {
        return this.ProcessaComposicao();
    }

    public boolean isSubComponente() {
        return this.getPrincipal() != this;
    }

    public void setPrincipal(Elementar oprincipal) {
        this.principal = oprincipal instanceof Forma ? (Forma)oprincipal : null;
    }

    @Override
    public boolean isParte() {
        return this.principal != null;
    }

    public Point getMelhorPontoDeLigacao(Point estePonto) {
        int tmp = this.retorneProximidade(estePonto);
        Point[] ptsLi = this.getPontosColaterais();
        Point res = null;
        switch (tmp) {
            case 0: {
                res = new Point(ptsLi[0].x + 2, ptsLi[0].y);
                break;
            }
            case 1: {
                res = new Point(ptsLi[1].x, ptsLi[1].y + 2);
                break;
            }
            case 2: {
                res = new Point(ptsLi[2].x - 2, ptsLi[2].y);
                break;
            }
            case 3: {
                res = new Point(ptsLi[3].x, ptsLi[3].y - 2);
            }
        }
        return res;
    }

    public void EscrevaTexto(ArrayList<String> txts) {
        txts.add(this.getTexto());
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        res.add(InspectorProperty.PropertyFactorySN("ancorado", "setAncorado", this.isAncorado()));
        if (this.editFonte) {
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdFonte.name(), FormaElementar.nomeComandos.cmdFonte.name().toLowerCase(), this.getFont().getFontName()));
        }
        res.add(InspectorProperty.PropertyFactoryCor("forecolor", "setForeColor", this.getForeColor()));
        res.add(InspectorProperty.PropertyFactorySeparador("mer"));
        res.add(InspectorProperty.PropertyFactoryTexto("nome", "setTexto", this.getTexto()));
        res.add(InspectorProperty.PropertyFactoryTextoL("observacao", "setObservacao", this.getObservacao()));
        res.add(InspectorProperty.PropertyFactoryTextoL(this.nodic ? "textoadicional" : "dicionario", "setTextoAdicional", this.getTextoAdicional()));
        return res;
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        ArrayList<Forma> lst = this.getListaDeFormasLigadas();
        boolean ja = false;
        int tl = 0;
        for (Forma f : lst) {
            InspectorProperty ipp = InspectorProperty.PropertyFactoryActionSelect(Editor.fromConfiguracao.getValor("diagrama." + Editor.getClassTexto(f) + ".nome"), f.getTexto(), String.valueOf(((FormaElementar)f.getPrincipal()).getID()));
            if (!ja) {
                ja = true;
                GP.add(InspectorProperty.PropertyFactorySeparador("ligacoes", true));
            }
            GP.add(ipp);
            ++tl;
        }
        if (this.showOrgDiag && tl > 0) {
            GP.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "forma.organizediagrama").setTag(70));
        }
        return GP;
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 70) {
            this.OrganizeDiagrama();
        }
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorText(doc, "Texto", this.getTexto()));
        me.appendChild(XMLGenerate.ValorText(doc, "Observacao", this.getObservacao()));
        me.appendChild(XMLGenerate.ValorText(doc, "Dicionario", this.getTextoAdicional()));
        me.appendChild(XMLGenerate.ValorFonte(doc, this.getFont()));
        if (!this.getForeColor().equals(Elementar.defaultColor)) {
            me.appendChild(XMLGenerate.ValorColor(doc, "ForeColor", this.getForeColor()));
        }
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Ancorado", this.isAncorado()));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        Color c;
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        String tmp = XMLGenerate.getValorTextoFrom(me, "Texto");
        if (tmp != null) {
            this.setTexto(tmp);
        }
        if ((tmp = XMLGenerate.getValorTextoFrom(me, "Observacao")) != null) {
            this.setObservacao(tmp);
        }
        if ((tmp = XMLGenerate.getValorTextoFrom(me, "Dicionario")) != null) {
            this.setTextoAdicional(tmp);
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "ForeColor")) != null) {
            this.setForeColor(c);
        } else {
            this.setForeColor(this.getMaster().getForeColor());
        }
        Font f = XMLGenerate.getValorFonte(me);
        if (f != null) {
            this.setFont(f);
        }
        this.setAncorado(XMLGenerate.getValorBooleanFrom(me, "Ancorado"));
        return true;
    }

    public boolean MostreSeParaExibicao(TreeItem root) {
        root.add(new TreeItem(this.getTexto(), this.getID(), this.getClass().getSimpleName()));
        return true;
    }

    public void ManualResized() {
        if (!this.Reenquadre()) {
            this.Reposicione();
        }
        this.PropagueResizeParaLigacoes();
    }

    public void OrganizeDiagrama() {
        this.OrganizeDiagrama(true, false);
    }

    public static int MapaPosi(Forma A, Forma B) {
        Point posiA = A.getLocation();
        Point posiB = B.getLocation();
        int dist = Math.max(A.getWidth(), B.getWidth());
        if (Math.abs(posiA.x - posiB.x) < dist) {
            if (posiA.y > posiB.y) {
                return 2;
            }
            return 6;
        }
        dist = Math.max(A.getHeight(), B.getHeight());
        if (Math.abs(posiA.y - posiB.y) < dist) {
            if (posiA.x > posiB.x) {
                return 0;
            }
            return 4;
        }
        if (posiA.x < posiB.x) {
            if (posiA.y < posiB.y) {
                return 5;
            }
            return 3;
        }
        if (posiA.y > posiB.y) {
            return 1;
        }
        return 7;
    }

    protected void OrganizeDiagrama(boolean movA, boolean movB) {
        Forma A = this;
        A.getListaDePontosLigados().stream().map(p -> p.getDono()).forEach(L -> {
            Forma B = L.getOutraPonta(A);
            if (B == null) {
                B = A;
            }
            int sp = 0;
            int m = Forma.MapaPosi(A, B);
            Point ptA = new Point();
            Point ptB = new Point();
            int lpA = 0;
            int lpB = 0;
            switch (m) {
                case 0: 
                case 1: 
                case 7: {
                    ptA = new Point(A.getLeft() + sp, A.getTop() + A.getHeight() / 2);
                    ptB = new Point(B.getLeftWidth() - sp, B.getTop() + B.getHeight() / 2);
                    lpA = 0;
                    lpB = 2;
                    break;
                }
                case 2: {
                    ptA = new Point(A.getLeft() + A.getWidth() / 2, A.getTop() + sp);
                    ptB = new Point(B.getLeft() + B.getWidth() / 2, B.getTopHeight() - sp);
                    lpA = 1;
                    lpB = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    ptA = new Point(A.getLeftWidth() - sp, A.getTop() + A.getHeight() / 2);
                    ptB = new Point(B.getLeft() + sp, B.getTop() + B.getHeight() / 2);
                    lpA = 2;
                    lpB = 0;
                    break;
                }
                case 6: {
                    ptA = new Point(A.getLeft() + A.getWidth() / 2, A.getTopHeight() - sp);
                    ptB = new Point(B.getLeft() + B.getWidth() / 2, B.getTop() + sp);
                    lpA = 3;
                    lpB = 1;
                }
            }
            if (L.getPontaA().getEm() == A) {
                if (movA) {
                    L.getPontaA().setLado(lpA);
                    L.getPontaA().setCentro(ptA);
                }
                if (movB) {
                    L.getPontaB().setLado(lpB);
                    L.getPontaB().setCentro(ptB);
                }
            } else {
                if (movB) {
                    L.getPontaA().setLado(lpB);
                    L.getPontaA().setCentro(ptB);
                }
                if (movA) {
                    L.getPontaB().setLado(lpA);
                    L.getPontaB().setCentro(ptA);
                }
            }
        });
        this.organizeDiagramaRedistribuaLinhas();
        this.DoMuda();
    }

    private void organizeDiagramaRedistribuaLinhas() {
        Forma tt = this;
        for (int lado = 0; lado < 4; ++lado) {
            int ld = lado;
            boolean sn = ld % 2 == 0;
            int tl = Math.toIntExact(tt.getListaDePontosLigados().stream().filter(p -> p.getLado() == ld).count());
            if (tl == 0) continue;
            int espaco = ((sn ? tt.getHeight() : tt.getWidth()) - 2 * this.INI_ORGDIAG) / (tl + 1);
            int ini = this.INI_ORGDIAG;
            ini = sn ? (ini += tt.getTop()) : (ini += tt.getLeft());
            List ord = tt.getListaDePontosLigados().stream().filter(p -> p.getLado() == ld).sorted((p1, p2) -> {
                if (sn) {
                    return Integer.compare(p1.getDono().getOutraPonta((PontoDeLinha)p1).getTop(), p2.getDono().getOutraPonta((PontoDeLinha)p2).getTop());
                }
                return Integer.compare(p1.getDono().getOutraPonta((PontoDeLinha)p1).getLeft(), p2.getDono().getOutraPonta((PontoDeLinha)p2).getLeft());
            }).collect(Collectors.toList());
            for (PontoDeLinha p3 : ord) {
                ini += espaco;
                if (sn) {
                    p3.setTop(ini);
                } else {
                    p3.setLeft(ini);
                }
                p3.getDono().OrganizeLinha();
                p3.getDono().reSetBounds();
            }
        }
    }

    protected void OrganizeFluxo() {
        ArrayList<Forma> lst = new ArrayList<Forma>();
        lst.add(this);
        this.getListaDeFormasLigadas().forEach(item -> this.OrganizeFluxo(this, (Forma)item, (List<Forma>)lst));
    }

    protected void OrganizeFluxo(Forma origem, Forma dest, List<Forma> lstJA) {
        if (lstJA.indexOf(dest) > -1) {
            return;
        }
        origem.getListaDeLigacoes().stream().filter(L -> L.getOutraPonta(origem) == dest).forEach(lin -> {
            int pa = lin.getPontaA().getLado();
            int pb = lin.getPontaB().getLado();
            boolean sim = false;
            switch (pa) {
                case 0: {
                    sim = pb == 2;
                    break;
                }
                case 1: {
                    sim = pb == 3;
                    break;
                }
                case 2: {
                    sim = pb == 0;
                    break;
                }
                case 3: {
                    boolean bl = sim = pb == 1;
                }
            }
            if (sim) {
                Point PA = lin.getPontaA().getLocation();
                Point PB = lin.getPontaB().getLocation();
                int x = 0;
                int y = 0;
                if (pa == 0 || pa == 2) {
                    y = PA.y - PB.y;
                    if (lin.getPontaB().getEm() == origem) {
                        y = PB.y - PA.y;
                    }
                } else {
                    x = PA.x - PB.x;
                    if (lin.getPontaB().getEm() == origem) {
                        x = PB.x - PA.x;
                    }
                }
                dest.DoMove(x, y);
                dest.Reenquadre();
            }
            lstJA.add(dest);
            dest.getListaDeFormasLigadas().forEach(f -> this.OrganizeFluxo(dest, (Forma)f, lstJA));
        });
    }

    @Override
    public boolean Destroy() {
        List<Linha> lst = this.getListaDeLigacoes();
        boolean res = super.Destroy();
        if (this.getMaster().getEditor().isPropagueDeleteToLines()) {
            lst.stream().filter(L -> !L.isSelecionado()).forEach(L -> this.getMaster().Remove((FormaElementar)L, false));
        }
        return res;
    }

    public boolean isAlinhavel() {
        return true;
    }
}

