/*
 * Decompiled with CFR 0.152.
 */
package controlador.inspector;

import controlador.inspector.Inspector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JPanel;
import util.Dialogos;
import util.Utilidades;

public class InspectorExtenderEditor
extends JPanel {
    private final JButton btn;
    private Inspector dono;
    private String texto = "";
    private TipoDeAcao acaoTipo = TipoDeAcao.tpAcaoDlgTexto;

    public InspectorExtenderEditor(Inspector dono) {
        this();
        this.dono = dono;
        this.setBackground(Color.white);
        this.setFocusable(true);
    }

    public InspectorExtenderEditor() {
        this.setLayout(new FlowLayout(2, 1, 1));
        this.btn = new JButton("...");
        this.btn.setBounds(1, 1, 20, 20);
        this.add(this.btn);
        this.validate();
        this.setFocusable(true);
        this.btn.addActionListener(e -> this.RunDlg());
    }

    public final void RunDlg() {
        if (!this.isEnabled() || !this.btn.isEnabled()) {
            return;
        }
        if (this.getAcaoTipo() == TipoDeAcao.tpAcaoDlgCor) {
            this.setTexto(Dialogos.ShowDlgCor(this.getRootPane(), this.getTexto(), this.dono.getEditor().diagramaAtual));
        } else if (this.getAcaoTipo() == TipoDeAcao.tpAcaoDlgTexto) {
            this.setTexto(Dialogos.ShowDlgTexto(this.getRootPane(), this.getTexto()));
        }
        if (this.dono != null) {
            this.dono.EndEdit(true, false);
        }
        this.invalidate();
    }

    public TipoDeAcao getAcaoTipo() {
        return this.acaoTipo;
    }

    public void setAcaoTipo(TipoDeAcao acaoTipo) {
        if (this.acaoTipo != acaoTipo) {
            this.acaoTipo = acaoTipo;
            this.btn.setEnabled(acaoTipo != TipoDeAcao.tpReadOnlyTexto);
        }
    }

    public String getTexto() {
        return this.texto;
    }

    public void setTexto(String texto) {
        this.texto = texto;
        this.revalidate();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Rectangle r = this.getBounds();
        g.setColor(Color.BLACK);
        int re = 0;
        String bonito = "?";
        if (this.getAcaoTipo() == TipoDeAcao.tpAcaoDlgCor || this.getAcaoTipo() == TipoDeAcao.tpReadOnlyCor) {
            g.setColor(Color.BLACK);
            g.fillRect(3, 3, r.height - 7, r.height - 7);
            try {
                Color c = Utilidades.StringToColor(this.getTexto());
                g.setColor(c);
                bonito = this.getTexto();
            }
            catch (Exception c) {
                // empty catch block
            }
            g.fillRect(4, 4, r.height - 8, r.height - 8);
            re = r.height - 1;
        } else {
            bonito = this.getTexto().replaceAll("\n", " | ");
        }
        Rectangle obkp = g.getClipBounds();
        g.setColor(Color.DARK_GRAY);
        g.setFont(new Font(this.getFont().getFontName(), 1, this.getFont().getSize()));
        g.clipRect(re, 0, r.width - r.height - re - (re == 0 ? 4 : 8), r.height);
        g.drawString(bonito, re + 2, (int)((double)r.height * 0.72) + 1);
        g.drawLine(0, 0, 0, this.getHeight());
        g.setClip(obkp);
    }

    protected void OrganizeSize() {
        Dimension nd = new Dimension(this.getHeight() - 1, this.getHeight() - 2);
        this.btn.setPreferredSize(nd);
        this.btn.setSize(nd);
        this.btn.repaint();
    }

    public static enum TipoDeAcao {
        tpAcaoDlgTexto,
        tpAcaoDlgCor,
        tpReadOnlyTexto,
        tpAcaoSelectObj,
        tpReadOnlyCor,
        tpAcaoCommand;

    }
}

