/*
 * Decompiled with CFR 0.152.
 */
package diagramas.logico;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.editores.EditorDeCampos;
import controlador.editores.EditorDeIR;
import controlador.editores.EditorDeIrFK;
import controlador.editores.EditorDeIrUnique;
import controlador.editores.EditorDeTipos;
import controlador.editores.MostradorDeCodigo;
import controlador.inspector.InspectorProperty;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Desenhador;
import desenho.formas.Forma;
import desenho.formas.Legenda;
import diagramas.conceitual.Texto;
import diagramas.logico.Campo;
import diagramas.logico.Constraint;
import diagramas.logico.DataBaseModel;
import diagramas.logico.LogicoLinha;
import diagramas.logico.Tabela;
import java.awt.Frame;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import principal.Aplicacao;
import util.BoxingJava;
import util.Utilidades;
import util.XMLGenerate;

public class DiagramaLogico
extends Diagrama {
    private static final long serialVersionUID = 5042110897774875283L;
    private final Class[] classesDoDiagrama = new Class[]{Campo.class, Tabela.class, LogicoLinha.class, Texto.class, Desenhador.class, Legenda.class};
    private final int CONS_DISTANCIA_LEFT = 160;
    private final int CONS_DISTANCIA_TOP = 80;
    protected final String COMM_ORG = "orgtab";
    protected final String COMM_EDT_CMPS = "edt_campos";
    protected final String COMM_EDT_CMPS_TP = "edt_campos_tipo";
    protected final String COMM_COV_FISICO = "logico.cov_fisico";
    private transient boolean organizou = false;
    private final int ATAG = 86;
    private final int EDITOR_CAMPOS = 200317;
    private final int EDITOR_CAMPOS_TP = 180717;
    private final int CONV_FISICO = 310317;
    private DataBaseModel dataModel = new DataBaseModel();
    private String separatorSQL = ";";
    private String prefixo = "";

    public DiagramaLogico(Editor omaster) {
        super(omaster);
        this.setTipo(Diagrama.TipoDeDiagrama.tpLogico);
        this.meusComandos.add(Controler.Comandos.cmdTabela.name());
        this.meusComandos.add(Controler.Comandos.cmdCampo.name());
        this.meusComandos.add(Controler.Comandos.cmdCampo_Key.name());
        this.meusComandos.add(Controler.Comandos.cmdCampo_Fkey.name());
        this.meusComandos.add(Controler.Comandos.cmdCampo_KeyFkey.name());
        this.meusComandos.add(Controler.Comandos.cmdLogicoLinha.name());
    }

    @Override
    public Class[] getCassesDoDiagrama() {
        return this.classesDoDiagrama;
    }

    @Override
    public Object processeEdicaoSubItem(FormaElementar ed, BoxingJava bj) {
        if (ed instanceof Tabela) {
            String resp;
            String prin = bj.Str;
            bj.Str = resp = bj.Str.substring(bj.Str.indexOf(46) + 1);
            Tabela tab = (Tabela)ed;
            if (prin.startsWith("Campo")) {
                return tab.getCampoSelecionado();
            }
            return tab.getConstraintSelecionado();
        }
        return super.processeEdicaoSubItem(ed, bj);
    }

    @Override
    protected FormaElementar RealiseComando(Point posi) {
        Elementar res;
        this.ClearSelect(false);
        FormaElementar resu = null;
        Controler.Comandos com = this.getComando();
        switch (com) {
            case cmdTabela: {
                Tabela tab = new Tabela(this, "Tabela");
                tab.SetBounds(posi.x, posi.y, 150, 100);
                tab.Reenquadre();
                resu = tab;
                break;
            }
            case cmdLogicoLinha: {
                FormaElementar obj2;
                if (this.cliq1 == null) {
                    Elementar res2 = this.CaptureFromPoint(posi);
                    FormaElementar obj1 = null;
                    if (res2 instanceof FormaElementar) {
                        obj1 = (FormaElementar)res2;
                    }
                    this.cliq1 = new Diagrama.clickForma(obj1, posi);
                    return null;
                }
                if (this.cliq2 == null) {
                    obj2 = null;
                    res = this.CaptureFromPoint(posi);
                    if (res instanceof FormaElementar) {
                        obj2 = (FormaElementar)res;
                    }
                    this.cliq2 = new Diagrama.clickForma(obj2, posi);
                }
                LogicoLinha linha = new LogicoLinha(this);
                resu = linha;
                Point pt1 = this.cliq1.getPonto();
                Point pt2 = this.cliq2.getPonto();
                linha.SuperInicie(0, pt2, pt1);
                FormaElementar obj1 = this.cliq1.getForma();
                obj2 = this.cliq2.getForma();
                if (!(obj1 instanceof Tabela) || !(obj2 instanceof Tabela)) break;
                Tabela ori = (Tabela)obj1;
                Tabela dest = (Tabela)obj2;
                Campo cmpO = ori.getCampoFromPoint(pt1);
                Campo cmpD = dest.getCampoFromPoint(pt2);
                if (cmpO != null && (cmpO.isUnique() || cmpO.isKey())) {
                    if (cmpD == null) {
                        cmpD = dest.Add((Utilidades.IsUpper(ori.getTexto()) ? Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix") : Editor.fromConfiguracao.getValor("Controler.interface.mensagem.msgcov.fk.prefix").toLowerCase()) + ori.getTexto() + "_" + cmpO.getTexto());
                    }
                    if (!cmpD.isFkey()) {
                        cmpD.SetFkey(true);
                        Constraint constr_un_pk = cmpO.isUnique() ? (Constraint)ori.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpUNIQUE && c.getCamposDeOrigem().indexOf(cmpO) > -1).findFirst().orElse(null) : (Constraint)ori.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpPK).findFirst().orElse(null);
                        Constraint constr_fk = dest.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK).filter(c -> c.getConstraintOrigem() == constr_un_pk).findFirst().orElse(null);
                        if (constr_fk == null) {
                            constr_fk = new Constraint(dest);
                            constr_fk.setTipo(Constraint.CONSTRAINT_TIPO.tpFK);
                            constr_fk.Add(cmpO, cmpD, linha, constr_un_pk);
                        } else {
                            constr_fk.Add(cmpO, cmpD);
                            if (constr_fk.getConstraintOrigem() == null) {
                                constr_fk.setConstraintOrigem(constr_un_pk);
                            }
                            if (constr_fk.getLigacao() == null) {
                                constr_fk.setLigacao(linha);
                            }
                        }
                    }
                }
                linha.ajusteSeta();
                break;
            }
            case cmdCampo: 
            case cmdCampo_Fkey: 
            case cmdCampo_Key: 
            case cmdCampo_KeyFkey: {
                res = this.CaptureFromPoint(posi);
                if (res instanceof FormaElementar) {
                    resu = (FormaElementar)res;
                } else {
                    this.setComando(Controler.Comandos.cmdTabela);
                    this.cliq1 = null;
                    this.cliq2 = null;
                    resu = this.RealiseComando(posi);
                }
                if (!(resu instanceof Tabela)) break;
                Tabela tab = (Tabela)resu;
                Campo c2 = tab.Add(Editor.fromConfiguracao.getValor("diagrama.Campo.nome"));
                if (com == Controler.Comandos.cmdCampo_Key || com == Controler.Comandos.cmdCampo_KeyFkey) {
                    c2.setKey(true);
                }
                if (com != Controler.Comandos.cmdCampo_Fkey && com != Controler.Comandos.cmdCampo_KeyFkey) break;
                c2.setFkey(true);
            }
        }
        if (resu == null) {
            if (com == Controler.Comandos.cmdApagar && this.CaptureFromPoint(posi) instanceof Tabela) {
                res = this.CaptureFromPoint(posi);
                resu = (FormaElementar)res;
                this.ClearSelect();
                this.setSelecionado(resu);
                Campo cmp = ((Tabela)res).getCampoFromPoint(posi);
                boolean sn = false;
                if (cmp == null) {
                    Constraint constr = ((Tabela)res).getConstraintFromPoint(posi);
                    if (constr != null) {
                        ((Tabela)res).RemoveConstraint(constr);
                        this.setSelecionado(resu);
                        sn = true;
                    }
                } else {
                    ((Tabela)res).RemoveCampo(cmp);
                    this.setSelecionado(resu);
                    sn = true;
                }
                if (!sn) {
                    this.deleteSelecao();
                    resu = null;
                }
            } else {
                return super.RealiseComando(posi);
            }
        }
        this.cliq1 = null;
        this.cliq2 = null;
        if (!this.master.isControlDown()) {
            this.setComando(null);
        } else {
            this.setComando(com);
        }
        if (resu != null) {
            resu.BringToFront();
        }
        return resu;
    }

    public ArrayList<Campo> getListaDeCampos() {
        ArrayList<Campo> res = new ArrayList<Campo>();
        this.getListaDeItens().stream().filter(el -> el instanceof Tabela).map(el -> (Tabela)el).forEach(el -> res.addAll(el.getCampos()));
        return res;
    }

    public void OrganizeTabelas() {
        List<Tabela> tabelas = this.getListaDeItens().stream().filter(o -> o instanceof Tabela).map(t -> (Tabela)t).collect(Collectors.toList());
        tabelas.forEach(t1 -> tabelas.stream().filter(t -> t != t1).forEach(t2 -> this.ApliqueDistancia((Tabela)t1, (Tabela)t2)));
        List<Tabela> ord = tabelas.stream().sorted((t1, t2) -> Integer.compare(t1.getLeft(), t2.getLeft())).collect(Collectors.toList());
        ord.forEach(t1 -> ord.stream().filter(t -> t != t1).forEach(t2 -> this.ApliqueDistancia((Tabela)t1, (Tabela)t2)));
    }

    private void ApliqueDistancia(Tabela ori, Tabela dest) {
        int m = Forma.MapaPosi(ori, dest);
        int x = 0;
        int y = 0;
        switch (m) {
            case 6: {
                if (dest.getTop() - ori.getTopHeight() >= 80) break;
                y = 80 - (dest.getTop() - ori.getTopHeight());
                break;
            }
            case 5: {
                int distX = dest.getLeft() - ori.getLeftWidth();
                int distY = dest.getTop() - ori.getTopHeight();
                if (distY < 80) {
                    y = 80 - (dest.getTop() - ori.getTopHeight());
                }
                if (distX < 160) {
                    x = 160 - (dest.getLeft() - ori.getLeftWidth());
                }
                if (x > y) {
                    if (distX < 40) {
                        x = 40;
                        break;
                    }
                    x = 0;
                    break;
                }
                if (distY < 20) {
                    y = 20;
                    break;
                }
                y = 0;
                break;
            }
            case 3: 
            case 4: {
                if (dest.getLeft() - ori.getLeftWidth() >= 160) break;
                x = 160 - (dest.getLeft() - ori.getLeftWidth());
            }
        }
        if (x > 0 || y > 0) {
            this.organizou = true;
            dest.DoMove(x, y);
        }
    }

    @Override
    public void populeComandos(JMenuItem menu) {
        super.populeComandos(menu);
        menu.removeAll();
        menu.setEnabled(true);
        String tmp = Editor.fromConfiguracao.getValor("Controler.interface.Diagrama.Command.Logico.Org.descricao");
        Diagrama.AcaoDiagrama ac = (Diagrama)this.new Diagrama.AcaoDiagrama(this, tmp, "Controler.interface.Diagrama.Command.Logico.Org.img", tmp, "orgtab");
        ac.normal = false;
        JMenuItem mi = new JMenuItem(ac);
        mi.setName(tmp);
        menu.add(mi);
        tmp = Editor.fromConfiguracao.getValor("Controler.interface.Diagrama.Command.Logico.EdtC.descricao");
        ac = (Diagrama)this.new Diagrama.AcaoDiagrama(this, tmp, "Controler.interface.Diagrama.Command.Logico.EdtC.img", tmp, "edt_campos");
        ac.normal = false;
        mi = new JMenuItem(ac);
        mi.setName(tmp);
        menu.add(mi);
        tmp = Editor.fromConfiguracao.getValor("Controler.interface.Diagrama.Command.Logico.EdtT.descricao");
        ac = (Diagrama)this.new Diagrama.AcaoDiagrama(this, tmp, "Controler.interface.Diagrama.Command.Logico.EdtT.img", tmp, "edt_campos_tipo");
        ac.normal = false;
        mi = new JMenuItem(ac);
        mi.setName(tmp);
        menu.add(mi);
        tmp = Editor.fromConfiguracao.getValor("Controler.interface.Diagrama.Command.Logico.converter.descricao");
        ac = (Diagrama)this.new Diagrama.AcaoDiagrama(this, tmp, "Controler.interface.Diagrama.Command.Logico.converter.img", tmp, "logico.cov_fisico");
        ac.normal = false;
        mi = new JMenuItem(ac);
        mi.setName(tmp);
        menu.add(mi);
    }

    @Override
    public void rodaComando(String comm) {
        if (comm.equals("orgtab")) {
            this.setSelecionado(null);
            this.organizou = false;
            this.OrganizeTabelas();
            if (this.organizou) {
                this.DoMuda(null);
            }
        } else if (comm.equals("edt_campos")) {
            this.LancarEditorDeCampos();
        } else if (comm.equals("edt_campos_tipo")) {
            this.LancarEditorDeCamposTP();
        } else if (comm.equals("logico.cov_fisico")) {
            this.ConverterParaFisico();
        }
    }

    @Override
    public void EndProperty(ArrayList<InspectorProperty> res) {
        super.EndProperty(res);
        res.add(InspectorProperty.PropertyFactorySeparador("diagrama.logico.sql"));
        res.add(InspectorProperty.PropertyFactoryTexto("diagrama.logico.separadorsql", "setFromString", this.getSeparatorSQL()).setTag(21042017));
        res.add(InspectorProperty.PropertyFactoryTexto("diagrama.logico.prefixo", "setFromString", this.getPrefixo()).setTag(7072018));
        res.add(InspectorProperty.PropertyFactorySeparador("orgtab"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "orgtab").setTag(86));
        res.add(InspectorProperty.PropertyFactorySeparador("edt_campos"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "edt_campos").setTag(200317));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "edt_campos_tipo").setTag(180717));
        res.add(InspectorProperty.PropertyFactorySeparador("logico.cov_fisico"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "logico.cov_fisico").setTag(310317));
    }

    @Override
    public void InfoDiagrama_ToXmlValores(Document doc, Element me) {
        super.InfoDiagrama_ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorString(doc, "SeparatorSQL", this.getSeparatorSQL()));
        me.appendChild(XMLGenerate.ValorString(doc, "Prefixo", this.getPrefixo()));
    }

    @Override
    public boolean InfoDiagrama_LoadFromXML(Element me, boolean colando) {
        if (!super.InfoDiagrama_LoadFromXML(me, colando)) {
            return false;
        }
        this.setSeparatorSQL(XMLGenerate.getValorStringFrom(me, "SeparatorSQL"));
        this.setPrefixo(XMLGenerate.getValorStringFrom(me, "Prefixo"));
        return true;
    }

    @Override
    public void setFromString(String str, int tag) {
        super.setFromString(str, tag);
        if (tag == 21042017) {
            this.setSeparatorSQL(str);
        } else if (tag == 7072018) {
            this.setPrefixo(str);
        }
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 86) {
            this.rodaComando("orgtab");
            return;
        }
        if (Tag == 310317) {
            this.rodaComando("logico.cov_fisico");
            return;
        }
        if (Tag == 200317) {
            this.LancarEditorDeCampos();
            return;
        }
        if (Tag == 180717) {
            this.LancarEditorDeCamposTP();
        }
    }

    public void LancarEditorDeCampos() {
        if (this.getListaDeItens().stream().filter(tb -> tb instanceof Tabela).count() == 0L) {
            JOptionPane.showMessageDialog(Aplicacao.fmPrincipal, Editor.fromConfiguracao.getValor("Controler.interface.mensagem.sem_campos"), Editor.fromConfiguracao.getValor("Controler.interface.mensagem.tit_informacao"), 1);
            return;
        }
        EditorDeCampos de = new EditorDeCampos((Frame)Aplicacao.fmPrincipal, true);
        de.setLocationRelativeTo(Aplicacao.fmPrincipal);
        de.Inicie(this);
        de.setVisible(true);
        this.PerformInspector();
    }

    public void LancarEditorDeIR(int Tag) {
        if (this.getListaDeItens().stream().filter(tb -> tb instanceof Tabela).count() == 0L) {
            JOptionPane.showMessageDialog(Aplicacao.fmPrincipal, Editor.fromConfiguracao.getValor("Controler.interface.mensagem.sem_campos"), Editor.fromConfiguracao.getValor("Controler.interface.mensagem.tit_informacao"), 1);
            return;
        }
        switch (Tag) {
            case 120420170: {
                EditorDeIR de = new EditorDeIR((Frame)Aplicacao.fmPrincipal, true);
                de.setLocationRelativeTo(Aplicacao.fmPrincipal);
                de.Inicie(this);
                de.setVisible(true);
                break;
            }
            case 120420172: {
                EditorDeIrUnique un = new EditorDeIrUnique((Frame)Aplicacao.fmPrincipal, true);
                un.setLocationRelativeTo(Aplicacao.fmPrincipal);
                un.Inicie(this);
                un.setVisible(true);
                break;
            }
            case 120420171: {
                EditorDeIrFK fk = new EditorDeIrFK((Frame)Aplicacao.fmPrincipal, true);
                fk.setLocationRelativeTo(Aplicacao.fmPrincipal);
                fk.Inicie(this);
                fk.setVisible(true);
            }
        }
        this.PerformInspector();
        this.repaint();
    }

    public boolean ConverterParaFisico() {
        boolean vai = true;
        while (this.getListaDeTabelas().stream().anyMatch(t -> t.getCampos().stream().anyMatch(cc -> cc.getTipo().isEmpty()))) {
            EditorDeTipos edt = new EditorDeTipos((Frame)Aplicacao.fmPrincipal.getRootPane().getParent(), true);
            edt.setLocationRelativeTo(Aplicacao.fmPrincipal.getRootPane());
            edt.Inicie(this);
            edt.setVisible(true);
            vai = edt.getResultado() == 0;
            if (vai) continue;
            break;
        }
        if (!vai) {
            return false;
        }
        String tmp = "/* " + this.getNomeFormatado() + ": */";
        List<Tabela> tabelas = this.getListaDeTabelas();
        ArrayList ddl = new ArrayList();
        tabelas.forEach(t -> {
            ddl.add("");
            t.DDLGenerate(ddl, t.DDL_PEGAR_TABELAS);
            t.getClass();
            t.DDLGenerate(ddl, 3);
        });
        tabelas.forEach(t -> t.DDLGenerate(ddl, t.DDL_PEGAR_INTEGRIDADE_FK));
        MostradorDeCodigo edt = new MostradorDeCodigo((Frame)Aplicacao.fmPrincipal.getRootPane().getParent(), true);
        edt.setLocationRelativeTo(Aplicacao.fmPrincipal.getRootPane());
        edt.setTexto(ddl.stream().map(s -> "\n" + s).reduce(tmp, String::concat));
        edt.setVisible(true);
        return true;
    }

    public DataBaseModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(DataBaseModel dataModel) {
        this.dataModel = dataModel;
    }

    public List<Tabela> getListaDeTabelas() {
        return this.getListaDeItens().stream().filter(tb -> tb instanceof Tabela).map(tb -> (Tabela)tb).collect(Collectors.toList());
    }

    public void ReciveNotifiqueIR(Constraint cons, int msg, Campo cmp) {
        switch (msg) {
            case 6: {
                if (cmp == null) {
                    return;
                }
                ArrayList campos = new ArrayList();
                this.getListaDeTabelas().stream().forEach(ta -> ta.getConstraints().stream().forEach(c -> {
                    int idx = c.getCamposDeOrigem().indexOf(cmp);
                    if (idx > -1) {
                        Campo tmp = c.getCamposDeDestino().get(idx);
                        if (tmp != null && !tmp.getTipo().equals(cmp.getTipo())) {
                            campos.add(tmp);
                        }
                    } else {
                        Campo tmp;
                        idx = c.getCamposDeDestino().indexOf(cmp);
                        if (idx > -1 && (tmp = c.getCamposDeOrigem().get(idx)) != null && !tmp.getTipo().equals(cmp.getTipo())) {
                            campos.add(tmp);
                        }
                    }
                }));
                campos.stream().forEach(cp -> cp.setTipo(cmp.getTipo()));
                break;
            }
            case 3: {
                if (cons == null) {
                    return;
                }
            }
            case 5: {
                if (cmp == null) {
                    return;
                }
                this.getListaDeTabelas().stream().forEach(ta -> ta.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK).forEach(c -> {
                    if (c.getCamposDeOrigem().indexOf(cmp) > -1) {
                        boolean sn = true;
                        if (msg == 3) {
                            boolean bl = sn = c.getConstraintOrigem() == cons;
                        }
                        if (sn) {
                            int idx = c.getCamposDeOrigem().indexOf(cmp);
                            Campo tmp = c.getCamposDeDestino().get(idx);
                            c.Add(null, tmp);
                        }
                    } else {
                        c.Valide();
                    }
                }));
                break;
            }
            case 2: {
                if (cons == null) {
                    return;
                }
                this.getListaDeTabelas().stream().forEach(ta -> ta.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK).filter(c -> c.getConstraintOrigem() == cons).forEach(c -> c.Valide()));
                break;
            }
            case 4: {
                if (cons == null) {
                    return;
                }
                this.getListaDeTabelas().stream().forEach(ta -> ta.getConstraints().stream().filter(c -> c.getTipo() == Constraint.CONSTRAINT_TIPO.tpFK).filter(c -> c.getConstraintOrigem() == cons).forEach(c -> c.setConstraintOrigem(null)));
            }
        }
    }

    public String getSeparatorSQL() {
        return this.separatorSQL;
    }

    public void setSeparatorSQL(String separatorSQL) {
        if (this.separatorSQL.equals(separatorSQL)) {
            return;
        }
        this.separatorSQL = separatorSQL;
        this.repaint();
    }

    public String getPrefixo() {
        return this.prefixo;
    }

    public void setPrefixo(String prefixo) {
        if (this.prefixo.equals(prefixo)) {
            return;
        }
        this.prefixo = prefixo;
        this.repaint();
    }

    public void LancarEditorDeCamposTP() {
        if (this.getListaDeItens().stream().filter(tb -> tb instanceof Tabela).count() == 0L) {
            JOptionPane.showMessageDialog(Aplicacao.fmPrincipal, Editor.fromConfiguracao.getValor("Controler.interface.mensagem.sem_campos"), Editor.fromConfiguracao.getValor("Controler.interface.mensagem.tit_informacao"), 1);
            return;
        }
        EditorDeTipos de = new EditorDeTipos((Frame)Aplicacao.fmPrincipal, true);
        de.lblMsg.setText(Editor.fromConfiguracao.getValor("Controler.interface.mensagem.edt_tipos"));
        de.setLocationRelativeTo(Aplicacao.fmPrincipal);
        de.Inicie(this);
        de.SelecioneByDiagramaSelecionado();
        de.setVisible(true);
        this.PerformInspector();
    }

    @Override
    protected void AdicioneSubsFromRealce(ArrayList<FormaElementar> res, FormaElementar item) {
        super.AdicioneSubsFromRealce(res, item);
        if (item instanceof LogicoLinha) {
            LogicoLinha lig = (LogicoLinha)item;
            res.add(lig.getCardA());
            res.add(lig.getCardB());
        }
    }

    @Override
    public void OnAfterLoad(boolean isXml) {
        super.OnAfterLoad(isXml);
        if (this.prefixo == null) {
            this.prefixo = "";
        }
    }
}

