/*
 * Decompiled with CFR 0.152.
 */
package desenho.preAnyDiagrama;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.formas.FormaNaoRetangularBase;
import desenho.formas.FormaRetangular;
import desenho.linhas.Linha;
import desenho.linhas.PontoDeLinha;
import diagramas.conceitual.Atributo;
import diagramas.conceitual.DiagramaConceitual;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XMLGenerate;

public class PreEntidade
extends FormaRetangular {
    private static final long serialVersionUID = 6302631403788417883L;
    public final int CONST_DO_ORGATTR = 123;
    public boolean mudouAtributos = false;
    protected final String COMM_EDT_ATTR = "edt_attr";
    private final int EDITOR_ATTR = 250317;
    transient int lastL1 = 0;
    transient int lastL3 = 0;
    private String atributosOcultos = "";
    public final int CODE_EDT_ATR = 4;

    public PreEntidade(Diagrama modelo) {
        super(modelo);
        this.showOrgDiag = true;
    }

    public PreEntidade(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.showOrgDiag = true;
    }

    @Override
    public ArrayList<Integer> getAncorasCode() {
        ArrayList<Integer> res = super.getAncorasCode();
        Integer[] ancorasCode = new Integer[]{2, 4};
        res.addAll(Arrays.asList(ancorasCode));
        return res;
    }

    @Override
    public boolean CanLiga(Forma forma, Linha lin) {
        if (forma == null) {
            return true;
        }
        if (super.CanLiga(forma, lin) && !(forma instanceof PreEntidade)) {
            return forma.CanLiga(this, lin);
        }
        return false;
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        res.add(InspectorProperty.PropertyFactoryTextoL("entidade.ao", "setAtributosOcultos", this.getAtributosOcultos()));
        return res;
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        ArrayList<InspectorProperty> res = GP;
        res.add(InspectorProperty.PropertyFactorySeparador("entidade.relacionar"));
        List<String> ents = this.getMaster().getListaDeItens().stream().filter(o -> o instanceof PreEntidade).map(e -> ((PreEntidade)e).getTexto()).collect(Collectors.toList());
        ents.add(0, Editor.fromConfiguracao.getValor("Inspector.obj.selecione"));
        res.add(InspectorProperty.PropertyFactoryMenu("entidade.relacione", "Relacione", 0, ents));
        res.add(InspectorProperty.PropertyFactorySeparador("entidade.orgattr"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "entidade.orgattr").setTag(123));
        res.add(InspectorProperty.PropertyFactorySeparador("edt_attr"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "edt_attr").setTag(250317));
        super.CompleteGenerateProperty(GP);
        return GP;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorString(doc, "AtributosOcultos", this.getAtributosOcultos()));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        String tmp = XMLGenerate.getValorStringFrom(me, "AtributosOcultos");
        if (tmp != null) {
            this.setAtributosOcultos(tmp);
        }
        return true;
    }

    public void Relacione(int idx) {
        if (--idx < 0) {
            return;
        }
        List ents = this.getMaster().getListaDeItens().stream().filter(o -> o instanceof PreEntidade).map(e -> (PreEntidade)e).collect(Collectors.toList());
        if (idx > ents.size() - 1) {
            return;
        }
        PreEntidade dest = (PreEntidade)ents.get(idx);
        if (dest == this) {
            this.getMaster().ExternalRealiseComando(Controler.Comandos.cmdAutoRelacionamento, new Point(this.getLeftWidth() - 1, this.getTop() + this.getHeight() / 2));
        } else {
            ((DiagramaConceitual)this.getMaster()).Relacione(this, dest);
        }
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        if (Tag == 123) {
            List pts = this.getListaDePontosLigados().stream().filter(p -> p.getDono().getOutraPonta((PontoDeLinha)p).getEm() instanceof Atributo).collect(Collectors.toList());
            Comparator comparator = (p1, p2) -> Integer.compare(p1.getLeft(), p2.getLeft());
            Collections.sort(pts, comparator.reversed());
            this.lastL1 = 0;
            this.lastL3 = 0;
            for (PontoDeLinha p3 : pts) {
                Atributo att;
                if (this.Alinhe(p3, att = (Atributo)p3.getDono().getOutraPonta(p3).getEm())) {
                    this.mudouAtributos = true;
                }
                if (!att.OrganizeAtributos()) continue;
                this.mudouAtributos = true;
            }
        }
        if (Tag == 250317) {
            ((DiagramaConceitual)this.getMaster()).LancarEditorDeAtributos();
        }
    }

    private boolean Alinhe(PontoDeLinha p, Atributo atr) {
        if (this.getMaster().getItensSelecionados().indexOf(atr) > -1) {
            return false;
        }
        int L = p.getLado();
        int tmp = atr.getHeight() / 2;
        int disH = 20;
        int disW = 40;
        int l = 0;
        int t = 0;
        int X = 0;
        int Y = 0;
        switch (L) {
            case 0: {
                atr.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Right);
                X = this.getLeft() - disW - atr.getWidth();
                if (atr.getLeft() != X) {
                    l = atr.getLeft() - X;
                }
                Y = p.getCentro().y - tmp;
                if (atr.getTop() == Y) break;
                t = atr.getTop() - Y;
                break;
            }
            case 2: {
                atr.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Left);
                X = this.getLeftWidth() + disW;
                if (atr.getLeft() != X) {
                    l = atr.getLeft() - X;
                }
                Y = p.getCentro().y - tmp;
                if (atr.getTop() == Y) break;
                t = atr.getTop() - Y;
                break;
            }
            case 1: {
                atr.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Left);
                X = p.getCentro().x + 10;
                if (atr.getLeft() != X) {
                    l = atr.getLeft() - X;
                }
                Y = this.getTop() - disH - atr.getHeight();
                if (atr.getTop() != Y) {
                    t = atr.getTop() - Y;
                }
                if (this.lastL1 == 0) {
                    this.lastL1 = atr.getHeight() + 5;
                    break;
                }
                t += this.lastL1;
                this.lastL1 += atr.getHeight() + 5;
                break;
            }
            case 3: {
                atr.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Left);
                X = p.getCentro().x + 10;
                if (atr.getLeft() != X) {
                    l = atr.getLeft() - X;
                }
                Y = this.getTopHeight() + disH;
                if (atr.getTop() != Y) {
                    t = atr.getTop() - Y;
                }
                if (this.lastL3 == 0) {
                    this.lastL3 = atr.getHeight() + 5;
                    break;
                }
                t -= this.lastL3;
                this.lastL3 += atr.getHeight() + 5;
            }
        }
        Rectangle r = new Rectangle(l, t, 0, 0);
        atr.ReciveFormaResize(r);
        atr.Reenquadre();
        return l != 0 || t != 0;
    }

    @Override
    public void OrganizeDiagrama(boolean movA, boolean movB) {
        super.OrganizeDiagrama(movA, movB);
        this.DoAnyThing(123);
    }

    public String getAtributosOcultos() {
        return this.atributosOcultos;
    }

    public void setAtributosOcultos(String atributosOcultos) {
        if (this.atributosOcultos.equals(atributosOcultos)) {
            return;
        }
        this.atributosOcultos = atributosOcultos;
    }

    @Override
    public void runAncorasCode(int cod) {
        super.runAncorasCode(cod);
        if (cod == 2) {
            this.DoAnyThing(123);
        }
        if (cod == 4) {
            this.DoAnyThing(250317);
        }
    }

    @Override
    public String WhatDrawOnAcorador(Integer c) {
        if (c == 2) {
            return "diagrama.ancordor.2.img";
        }
        if (c == 4) {
            return "diagrama.ancordor.4.img";
        }
        return super.WhatDrawOnAcorador(c);
    }

    public List<Atributo> getAtributos() {
        return this.getListaDePontosLigados().stream().filter(p -> p.getDono().getOutraPonta((PontoDeLinha)p).getEm() instanceof Atributo).map(p -> (Atributo)p.getDono().getOutraPonta((PontoDeLinha)p).getEm()).collect(Collectors.toList());
    }
}

