/*
 * Decompiled with CFR 0.152.
 */
package desenho.preDiagrama;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.formas.Forma;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DesenhadorDeTexto;
import util.XMLGenerate;

public class baseDrawerFromForma
extends Forma {
    private static final long serialVersionUID = 4532072927400419827L;
    public int margemTitulo = 10;
    protected int L = 0;
    protected int T = 0;
    protected int W = 0;
    protected int H = 0;
    protected boolean blankPaint = false;
    private boolean pintarBorda = true;
    private boolean gradiente = false;
    public final int VERTICAL = 0;
    public final int HORIZONTAL = 1;
    private int gdirecao = 0;
    private Color gradienteEndColor = new Color(204, 204, 204, 255);
    private Color gradienteStartColor = new Color(0, 0, 0, 255);
    protected int roundrect = 22;
    private boolean delimite = true;
    private float alfa = 0.5f;
    private boolean alteraForma = false;
    private Color corBorda = Color.BLACK;

    public baseDrawerFromForma(Diagrama diagrama) {
        super(diagrama);
    }

    public baseDrawerFromForma(Diagrama diagrama, String texto) {
        super(diagrama, texto);
    }

    @Override
    public DesenhadorDeTexto getTextoFormatado() {
        DesenhadorDeTexto dz = super.getTextoFormatado();
        dz.setCentrarTextoVertical(false);
        dz.LimitarAreaDePintura = true;
        dz.CorretorPosicao = new Point(0, 6);
        return dz;
    }

    protected void DimensioneParaPintura() {
        this.L = this.getLeft();
        this.T = this.getTop();
        this.W = this.getWidth();
        this.H = this.getHeight();
    }

    public boolean isPintarBorda() {
        return this.pintarBorda;
    }

    public void setPintarBorda(boolean pintarBorda) {
        this.pintarBorda = pintarBorda;
        this.InvalidateArea();
    }

    @Override
    public void DoPaint(Graphics2D g) {
        g.setPaint(this.getForeColor());
        if (this.blankPaint) {
            this.DimensioneParaPintura();
            super.DoPaint(g);
            return;
        }
        Composite ori = g.getComposite();
        if (this.isGradiente()) {
            this.PaintGradiente(g);
        }
        Paint paintg = g.getPaint();
        Composite orig = g.getComposite();
        g.setComposite(ori);
        g.setPaint(this.getForeColor());
        super.DoPaint(g);
        g.setPaint(paintg);
        g.setComposite(orig);
        this.DimensioneParaPintura();
        if (this.roundrect > 0) {
            if (this.isPintarBorda()) {
                g.setPaint(this.getCorBorda());
                g.drawRoundRect(this.L, this.T, this.W, this.H, this.roundrect, this.roundrect);
            }
            this.margemTitulo = g.getFontMetrics(this.getFont()).getHeight() + 8;
            if (this.delimite) {
                g.drawLine(this.L + 1, this.T + this.margemTitulo, this.W + this.L - 2 + 1, this.T + this.margemTitulo);
            }
        } else {
            if (this.isPintarBorda()) {
                g.setPaint(this.isDisablePainted() ? this.disabledColor : Color.darkGray);
                g.drawRect(this.L, this.T, this.W, this.H);
                g.setPaint(this.isDisablePainted() ? this.disabledColor : Color.gray);
                g.drawRect(this.L, this.T, this.W + 1, this.H + 1);
                g.setPaint(this.getCorBorda());
                g.drawRect(this.L, this.T, this.W - 1, this.H - 1);
            }
            this.margemTitulo = g.getFontMetrics(this.getFont()).getHeight() + 8;
            if (this.delimite) {
                g.drawLine(this.L + 1, this.T + this.margemTitulo, this.W + this.L - 2 + 1, this.T + this.margemTitulo);
            }
        }
        g.setPaint(paintg);
    }

    public Color getCorBorda() {
        return this.isDisablePainted() ? this.disabledColor : this.corBorda;
    }

    public void setCorBorda(Color corBorda) {
        this.corBorda = corBorda;
        this.InvalidateArea();
    }

    public boolean isAlteraForma() {
        return this.alteraForma;
    }

    public void setAlteraForma(boolean alteraForma) {
        this.alteraForma = alteraForma;
    }

    public float getAlfa() {
        return this.alfa;
    }

    public void setAlfa(float alfa) {
        this.alfa = alfa;
        this.InvalidateArea();
    }

    public void SetAlfa(int alfa) {
        this.alfa = (float)alfa / 100.0f;
        if (this.alfa > 1.0f) {
            this.alfa = 0.5f;
        }
        this.InvalidateArea();
    }

    public boolean isDelimite() {
        return this.delimite;
    }

    public void setDelimite(boolean delimite) {
        this.delimite = delimite;
        this.InvalidateArea();
    }

    public int getRoundrect() {
        return this.roundrect;
    }

    public void setRoundrect(int roundrect) {
        this.roundrect = roundrect;
        this.InvalidateArea();
    }

    public int getGDirecao() {
        return this.gdirecao;
    }

    public void setGDirecao(int aDirection) {
        this.gdirecao = aDirection;
        this.InvalidateArea();
    }

    public boolean isGradiente() {
        return this.gradiente;
    }

    public void setGradiente(boolean gradiente) {
        if (this.gradiente != gradiente) {
            this.gradiente = gradiente;
            this.InvalidateArea();
        }
    }

    public Color getGradienteStartColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteStartColor;
    }

    public void setGradienteStartColor(Color gradienteStartColor) {
        this.gradienteStartColor = gradienteStartColor;
        this.InvalidateArea();
    }

    public Color getGradienteEndColor() {
        return this.isDisablePainted() ? this.disabledColor : this.gradienteEndColor;
    }

    public void setGradienteEndColor(Color gradienteEndColor) {
        this.gradienteEndColor = gradienteEndColor;
        this.InvalidateArea();
    }

    protected void PaintGradiente(Graphics2D g) {
        int dist = 0;
        this.DimensioneParaPintura();
        this.W -= dist;
        this.H -= dist;
        boolean dv = this.getGDirecao() == 0;
        int type = 3;
        g.setComposite(AlphaComposite.getInstance(type, this.alfa));
        GradientPaint GP = new GradientPaint(this.L, this.T, this.getGradienteStartColor(), dv ? (float)this.L : (float)(this.L + this.W), dv ? (float)(this.T + this.H) : (float)this.T, this.getGradienteEndColor(), true);
        g.setPaint(GP);
        if (this.roundrect > 0 && this.isPintarBorda()) {
            g.fillRoundRect(this.L + 1, this.T + 1, this.W, this.H, this.roundrect, this.roundrect);
        } else {
            g.fillRect(this.L + 1, this.T + 1, this.W, this.H);
        }
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        ArrayList<InspectorProperty> res = GP;
        if (!this.blankPaint) {
            if (this.isAlteraForma()) {
                res.add(InspectorProperty.PropertyFactoryNumero("diagrama.detalhe.roundrect", "setRoundrect", this.getRoundrect()));
                res.add(InspectorProperty.PropertyFactorySN("diagrama.detalhe.delimite", "setDelimite", this.isDelimite()));
            }
            res.add(InspectorProperty.PropertyFactorySeparador("diagrama.gradiente"));
            String[] grupo = new String[]{"setGradienteStartColor", "setGradienteEndColor", "SetAlfa", "setGDirecao"};
            res.add(InspectorProperty.PropertyFactoryCor("diagrama.gradiente.corborda", "setCorBorda", this.getCorBorda()));
            res.add(InspectorProperty.PropertyFactorySN("diagrama.gradiente.is", "setGradiente", this.isGradiente()).AddCondicaoForTrue(grupo));
            res.add(InspectorProperty.PropertyFactoryCor("diagrama.gradiente.startcor", "setGradienteStartColor", this.getGradienteStartColor()));
            res.add(InspectorProperty.PropertyFactoryCor("diagrama.gradiente.endcor", "setGradienteEndColor", this.getGradienteEndColor()));
            res.add(InspectorProperty.PropertyFactoryNumero("diagrama.detalhe.alfa", "SetAlfa", (int)(100.0f * this.getAlfa())));
            res.add(InspectorProperty.PropertyFactoryMenu("diagrama.gradiente.direcao", "setGDirecao", this.getGDirecao(), Editor.fromConfiguracao.getLstDirecao(Controler.Comandos.cmdTexto)));
        }
        return super.CompleteGenerateProperty(GP);
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Delimite", this.isDelimite()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Roundrect", this.getRoundrect()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Gradiente", this.isGradiente()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteStartColor", this.getGradienteStartColor()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteEndColor", this.getGradienteEndColor()));
        me.appendChild(XMLGenerate.ValorColor(doc, "CorBorda", this.getCorBorda()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "GDirecao", this.getGDirecao()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Alfa", (int)(100.0f * this.getAlfa())));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        int l;
        this.setGradiente(XMLGenerate.getValorBooleanFrom(me, "Gradiente"));
        this.setDelimite(XMLGenerate.getValorBooleanFrom(me, "Delimite"));
        this.setRoundrect(XMLGenerate.getValorIntegerFrom(me, "Roundrect"));
        Color c = XMLGenerate.getValorColorFrom(me, "GradienteStartColor");
        if (c != null) {
            this.setGradienteStartColor(c);
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "GradienteEndColor")) != null) {
            this.setGradienteEndColor(c);
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "CorBorda")) != null) {
            this.setCorBorda(c);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "GDirecao")) != -1) {
            this.setGDirecao(l);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Alfa")) != -1) {
            this.SetAlfa(l);
        }
        return super.LoadFromXML(me, colando);
    }
}

