/*
 * Decompiled with CFR 0.152.
 */
package desenho.linhas;

import controlador.Diagrama;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.linhas.PontoDeLinha;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class Linha
extends FormaElementar {
    private static final long serialVersionUID = 2744377223700872067L;
    private float largura = 1.0f;
    protected float fator_largura = 1.0f;
    private final float larguraBase = 1.0f;
    private ArrayList<PontoDeLinha> Pontos = new ArrayList();
    private Point[] PontosParaDesenho = null;
    private int[] pontosParaDesenhoX = null;
    private int[] pontosParaDesenhoY = null;
    private boolean dashed = false;
    public transient Forma[] FormasALigar = null;
    transient boolean jaSel = false;
    transient boolean dragging = false;

    public Linha(Diagrama master) {
        super(master);
    }

    public ArrayList<PontoDeLinha> getPontos() {
        return this.Pontos;
    }

    public synchronized Point[] getPontosParaDesenho() {
        if (this.PontosParaDesenho != null) {
            return this.PontosParaDesenho;
        }
        this.PontosParaDesenho = new Point[this.Pontos.size()];
        this.pontosParaDesenhoX = new int[this.Pontos.size()];
        this.pontosParaDesenhoY = new int[this.Pontos.size()];
        int i = 0;
        for (PontoDeLinha pt : this.Pontos) {
            this.PontosParaDesenho[i] = pt.getCentro();
            this.pontosParaDesenhoX[i] = this.PontosParaDesenho[i].x;
            this.pontosParaDesenhoY[i] = this.PontosParaDesenho[i].y;
            ++i;
        }
        return this.PontosParaDesenho;
    }

    public synchronized void setPontosParaDesenho(Point[] ptt) {
        this.PontosParaDesenho = ptt;
        if (ptt == null) {
            this.pontosParaDesenhoX = null;
            this.pontosParaDesenhoY = null;
            return;
        }
        int i = 0;
        this.pontosParaDesenhoX = new int[this.PontosParaDesenho.length];
        this.pontosParaDesenhoY = new int[this.PontosParaDesenho.length];
        for (Point pt : this.PontosParaDesenho) {
            this.pontosParaDesenhoX[i] = pt.x;
            this.pontosParaDesenhoY[i] = pt.y;
            ++i;
        }
    }

    public PontoDeLinha NovoPonto() {
        this.setPontosParaDesenho(null);
        PontoDeLinha pt = new PontoDeLinha(this);
        this.Pontos.add(pt);
        return pt;
    }

    public synchronized PontoDeLinha InserirPonto(int posicao) {
        if (posicao < 0 || posicao > this.Pontos.size() - 1) {
            return null;
        }
        this.setPontosParaDesenho(null);
        PontoDeLinha pt = new PontoDeLinha(this);
        this.Pontos.add(posicao, pt);
        pt.IsTopOrBotton = false;
        return pt;
    }

    public PontoDeLinha InserirPonto(PontoDeLinha autal) {
        PontoDeLinha pt = this.InserirPonto(this.Pontos.indexOf(autal));
        return pt;
    }

    public void Inicie(Rectangle local) {
        int espacoY;
        int espacoX;
        this.SetBounds(local);
        if (this.Pontos.isEmpty()) {
            PontoDeLinha pt1 = this.NovoPonto();
            PontoDeLinha pt2 = this.InserirPonto(pt1);
            pt2.IsTopOrBotton = false;
            this.InserirPonto(pt2);
        }
        PontoDeLinha pt = this.Pontos.get(0);
        pt.setLocation(local.getLocation());
        int qtdPontos = this.Pontos.size();
        pt = this.Pontos.get(qtdPontos - 1);
        pt.setLocation(local.x + local.width - pt.getWidth(), local.y + local.height - pt.getHeight());
        int posX = espacoX = local.width / (qtdPontos - 1);
        int posY = espacoY = local.height / (qtdPontos - 1);
        for (int i = 1; i < qtdPontos - 1; ++i) {
            this.Pontos.get(i).setCentro(new Point(this.getLeft() + posX, this.getTop() + posY));
            posX += espacoX;
            posY += espacoY;
        }
    }

    public boolean isDuplaLinha() {
        return this.largura != 1.0f;
    }

    public void setDuplaLinha(boolean sn) {
        if (sn) {
            this.setLargura(2.0f);
        } else {
            this.setLargura(1.0f);
        }
        this.InvalidateArea();
    }

    public boolean isDashed() {
        return this.dashed;
    }

    public void setDashed(boolean dashed) {
        if (this.dashed != dashed) {
            this.dashed = dashed;
            this.DoMuda();
            this.InvalidateArea();
        }
    }

    @Override
    public void DoPaint(Graphics2D g) {
        super.DoPaint(g);
        Stroke bkp = g.getStroke();
        g.setPaint(this.getForeColor());
        if (this.getPontosParaDesenho() != null) {
            if (this.isDashed()) {
                g.setStroke(new BasicStroke(this.getLargura(), 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
            } else {
                g.setStroke(new BasicStroke(this.getLargura(), 1, 1));
            }
            g.drawPolyline(this.pontosParaDesenhoX, this.pontosParaDesenhoY, this.pontosParaDesenhoX.length);
        }
        g.setStroke(bkp);
    }

    @Override
    public boolean IsMe(Point p) {
        boolean res = false;
        if (!super.IsMe(p) || this.getPontosParaDesenho() == null) {
            return false;
        }
        for (int i = 1; i < this.PontosParaDesenho.length; ++i) {
            if (!Linha.SegmentIntersectRectangle(p.x - 1, p.y - 1, p.x + 1, p.y + 1, this.PontosParaDesenho[i - 1].x, this.PontosParaDesenho[i - 1].y, this.PontosParaDesenho[i].x, this.PontosParaDesenho[i].y)) continue;
            return true;
        }
        return res;
    }

    @Override
    public void setSelecionado(boolean sel) {
        super.setSelecionado(sel);
        for (int i = 0; i < this.Pontos.size(); ++i) {
            this.Pontos.get(i).setVisible(sel && this.isVisible());
            if (!sel) continue;
            this.Pontos.get(i).BringToFront();
        }
        this.mouseExited(null);
    }

    @Override
    public void DoPontoCor(boolean verde) {
        Color cor = verde ? this.getMaster().getPontoCorMultSel() : this.getMaster().getPontoCor();
        for (PontoDeLinha pt : this.Pontos) {
            pt.setBackColor(cor);
        }
    }

    @Override
    public void HidePontos(boolean esconde) {
        super.HidePontos(esconde);
        for (int i = 0; i < this.Pontos.size(); ++i) {
            this.Pontos.get(i).setIsHide(esconde);
        }
    }

    @Override
    public void reSetBounds() {
        this.PontosParaDesenho = null;
        int menorLeft = this.Pontos.get(0).getLeft();
        int menorTop = this.Pontos.get(0).getTop();
        int maiorLeft = this.Pontos.get(0).getLeft();
        int maiorTop = this.Pontos.get(0).getTop();
        for (PontoDeLinha pt : this.Pontos) {
            menorLeft = Math.min(pt.getLeft(), menorLeft);
            menorTop = Math.min(pt.getTop(), menorTop);
            maiorLeft = Math.max(pt.getLeft(), maiorLeft);
            maiorTop = Math.max(pt.getTop(), maiorTop);
        }
        this.SetBounds(menorLeft, menorTop, maiorLeft + this.Pontos.get(0).getWidth() - menorLeft, maiorTop + this.Pontos.get(0).getHeight() - menorTop);
        this.InvalidateArea();
    }

    public boolean AnexePontos() {
        PontoDeLinha pt = this.Pontos.get(0);
        boolean done = false;
        if (this.FormasALigar != null && this.FormasALigar.length == 0) {
            return this.Ligar();
        }
        Elementar res = this.getMaster().CaptureBaseFromPoint(null, pt.getCentro());
        if (res instanceof Forma) {
            res = res.ProcessaComposicao(pt.getCentro());
            pt.setEm((Forma)res);
            done = true;
        } else {
            pt.setEm(null);
        }
        PontoDeLinha pt2 = this.Pontos.get(this.Pontos.size() - 1);
        res = this.getMaster().CaptureBaseFromPoint(null, pt2.getCentro());
        if (res instanceof Forma) {
            res = res.ProcessaComposicao(pt2.getCentro());
            pt2.setEm((Forma)res);
            done = true;
        } else {
            pt2.setEm(null);
        }
        if (done) {
            if (pt.getEm() != null) {
                pt.getEm().PosicionePonto(pt);
            }
            if (pt2.getEm() != null) {
                pt2.getEm().PosicionePonto(pt2);
            }
            this.OrganizeLinha();
            this.Recalcule();
        } else {
            this.InvalidateArea();
        }
        return done;
    }

    public boolean Ligar() {
        if (this.FormasALigar == null || this.FormasALigar.length != 2) {
            return false;
        }
        PontoDeLinha pt = this.Pontos.get(0);
        Elementar res = this.FormasALigar[0];
        res = res.ProcessaComposicao(pt.getCentro());
        pt.setEm((Forma)res);
        PontoDeLinha pt2 = this.Pontos.get(this.Pontos.size() - 1);
        res = this.FormasALigar[1];
        res = res.ProcessaComposicao(pt2.getCentro());
        pt2.setEm((Forma)res);
        this.FormasALigar = null;
        if (pt.getEm() != null) {
            pt.getEm().PosicionePonto(pt);
        }
        if (pt2.getEm() != null) {
            pt2.getEm().PosicionePonto(pt2);
        }
        this.OrganizeLinha();
        this.Recalcule();
        return true;
    }

    private void Recalcule() {
        this.reSetBounds();
    }

    @Override
    public void DoRaiseMove(int movX, int movY) {
        super.DoRaiseMove(movX, movY);
        this.getMaster().ReciveProcessMove(this, movX, movY);
    }

    @Override
    public void DoMove(int movX, int movY) {
        if (this.getMaster().IsMultSelecionado()) {
            for (PontoDeLinha pt2 : this.Pontos) {
                Forma tmp;
                if (pt2.IsTopOrBotton && pt2.isEstaLigado() && (pt2.getEm().isParte() && pt2.getEm().getPrincipal() instanceof Forma ? !(tmp = (Forma)pt2.getEm().getPrincipal()).isSelecionado() : !pt2.getEm().isSelecionado())) continue;
                pt2.DoMove(movX, movY);
            }
        } else {
            this.Pontos.stream().forEach(pt -> pt.DoMove(movX, movY));
        }
        this.Recalcule();
    }

    @Override
    public boolean Reenquadre() {
        boolean res = false;
        if (this.isSelecionado() && this.getMaster().IsMultSelecionado()) {
            for (PontoDeLinha pt : this.Pontos) {
                if (pt.isEstaLigado()) continue;
                res = pt.Reenquadre();
            }
        } else {
            for (PontoDeLinha pt : this.Pontos) {
                res = pt.Reenquadre();
            }
        }
        if (res) {
            this.Recalcule();
        }
        return res;
    }

    @Override
    public void DoRaizeReenquadreReposicione() {
        this.getMaster().DoBaseReenquadreReposicione();
    }

    protected void DoRaizeReenquadre() {
        if (this.isSelecionado()) {
            this.getMaster().DoBaseReenquadreReposicione();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isSelecionado()) {
            this.getMaster().DiagramaDoSelecao(this, true, false);
            this.jaSel = false;
        } else {
            this.jaSel = true;
        }
        PontoDeLinha pt = this.getPontaA();
        if (pt != null && pt.ForceIsMe(e.getPoint())) {
            this.getMaster().setElementarSobMouse(pt);
            pt.mousePressed(e);
            return;
        }
        pt = this.getPontaB();
        if (pt != null && pt.ForceIsMe(e.getPoint())) {
            this.getMaster().setElementarSobMouse(pt);
            pt.mousePressed(e);
            return;
        }
        super.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.jaSel) {
            boolean combine;
            boolean bl = combine = this.getMaster().isShiftDown() || this.getMaster().isControlDown();
            if (combine) {
                this.getMaster().DiagramaDoSelecao(this, true, false);
            }
        }
        if (!this.isAncorado()) {
            this.ProcessPontoMouseUp();
        }
        this.dragging = false;
        this.getPontaA().ProcessaOverDraw(true);
        this.getPontaB().ProcessaOverDraw(true);
        super.mouseReleased(e);
        this.Invalidate();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.dragging = true;
        if (!this.getMaster().IsMultSelecionado()) {
            this.getPontaA().ProcessaOverDraw(false);
            this.getPontaB().ProcessaOverDraw(false);
        }
    }

    private void ProcessPontoMouseUp() {
        if (this.getMaster().IsMultSelecionado() || !this.dragging) {
            return;
        }
        this.AnexePontos();
    }

    @Override
    public boolean IntersectPath(Rectangle recsel) {
        if (!super.IntersectPath(recsel)) {
            return false;
        }
        int fimX = recsel.width + recsel.x;
        int fimY = recsel.height + recsel.y;
        for (int i = 1; i < this.PontosParaDesenho.length; ++i) {
            if (!Linha.SegmentIntersectRectangle(recsel.x, recsel.y, fimX, fimY, this.PontosParaDesenho[i - 1].x, this.PontosParaDesenho[i - 1].y, this.PontosParaDesenho[i].x, this.PontosParaDesenho[i].y)) continue;
            return true;
        }
        return false;
    }

    public static boolean SegmentIntersectRectangle(double a_rectangleMinX, double a_rectangleMinY, double a_rectangleMaxX, double a_rectangleMaxY, double a_p1x, double a_p1y, double a_p2x, double a_p2y) {
        double minX = a_p1x;
        double maxX = a_p2x;
        if (a_p1x > a_p2x) {
            minX = a_p2x;
            maxX = a_p1x;
        }
        if (maxX > a_rectangleMaxX) {
            maxX = a_rectangleMaxX;
        }
        if (minX < a_rectangleMinX) {
            minX = a_rectangleMinX;
        }
        if (minX > maxX) {
            return false;
        }
        double minY = a_p1y;
        double maxY = a_p2y;
        double dx = a_p2x - a_p1x;
        if (Math.abs(dx) > 1.0E-7) {
            double a = (a_p2y - a_p1y) / dx;
            double b = a_p1y - a * a_p1x;
            minY = a * minX + b;
            maxY = a * maxX + b;
        }
        if (minY > maxY) {
            double tmp = maxY;
            maxY = minY;
            minY = tmp;
        }
        if (maxY > a_rectangleMaxY) {
            maxY = a_rectangleMaxY;
        }
        if (minY < a_rectangleMinY) {
            minY = a_rectangleMinY;
        }
        return !(minY > maxY);
    }

    public synchronized void OrganizeLinha() {
    }

    protected float getLargura() {
        return this.largura * this.fator_largura;
    }

    protected void setLargura(float largura) {
        this.largura = largura;
    }

    public PontoDeLinha getPontaA() {
        if (this.Pontos.size() > 0) {
            return this.getPontos().get(0);
        }
        return null;
    }

    public PontoDeLinha getPontaB() {
        if (this.Pontos.size() > 0) {
            return this.getPontos().get(this.getPontos().size() - 1);
        }
        return null;
    }

    public Forma getFormaPontaA() {
        return this.getPontos().get(0).getEm();
    }

    public Forma getFormaPontaB() {
        return this.getPontos().get(this.getPontos().size() - 1).getEm();
    }

    public Forma getOutraPonta(Forma forma) {
        if (this.getFormaPontaA() == forma) {
            return this.getFormaPontaB();
        }
        return this.getFormaPontaA();
    }

    public PontoDeLinha getOutraPonta(PontoDeLinha pt) {
        if (this.getPontaA() == pt) {
            return this.getPontaB();
        }
        return this.getPontaA();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        this.fator_largura = 2.0f;
        this.InvalidateArea(this.getBounds());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e != null) {
            super.mouseExited(e);
        }
        this.fator_largura = 1.0f;
        this.InvalidateArea(this.getBounds());
    }

    public void Clean() {
        while (2 < this.getPontos().size()) {
            this.RemoveSubItem(this.Pontos.get(1));
        }
        this.setPontosParaDesenho(null);
        this.OrganizeLinha();
        this.Recalcule();
    }

    @Override
    public void RemoveSubItem(Elementar si) {
        super.RemoveSubItem(si);
        if (si instanceof PontoDeLinha) {
            this.Pontos.remove((PontoDeLinha)si);
        }
    }
}

