/*
 * Decompiled with CFR 0.152.
 */
package controlador;

import controlador.BaseControlador;
import controlador.Diagrama;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.image.BufferedImage;
import util.ImageGenerate;
import util.PrintControler;

public class Impressor
extends BaseControlador {
    private final int LINHAS = 3;
    private int Linhas = 3;
    private int Colunas = 3;
    private boolean proporcionalLinha = true;
    private Diagrama diagrama = null;
    public final PrintControler Impressora = new PrintControler();
    private boolean naoConsiderarLinhasColunas = false;
    private int LarguraPagina = 0;
    private int AlturaPagina = 0;
    private int PaginasW = 0;
    private int PaginasH = 0;
    BufferedImage[] imgs = null;

    public Impressor() {
        this.setSize(new Dimension(512, 512));
        this.setPreferredSize(this.getSize());
        this.setBackground(Color.WHITE);
        this.setLinhas(3);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D Canvas = (Graphics2D)g;
        Canvas.setPaint(Color.BLACK);
        Canvas.draw3DRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, true);
        if (this.getDiagrama() == null) {
            return;
        }
        int w = this.LarguraPagina;
        int h = this.AlturaPagina;
        if (!this.proporcionalLinha) {
            int i;
            int nh = this.AlturaPagina;
            this.PinteNoArea(Canvas);
            for (i = w; i < this.getWidth() + this.getColunas(); i += w) {
                Canvas.drawLine(i, 1, i, this.getHeight());
            }
            if (!this.isNaoConsiderarLinhasColunas()) {
                Canvas.setStroke(new BasicStroke(1.0f, 1, 1, 3.0f, new float[]{2.0f, 1.0f}, 0.0f));
            }
            for (i = nh; i < this.getHeight() + this.getLinhas(); i += nh) {
                Canvas.drawLine(1, i, this.getWidth(), i);
            }
        } else {
            int i;
            int nw = this.LarguraPagina;
            this.PinteNoArea(Canvas);
            for (i = h; i < this.getHeight() + this.getLinhas(); i += h) {
                Canvas.drawLine(1, i, this.getWidth(), i);
            }
            if (!this.isNaoConsiderarLinhasColunas()) {
                Canvas.setStroke(new BasicStroke(1.0f, 1, 1, 3.0f, new float[]{2.0f, 1.0f}, 0.0f));
            }
            for (i = nw; i < this.getWidth() + this.getColunas(); i += nw) {
                Canvas.drawLine(i, 1, i, this.getHeight());
            }
        }
        double z = (double)this.getWidth() / (double)this.getDiagrama().getWidth();
        Canvas.scale(z, z);
        this.getDiagrama().ExternalPaint(g);
    }

    public int getLinhas() {
        return this.Linhas;
    }

    public boolean isLandscape() {
        return this.Impressora.getPage().getOrientation() == 0;
    }

    public final void setLinhas(int Linhas) {
        int nc;
        this.Linhas = Linhas;
        this.proporcionalLinha = true;
        int p_larg = this.Impressora.getPageWidth();
        int p_alt = this.Impressora.getPageHeigth();
        int h = this.getHeight() / Linhas;
        int nw = h * p_larg / p_alt;
        this.Colunas = nc = this.getWidth() / nw + (this.getWidth() % nw > 1 ? 1 : 0);
        this.CalculePagina();
        this.repaint();
    }

    public int getColunas() {
        return this.Colunas;
    }

    public void setColunas(int Colunas) {
        int nl;
        this.Colunas = Colunas;
        this.proporcionalLinha = false;
        int p_larg = this.Impressora.getPageWidth();
        int p_alt = this.Impressora.getPageHeigth();
        int w = this.getWidth() / Colunas;
        int nh = w * p_alt / p_larg;
        this.Linhas = nl = this.getHeight() / nh + (this.getHeight() % nh > 1 ? 1 : 0);
        this.CalculePagina();
        this.repaint();
    }

    public Diagrama getDiagrama() {
        return this.diagrama;
    }

    public void setDiagrama(Diagrama diagrama) {
        this.diagrama = diagrama;
        this.CalculePagina();
        this.repaint();
    }

    public PrintControler getImpressora() {
        return this.Impressora;
    }

    private void PinteNoArea(Graphics2D Canvas) {
        if (this.getDiagrama() != null) {
            Paint bkp = Canvas.getPaint();
            Canvas.setColor(new Color(241, 241, 241));
            int x = this.PaginasW * this.LarguraPagina;
            Canvas.fillRect(x + 2, 2, this.getWidth() - (x + 4), this.getHeight() - 4);
            int y = this.PaginasH * this.AlturaPagina;
            Canvas.fillRect(2, y + 2, this.getWidth() - 4, this.getHeight() - (y + 4));
            Canvas.setPaint(bkp);
        }
    }

    public void CalculePagina() {
        int p_larg = this.Impressora.getPageWidth();
        int p_alt = this.Impressora.getPageHeigth();
        if (this.isNaoConsiderarLinhasColunas() && this.getDiagrama() != null) {
            double proporcao = (double)this.getWidth() / (double)this.getDiagrama().getWidth();
            p_larg = (int)((double)p_larg * proporcao);
            p_alt = (int)((double)p_alt * proporcao);
            this.SubCalculePagina(p_larg, p_alt);
            this.Linhas = (int)Math.ceil((double)this.getWidth() / (double)p_larg);
            this.Colunas = (int)Math.ceil((double)this.getHeight() / (double)p_alt);
        } else {
            int w = this.getWidth() / this.getColunas();
            int h = this.getHeight() / this.getLinhas();
            if (!this.proporcionalLinha) {
                int nh = w * p_alt / p_larg;
                this.SubCalculePagina(w, nh);
            } else {
                int nw = h * p_larg / p_alt;
                this.SubCalculePagina(nw, h);
            }
        }
    }

    private void SubCalculePagina(int wdt, int ht) {
        if (this.getDiagrama() != null) {
            double z = (double)this.getWidth() / (double)this.getDiagrama().getWidth();
            Point mx = this.getDiagrama().getPontoExtremo();
            Point r = new Point((int)((double)mx.x * z), (int)((double)mx.y * z));
            this.LarguraPagina = wdt;
            this.AlturaPagina = ht;
            this.PaginasW = r.x / wdt + (r.x % wdt > 0 ? 1 : 0);
            this.PaginasH = r.y / ht + (r.y % ht > 0 ? 1 : 0);
        }
    }

    public int getQtdPagina() {
        return this.PaginasH * this.PaginasW;
    }

    public boolean iniceProcessoImpressao() {
        double proporcao = (double)this.getDiagrama().getWidth() / (double)this.getWidth();
        int w = (int)((double)this.LarguraPagina * proporcao);
        int h = (int)((double)this.AlturaPagina * proporcao);
        BufferedImage img = ImageGenerate.geraImagemForPrn(this.getDiagrama(), w * this.PaginasW, h * this.PaginasH);
        this.imgs = ImageGenerate.SplitImagens(img, w, h, this.PaginasW, this.PaginasH, this.getQtdPagina());
        return true;
    }

    public Point getAreaImpressao() {
        double proporcao = (double)this.getDiagrama().getWidth() / (double)this.getWidth();
        int w = (int)((double)this.LarguraPagina * proporcao);
        int h = (int)((double)this.AlturaPagina * proporcao);
        return new Point(w, h);
    }

    public void iniceImpressao() {
        this.iniceProcessoImpressao();
        this.Impressora.setPaginas(this.imgs);
    }

    public void iniceImpressaoNoPreview(int unica) {
        if (this.imgs == null) {
            return;
        }
        BufferedImage[] im = new BufferedImage[]{this.imgs[unica - 1]};
        this.Impressora.setPaginas(im);
    }

    public void finalizeImpressaoNoPreview() {
        this.Impressora.setPaginas(this.imgs);
    }

    public void finalizeImpressao() {
        this.imgs = null;
        this.Impressora.setPaginas(this.imgs);
    }

    public boolean isNaoConsiderarLinhasColunas() {
        return this.naoConsiderarLinhasColunas;
    }

    public void setNaoConsiderarLinhasColunas(boolean naoConsiderarLinhasColunas) {
        this.naoConsiderarLinhasColunas = naoConsiderarLinhasColunas;
        if (!naoConsiderarLinhasColunas) {
            this.setLinhas(3);
        } else {
            this.CalculePagina();
        }
        this.repaint();
    }
}

