/*
 * Decompiled with CFR 0.152.
 */
package diagramas.logico;

import controlador.Editor;
import controlador.apoios.TreeItem;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import diagramas.logico.Constraint;
import diagramas.logico.Tabela;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.TratadorDeImagens;
import util.XMLGenerate;

public class Campo
implements Serializable {
    private static final long serialVersionUID = 2099779589753765643L;
    private final Tabela tabela;
    public Rectangle area = null;
    private String texto = "";
    private String tipo = "";
    private String complemento = "";
    private String observacao = "";
    private String dicionario = "";
    private boolean separador = false;
    private boolean key = false;
    private boolean fkey = false;
    private boolean selecionado = false;
    private boolean Unique = false;
    private final int DESCE_CAMPO = 1;
    private final int SOBE_CAMPO = -1;
    protected transient boolean roqued = false;

    public Tabela getTabela() {
        return this.tabela;
    }

    public Campo(Tabela tbl) {
        this.tabela = tbl;
        this.tabela.Add(this);
    }

    public void Paint(int x, int y, int altura, Graphics2D g) {
        Rectangle r;
        int f = 2 * this.getTabela().DDL_PEGAR_TUDO;
        int imgl = 16;
        this.area = r = new Rectangle(this.getTabela().getLeft() + x, this.getTabela().getTop() + y, this.getTabela().getWidth() - x - 1, altura);
        if (r.y + altura > this.getTabela().getTopHeight()) {
            return;
        }
        float alfa = 1.0f - this.getTabela().getAlfa();
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, alfa));
        Paint bkpp = g.getPaint();
        g.setColor(this.getTabela().getMaster().getBackground());
        g.fill(this.area);
        if (this.isSelecionado()) {
            if (this.getTabela().isGradiente()) {
                g.setColor(this.getTabela().getGradienteStartColor());
            } else {
                g.setColor(this.getTabela().getForeColor());
            }
            g.setComposite(AlphaComposite.getInstance(3, this.getTabela().getAlfa()));
            g.fillRect(r.x, r.y, r.width + 1, r.height);
        }
        g.setPaint(bkpp);
        g.setComposite(originalComposite);
        Rectangle bkp = g.getClipBounds();
        ImageIcon img = null;
        if (this.isFkey()) {
            if (this.getCampoOrigem() == null) {
                g.drawRoundRect(r.x - 1 + f, r.y + 4 - 1, imgl + 1, imgl + 1, 4, 4);
            }
            img = this.isKey() ? Editor.fromControler().ImagemDeDiagrama.get(this.getTabela().imgkfk) : (this.isUnique() ? Editor.fromControler().ImagemDeDiagrama.get(this.getTabela().imgunfk) : Editor.fromControler().ImagemDeDiagrama.get(this.getTabela().imgfk));
        } else if (this.isKey()) {
            img = Editor.fromControler().ImagemDeDiagrama.get(this.getTabela().imgk);
        } else if (this.isUnique()) {
            img = Editor.fromControler().ImagemDeDiagrama.get(this.getTabela().imgun);
        }
        if (img != null) {
            if (this.getTabela().isDisablePainted()) {
                img = new ImageIcon(TratadorDeImagens.dye(img, this.getTabela().getForeColor()));
            }
            g.drawImage(img.getImage(), r.x + f, r.y + 4, imgl, imgl, null);
        }
        g.clipRect(r.x, r.y, r.width, r.height);
        g.setColor(this.getTabela().getForeColor());
        g.drawString(this.GetTexto(), r.x + f + imgl + 2, r.y + altura / 2 + f);
        g.setClip(bkp);
        g.setPaint(bkpp);
    }

    protected String GetTexto() {
        return this.getTexto() + (this.getTipo().isEmpty() ? "" : ": " + this.getTipo());
    }

    public boolean isMe(Point p) {
        if (this.area == null) {
            return false;
        }
        return this.area.contains(p);
    }

    public Campo getCampoOrigem() {
        Constraint cons = this.getTabela().getPresentAsFK(this);
        if (cons == null) {
            return null;
        }
        int idx = cons.getCamposDeDestino().indexOf(this);
        if (idx > -1) {
            return cons.getCamposDeOrigem().get(idx);
        }
        return null;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getDicionario() {
        return this.dicionario;
    }

    public void setDicionario(String dicionario) {
        this.dicionario = dicionario;
    }

    public boolean isFkey() {
        return this.fkey;
    }

    public void setFkey(boolean fkey) {
        if (this.fkey != fkey) {
            this.fkey = fkey;
            this.getTabela().ProcesseIrFK(this);
            this.Repaint();
        }
    }

    public void SetFkey(boolean fkey) {
        this.fkey = fkey;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        if (this.key != key) {
            this.key = key;
            this.getTabela().ProcesseIrKey(this);
            this.Repaint();
        }
    }

    public void SetKey(boolean key) {
        this.key = key;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean isSeparador() {
        return this.separador;
    }

    public void setSeparador(boolean separador) {
        this.separador = separador;
    }

    public String getTexto() {
        return this.texto;
    }

    public void setTexto(String texto) {
        if (!this.texto.equals(texto)) {
            this.texto = texto;
            this.Repaint();
            this.getTabela().RefreshPosNovoTexto();
        }
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        if (!this.tipo.equals(tipo)) {
            this.tipo = tipo;
            this.getTabela().NotifiqueIR(null, 6, this);
            this.Repaint();
        }
    }

    public boolean isUnique() {
        return this.Unique;
    }

    public void setUnique(boolean Unique) {
        if (this.Unique == Unique) {
            return;
        }
        this.Unique = Unique;
        this.getTabela().ProcesseIrUnique(this);
        this.Repaint();
    }

    public void SetUnique(boolean Unique) {
        this.Unique = Unique;
    }

    public void SetUnique(boolean isadd, Constraint constr) {
        if (isadd) {
            this.Unique = true;
            this.getTabela().ProcesseIrUnique(this, constr, isadd);
            return;
        }
        this.getTabela().ProcesseIrUnique(this, constr, isadd);
        List<Constraint> lst = this.getTabela().getPresentAsUN(this);
        this.Unique = !lst.isEmpty();
        this.Repaint();
    }

    public boolean isSelecionado() {
        return this.selecionado && this.getTabela().isSelecionado();
    }

    public void setSelecionado(boolean selecionado) {
        this.selecionado = selecionado;
    }

    public Tabela getTabelaOrigem() {
        Campo c = this.getCampoOrigem();
        if (c != null) {
            return c.getTabela();
        }
        return null;
    }

    public boolean SuperSelecionado() {
        return this.tabela.isSelecionado() && this.isSelecionado();
    }

    public void ToXmlValores(Document doc, Element root) {
        Element me = doc.createElement("Campo");
        if (this.isSeparador()) {
            me.appendChild(XMLGenerate.ValorBoolean(doc, "Separador", this.isSeparador()));
        } else {
            me.appendChild(XMLGenerate.ValorText(doc, "Texto", this.getTexto()));
            me.appendChild(XMLGenerate.ValorText(doc, "Tipo", this.getTipo()));
            me.appendChild(XMLGenerate.ValorText(doc, "Complemento", this.getComplemento()));
            me.appendChild(XMLGenerate.ValorText(doc, "Dicionario", this.getDicionario()));
            me.appendChild(XMLGenerate.ValorText(doc, "Observacao", this.getObservacao()));
            me.appendChild(XMLGenerate.ValorBoolean(doc, "Key", this.isKey()));
            me.appendChild(XMLGenerate.ValorBoolean(doc, "Fkey", this.isFkey()));
            me.appendChild(XMLGenerate.ValorBoolean(doc, "Unique", this.isUnique()));
        }
        root.appendChild(me);
    }

    public void LoadFromXML(Element me, boolean colando) {
        String tmp = XMLGenerate.getValorTextoFrom(me, "Texto");
        if (tmp != null) {
            this.setTexto(tmp);
            this.setObservacao(XMLGenerate.getValorTextoFrom(me, "Observacao"));
            this.setDicionario(XMLGenerate.getValorTextoFrom(me, "Dicionario"));
            this.setTipo(XMLGenerate.getValorTextoFrom(me, "Tipo"));
            this.setComplemento(XMLGenerate.getValorTextoFrom(me, "Complemento"));
            this.setKey(XMLGenerate.getValorBooleanFrom(me, "Key"));
            this.setFkey(XMLGenerate.getValorBooleanFrom(me, "Fkey"));
            this.setUnique(XMLGenerate.getValorBooleanFrom(me, "Unique"));
        } else {
            this.setSeparador(true);
        }
    }

    public void Repaint() {
        if (this.getTabela() == null || this.area == null) {
            return;
        }
        this.getTabela().InvalidateArea();
    }

    public void InvalidateArea() {
        if (this.getTabela() == null || this.area == null) {
            return;
        }
        this.getTabela().InvalidateArea(this.area);
    }

    public boolean isFirst() {
        return this.getTabela().getCampos().indexOf(this) == 0;
    }

    public boolean isLast() {
        int tmp = this.getTabela().getCampos().indexOf(this) + 1;
        return tmp == this.getTabela().getCampos().size();
    }

    public boolean isLinkedToTable() {
        Tabela tb = this.getTabelaOrigem();
        return tb != null && this.getTabela().getListaDeTabelasLigadas().indexOf(tb) > -1;
    }

    public int getIndexOnTable() {
        return this.getTabela().getCampos().indexOf(this);
    }

    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> res) {
        res.add(InspectorProperty.PropertyFactorySeparador("campo.selecionado"));
        String relaName = "Campo";
        res.add(InspectorProperty.PropertyFactoryTexto("nome", relaName + ".setTexto", this.getTexto()));
        res.add(InspectorProperty.PropertyFactoryTexto("campo.tipo", relaName + ".setTipo", this.getTipo()));
        res.add(InspectorProperty.PropertyFactoryTexto("campo.complemento", relaName + ".setComplemento", this.getComplemento()));
        res.add(InspectorProperty.PropertyFactoryTextoL("dicionario", relaName + ".setDicionario", this.getDicionario()));
        res.add(InspectorProperty.PropertyFactoryTextoL("observacao", relaName + ".setObservacao", this.getObservacao()));
        res.add(InspectorProperty.PropertyFactorySN("campo.key", relaName + ".setKey", this.isKey()));
        res.add(InspectorProperty.PropertyFactorySN("campo.unique", relaName + ".setUnique", this.isUnique()));
        res.add(InspectorProperty.PropertyFactorySN("campo.fkey", relaName + ".setFkey", this.isFkey()).AddCondicaoForTrue(new String[]{relaName + ".setTabelaOrigem", relaName + ".setCampoOrigem", relaName + ".setDdlOnUpdate", relaName + ".setDdlOnDelete"}));
        if (this.isFkey()) {
            String txt = this.getTabelaOrigem() == null ? "[]" : this.getTabelaOrigem().getTexto();
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "campo.tabelaorigem", txt).setTag(120420181));
            txt = this.getCampoOrigem() == null ? "()" : this.getCampoOrigem().getTexto();
            res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "campo.campoorigem", txt).setTag(120420181));
        } else {
            res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("campo.tabelaorigem", "[]").PropertyForceDisable(true));
            res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("campo.campoorigem", "()").PropertyForceDisable(true));
        }
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdExcluirSubItem.name()));
        if (this.getTabela().getCampos().size() > 1) {
            res.add(InspectorProperty.PropertyFactorySeparador("tabela.campos.posicao", false));
            if (!this.isFirst()) {
                res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "tabela.campos.sobe").setTag(-1));
            }
            if (!this.isLast()) {
                res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "tabela.campos.desce").setTag(1));
            }
        }
        return res;
    }

    protected void MostreSeParaExibicao(TreeItem root) {
        root.add(new TreeItem(this.getTexto() + ": " + this.getTipo(), this.getTabela().getID(), this.getClass().getSimpleName()));
    }
}

