/*
 * Decompiled with CFR 0.152.
 */
package diagramas.conceitual;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.linhas.SuperLinha;
import desenho.preAnyDiagrama.PreTexto;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XMLGenerate;

public class Texto
extends PreTexto {
    private static final long serialVersionUID = -8327102253638096870L;
    private boolean MovimentacaoManual = false;
    private SuperLinha LinhaMestre = null;

    public Texto(Diagrama modelo) {
        super(modelo);
    }

    public Texto(Diagrama modelo, String texto) {
        super(modelo, texto);
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<SuperLinha> lins;
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        InspectorProperty tmp = InspectorProperty.FindByProperty(res, "setTexto");
        tmp.ReSetCaptionFromConfig("texto");
        tmp.tipo = InspectorProperty.TipoDeProperty.tpTextoLongo;
        res.add(res.indexOf(tmp), InspectorProperty.PropertyFactoryTexto("texto.titulo", "setTitulo", this.getTitulo()));
        res.add(res.indexOf(tmp), InspectorProperty.PropertyFactorySN("texto.painttitulo", "setPaintTitulo", this.isPaintTitulo()));
        res.add(InspectorProperty.PropertyFactoryMenu("texto.alinhamento", "setAlinhamentoByInt", this.getAlinhamento().ordinal(), Editor.fromConfiguracao.getLstTextoAlin()));
        res.add(InspectorProperty.PropertyFactorySN("texto.alinhamento.v", "setCentrarVertical", this.isCentrarVertical()));
        res.add(InspectorProperty.PropertyFactoryNumero("diagrama.detalhe.alfa", "SetAlfa", (int)(100.0f * this.getAlfa())));
        InspectorProperty txtTipo = InspectorProperty.PropertyFactoryMenu("texto.tipo", "setTipobyInt", this.getTipo().ordinal(), Editor.fromConfiguracao.getLstTipoTexto());
        res.add(txtTipo);
        res.add(InspectorProperty.PropertyFactoryCor("texto.bkcolor", "setBackColor", this.getBackColor()));
        tmp = InspectorProperty.FindByProperty(res, "setForeColor");
        tmp.ReSetCaptionFromConfig("texto.forecolor");
        res.add(InspectorProperty.PropertyFactorySN("texto.sombra", "setSombra", this.isSombra()).AddCondicaoForTrue(new String[]{"setCorSombra"}));
        res.add(InspectorProperty.PropertyFactoryCor("texto.sombra.cor", "setCorSombra", this.getCorSombra()));
        res.add(InspectorProperty.PropertyFactorySN("texto.autosize", "setAutosize", this.isAutosize()));
        res.add(InspectorProperty.PropertyFactorySeparador("texto.gradiente"));
        String[] grupo = new String[]{"setGradienteStartColor", "setGradienteEndColor", "setGDirecao"};
        res.add(InspectorProperty.PropertyFactorySN("texto.gradiente.is", "setGradiente", this.isGradiente()).AddCondicaoForTrue(grupo).AddCondicaoForTrue(new String[]{"setGradientePinteDetalhe", "setGradienteCorDetalhe"}).AddCondicaoForFalse(new String[]{"setBackColor"}));
        res.add(InspectorProperty.PropertyFactoryCor("texto.gradiente.startcor", "setGradienteStartColor", this.getGradienteStartColor()));
        res.add(InspectorProperty.PropertyFactoryCor("texto.gradiente.endcor", "setGradienteEndColor", this.getGradienteEndColor()));
        res.add(InspectorProperty.PropertyFactorySN("texto.gradiente.detalhe", "setGradientePinteDetalhe", this.isGradientePinteDetalhe()).AddCondicaoForTrue(new String[]{"setGradienteCorDetalhe"}));
        res.add(InspectorProperty.PropertyFactoryCor("texto.gradiente.detalhecor", "setGradienteCorDetalhe", this.getGradienteCorDetalhe()));
        res.add(InspectorProperty.PropertyFactoryMenu("texto.gradiente.direcao", "setGDirecao", this.getGDirecao(), Editor.fromConfiguracao.getLstDirecao(Controler.Comandos.cmdTexto)));
        res.add(InspectorProperty.PropertyFactoryNumero("diagrama.detalhe.alfa", "SetAlfa", (int)(100.0f * this.getAlfa())));
        ArrayList<String> ngrp = new ArrayList<String>(Arrays.asList(grupo));
        ngrp.add("setGradiente");
        ngrp.add("SetAlfa");
        ngrp.add("setBackColor");
        txtTipo.AddCondicao(new String[]{"2", "3"}, new String[]{"setGradientePinteDetalhe", "setGradienteCorDetalhe", "setCorSombra", "setSombra"});
        txtTipo.AddCondicao(new String[]{"1", "2", "3"}, ngrp.toArray(new String[0]));
        txtTipo.AddCondicao(new String[]{"0"}, new String[]{"setAutosize"});
        tmp = InspectorProperty.FindByProperty(res, "setTextoAdicional");
        res.remove(tmp);
        res.add(InspectorProperty.PropertyFactorySeparador("texto.atreladoalinha"));
        if (this.LinhaMestre != null) {
            res.add(InspectorProperty.PropertyFactorySN("texto.movimentacaomanual", "setMovimentacaoManual", this.isMovimentacaoManual()));
        }
        if ((lins = this.getListaDeLinhas()).size() > 0) {
            int a = lins.indexOf(this.getLinhaMestre());
            ArrayList<String> tbls = this.getStrListaDeLinhas(lins);
            tbls.add(0, Editor.fromConfiguracao.getValor("Inspector.obj.selecione"));
            res.add(InspectorProperty.PropertyFactoryMenu("texto.linhamestre", "SetLinhaMestreInt", a + 1, tbls));
        } else {
            res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("texto.linhamestre", ""));
        }
        return res;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorText(doc, "Titulo", this.getTitulo()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "PaintTitulo", this.isPaintTitulo()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Alinhamento", this.getAlinhamento().ordinal()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "CentrarVertical", this.isCentrarVertical()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Tipo", this.getTipo().ordinal()));
        me.appendChild(XMLGenerate.ValorColor(doc, "BackColor", this.getBackColor()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Sombra", this.isSombra()));
        me.appendChild(XMLGenerate.ValorColor(doc, "CorSombra", this.getCorSombra()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Gradiente", this.isGradiente()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteStartColor", this.getGradienteStartColor()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteEndColor", this.getGradienteEndColor()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "GradientePinteDetalhe", this.isGradientePinteDetalhe()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteCorDetalhe", this.getGradienteCorDetalhe()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "GDirecao", this.getGDirecao()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Alfa", (int)(100.0f * this.getAlfa())));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Autosize", this.isAutosize()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "MovimentacaoManual", this.isMovimentacaoManual()));
        NodeList nl = me.getElementsByTagName("Dicionario");
        if (nl != null && nl.getLength() > 0) {
            me.removeChild(nl.item(0));
        }
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        int l = XMLGenerate.getValorIntegerFrom(me, "GDirecao");
        if (l != -1) {
            this.setGDirecao(l);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Alfa")) != -1) {
            this.SetAlfa(l);
        }
        this.setTitulo(XMLGenerate.getValorTextoFrom(me, "Titulo"));
        this.setPaintTitulo(XMLGenerate.getValorBooleanFrom(me, "PaintTitulo"));
        this.setCentrarVertical(XMLGenerate.getValorBooleanFrom(me, "CentrarVertical"));
        this.setTipobyInt(XMLGenerate.getValorIntegerFrom(me, "Tipo"));
        this.setAlinhamentoByInt(XMLGenerate.getValorIntegerFrom(me, "Alinhamento"));
        Color c = XMLGenerate.getValorColorFrom(me, "BackColor");
        if (c != null) {
            this.setBackColor(c);
        }
        this.setSombra(XMLGenerate.getValorBooleanFrom(me, "Sombra"));
        c = XMLGenerate.getValorColorFrom(me, "CorSombra");
        if (c != null) {
            this.setCorSombra(c);
        }
        this.setGradiente(XMLGenerate.getValorBooleanFrom(me, "Gradiente"));
        this.setGradientePinteDetalhe(XMLGenerate.getValorBooleanFrom(me, "GradientePinteDetalhe"));
        c = XMLGenerate.getValorColorFrom(me, "GradienteStartColor");
        if (c != null) {
            this.setGradienteStartColor(c);
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "GradienteEndColor")) != null) {
            this.setGradienteEndColor(c);
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "GradienteCorDetalhe")) != null) {
            this.setGradienteCorDetalhe(c);
        }
        this.setMovimentacaoManual(XMLGenerate.getValorBooleanFrom(me, "MovimentacaoManual"));
        this.setAutosize(XMLGenerate.getValorBooleanFrom(me, "Autosize"));
        return true;
    }

    public boolean isMovimentacaoManual() {
        return this.MovimentacaoManual;
    }

    public void setMovimentacaoManual(boolean MovimentacaoManual) {
        if (this.MovimentacaoManual != MovimentacaoManual) {
            this.MovimentacaoManual = MovimentacaoManual;
            if (this.MovimentacaoManual || this.LinhaMestre == null || this.getMaster().IsMultSelecionado()) {
                return;
            }
            this.DirectPosicione();
            this.Reposicione();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.MovimentacaoManual = true;
    }

    public SuperLinha getLinhaMestre() {
        return this.LinhaMestre;
    }

    @Override
    public void SetLinhaMestre(SuperLinha LinhaMestre) {
        if (this.LinhaMestre == LinhaMestre) {
            return;
        }
        this.LinhaMestre = LinhaMestre;
        this.MovimentacaoManual = false;
    }

    public void setLinhaMestre(SuperLinha LinhaMestre) {
        if (this.LinhaMestre == LinhaMestre) {
            return;
        }
        if (this.LinhaMestre != null) {
            this.LinhaMestre.SetTag(null);
        }
        this.LinhaMestre = LinhaMestre;
        if (this.LinhaMestre != null) {
            this.LinhaMestre.SetTag(this);
        }
        this.MovimentacaoManual = false;
    }

    @Override
    public void Posicione() {
        if (this.isMovimentacaoManual() || this.LinhaMestre == null || this.isSelecionado()) {
            return;
        }
        this.DirectPosicione();
    }

    protected void DirectPosicione() {
        int qtdp = this.LinhaMestre.getPontos().size() % 2;
        int x = 0;
        int y = 0;
        if (qtdp == 1) {
            int a = this.LinhaMestre.getPontos().size() / 2;
            Point central = this.LinhaMestre.getPontos().get(a).getCentro();
            x = central.x;
            y = central.y;
        } else {
            int a = this.LinhaMestre.getPontos().size() / 2;
            Point ra = this.LinhaMestre.getPontos().get(a - 1).getCentro();
            Point rb = this.LinhaMestre.getPontos().get(this.LinhaMestre.getPontos().size() - a).getCentro();
            int tmp = ra.x - rb.x;
            x = tmp > -1 ? tmp / 2 + rb.x : (rb.x - ra.x) / 2 + ra.x;
            tmp = ra.y - rb.y;
            y = tmp > -1 ? tmp / 2 + rb.y : (rb.y - ra.y) / 2 + ra.y;
        }
        this.setLocation(x + 2, y + 2);
        this.Reenquadre();
    }

    public void SetLinhaMestreInt(int lin) {
        ArrayList<SuperLinha> lins = this.getListaDeLinhas();
        if (--lin >= 0 && lin < lins.size()) {
            this.setLinhaMestre(lins.get(lin));
            this.DirectPosicione();
            this.Reposicione();
        } else {
            this.setLinhaMestre(null);
        }
    }

    public ArrayList<SuperLinha> getListaDeLinhas() {
        ArrayList<SuperLinha> res = new ArrayList<SuperLinha>();
        for (FormaElementar fe : this.getMaster().getListaDeItens()) {
            if (!(fe instanceof SuperLinha)) continue;
            res.add((SuperLinha)fe);
        }
        return res;
    }

    public ArrayList<String> getStrListaDeLinhas(ArrayList<SuperLinha> lst) {
        ArrayList<String> res = new ArrayList<String>();
        for (SuperLinha fe : lst) {
            String pa = fe.getFormaPontaA() == null ? "<>" : fe.getFormaPontaA().getTexto();
            String pb = fe.getFormaPontaB() == null ? "<>" : fe.getFormaPontaB().getTexto();
            res.add(pa + " <--> " + pb);
        }
        return res;
    }

    @Override
    protected void ReSizedByAutoSize() {
        super.ReSizedByAutoSize();
        if (this.MovimentacaoManual || this.LinhaMestre == null || this.getMaster().IsMultSelecionado()) {
            return;
        }
        this.DirectPosicione();
        this.Reposicione();
    }
}

