/*
 * Decompiled with CFR 0.152.
 */
package controlador;

import controlador.BaseControlador;
import controlador.Diagrama;
import controlador.Editor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class QuadroDeEdicao
extends BaseControlador {
    public final int EditorMaxWidth = 4096;
    public final int EditorMaxHeigth = 4096;
    private transient Editor master;
    private int pontoWidth = 6;
    private int pontoHeigth = 6;
    private int editorAtualWidth = 4096;
    private int editorAtualHeigth = 4096;
    private int editorMargem = 50;
    private Color editorBackColor = Color.WHITE;
    public final String versao = "3.0.0";
    private double zoom = 1.0;
    private transient boolean mostrarAreaImpressao = false;
    transient int areaImpressaoWidth = 0;
    transient int areaImpressaoHeigth = 0;

    public Editor getEditor() {
        return this.master;
    }

    public int getPontoWidth() {
        return this.pontoWidth;
    }

    public void setPontoWidth(int pontoWidth) {
        this.pontoWidth = pontoWidth;
    }

    public int getPontoHeigth() {
        return this.pontoHeigth;
    }

    public void setPontoHeigth(int pontoHeigth) {
        this.pontoHeigth = pontoHeigth;
    }

    public int getEditorAtualWidth() {
        return (int)((double)this.editorAtualWidth * this.getZoom());
    }

    public void setEditorAtualWidth(int editorAtualWidth) {
        this.editorAtualWidth = editorAtualWidth;
    }

    public int getEditorAtualHeigth() {
        return (int)((double)this.editorAtualHeigth * this.getZoom());
    }

    public void setEditorAtualHeigth(int editorAtualHeigth) {
        this.editorAtualHeigth = editorAtualHeigth;
    }

    public int getEditorMargem() {
        return this.editorMargem;
    }

    public void setEditorMargem(int editorMargem) {
        this.editorMargem = editorMargem;
    }

    public final Color getEditorBackColor() {
        return this.editorBackColor;
    }

    public final void setEditorBackColor(Color editorBackColor) {
        this.editorBackColor = editorBackColor;
    }

    public boolean isMostrarAreaImpressao() {
        return this.mostrarAreaImpressao;
    }

    public void setMostrarAreaImpressao(boolean mostrarAreaImpressao, int wdt, int ht) {
        this.mostrarAreaImpressao = mostrarAreaImpressao;
        this.areaImpressaoWidth = wdt;
        this.areaImpressaoHeigth = ht;
        this.repaint();
    }

    public QuadroDeEdicao(Editor omaster) {
        this.master = omaster;
        this.setDoubleBuffered(true);
        this.setBackground(this.getEditorBackColor());
        this.setFont(new Font("Arial", 1, 12));
    }

    public void setMaster(Editor master) {
        this.master = master;
    }

    public Diagrama getDiagramaAtual() {
        if (this.master == null) {
            return null;
        }
        return this.master.diagramaAtual;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Graphics2D Canvas = (Graphics2D)g;
        Canvas.addRenderingHints(renderHints);
        Canvas.setStroke(new BasicStroke(1.0f, 1, 1));
        Canvas.setPaint(Color.BLACK);
        this.ProcessPaint(Canvas);
    }

    private void ProcessPaint(Graphics2D Canvas) {
        if (this.getDiagramaAtual() == null) {
            return;
        }
        this.getDiagramaAtual().ProcessPaint(Canvas);
    }

    @Override
    public void mouseClick(MouseEvent e) {
        if (this.getDiagramaAtual() == null) {
            return;
        }
        this.getDiagramaAtual().mouseClick(e);
    }

    @Override
    public void mouseDblClick(MouseEvent e) {
        super.mouseDblClick(e);
        if (this.getDiagramaAtual() == null) {
            return;
        }
        this.getDiagramaAtual().mouseDblClick(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.getDiagramaAtual() == null) {
            return;
        }
        this.getDiagramaAtual().mousePressed(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.getDiagramaAtual() == null) {
            return;
        }
        this.getDiagramaAtual().mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.getDiagramaAtual() == null) {
            return;
        }
        this.getDiagramaAtual().mouseExited(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (this.getDiagramaAtual() == null) {
            return;
        }
        this.getDiagramaAtual().mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (this.getDiagramaAtual() == null) {
            return;
        }
        this.getDiagramaAtual().mouseMoved(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.getDiagramaAtual() == null) {
            return;
        }
        this.getDiagramaAtual().mouseReleased(e);
        super.mouseReleased(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.getDiagramaAtual() == null) {
            return;
        }
        this.getDiagramaAtual().mouseWheelMoved(e);
        if (!e.isConsumed()) {
            this.master.ScrollMove(e);
        }
        super.mouseWheelMoved(e);
    }

    @Override
    public void repaint() {
        if (this.getDiagramaAtual() != null && this.getDiagramaAtual().isCarregando) {
            return;
        }
        super.repaint();
    }

    @Override
    public void repaint(Rectangle r) {
        if (this.getDiagramaAtual() != null && this.getDiagramaAtual().isCarregando) {
            return;
        }
        super.repaint(r);
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }
}

