/*
 * Decompiled with CFR 0.152.
 */
package controlador;

import controlador.Controler;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import util.BrLogger;

public class Configuer {
    private HashMap<String, String> configuracao = new HashMap();
    private ArrayList<String> lstDirecao = new ArrayList();
    private ArrayList<String> lstTipoTexto = new ArrayList();
    private ArrayList<String> lstTextoAlin = new ArrayList();
    private ArrayList<String> lstLegTipo = new ArrayList();
    private static ResourceBundle bundle = null;

    public Configuer() {
        this.LoadCfg();
    }

    public HashMap<String, String> getConfiguracao() {
        return this.configuracao;
    }

    public void setConfiguracao(HashMap<String, String> configuracao) {
        this.configuracao = configuracao;
    }

    private void LoadCfg() {
        String tmp = System.getProperty("user.dir") + File.separator + "config.chc";
        File f = new File(tmp);
        ResourceBundle resourceMap = Configuer.getResourceMap();
        for (String v : resourceMap.keySet()) {
            this.configuracao.put(v, resourceMap.getString(v));
        }
        if (!f.exists()) {
            this.SaveCfg();
        } else {
            try (FileInputStream cfgFile = new FileInputStream(tmp);){
                Properties prop = new Properties();
                prop.load(cfgFile);
                for (Object v : prop.keySet()) {
                    String vv = String.valueOf(v);
                    if (this.configuracao.containsKey(vv)) continue;
                    this.configuracao.put(vv, prop.getProperty(vv));
                }
            }
            catch (Exception e) {
                BrLogger.Logger("ERROR_LOAD_CFGFILE", e.getMessage());
                this.SaveCfg();
            }
        }
    }

    public String getValor(String key) {
        if (this.configuracao.containsKey(key) && this.configuracao.get(key) != null) {
            return this.configuracao.get(key);
        }
        return key;
    }

    public boolean hasValor(String key) {
        return this.configuracao.containsKey(key) && this.configuracao.get(key) != null && !"".equals(this.configuracao.get(key));
    }

    public void setValor(String key, String value) {
        this.configuracao.put(key, value);
        this.SaveCfg();
    }

    public boolean SetAndSaveIfNeed(String key, String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        if (this.configuracao.containsKey(key) && this.configuracao.get(key) != null && this.configuracao.get(key).equals(value)) {
            return false;
        }
        this.setValor(key, value);
        return true;
    }

    public void SaveCfg() {
        String tmp = System.getProperty("user.dir") + File.separator + "config.chc";
        try (FileOutputStream cfgFile = new FileOutputStream(tmp);){
            Properties prop = new Properties();
            for (String v : this.configuracao.keySet()) {
                if (v.startsWith("Inspector.") || v.startsWith("diagrama.") || v.startsWith("Linha.cmd.") || v.startsWith("Controler.")) continue;
                prop.setProperty(v, this.getValor(v));
            }
            prop.store(cfgFile, "Config");
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_SAVE_CFGFILE", e.getMessage());
        }
    }

    public ArrayList<String> getLstDirecao(Controler.Comandos cmd) {
        this.lstDirecao.clear();
        if (cmd == Controler.Comandos.cmdTexto || cmd == Controler.Comandos.cmdEapBarraLigacao) {
            this.lstDirecao.add(this.getValor("Inspector.lst.direcao.vertical"));
            this.lstDirecao.add(this.getValor("Inspector.lst.direcao.horizontal"));
            return this.lstDirecao;
        }
        if (cmd == Controler.Comandos.cmdAtributo) {
            this.lstDirecao.add(this.getValor("Inspector.lst.direcao.left"));
            this.lstDirecao.add(this.getValor("Inspector.lst.direcao.right"));
            return this.lstDirecao;
        }
        if (cmd == Controler.Comandos.cmdEspecializacao || cmd == Controler.Comandos.cmdUniao) {
            this.lstDirecao.add(this.getValor("Inspector.lst.direcao.up"));
            this.lstDirecao.add(this.getValor("Inspector.lst.direcao.right"));
            this.lstDirecao.add(this.getValor("Inspector.lst.direcao.down"));
            this.lstDirecao.add(this.getValor("Inspector.lst.direcao.left"));
        }
        return this.lstDirecao;
    }

    public List<String> getLstTipoTexto() {
        if (this.lstTipoTexto.isEmpty()) {
            this.lstTipoTexto.add(this.getValor("Inspector.lst.tipotexto.embranco"));
            this.lstTipoTexto.add(this.getValor("Inspector.lst.tipotexto.nota"));
            this.lstTipoTexto.add(this.getValor("Inspector.lst.tipotexto.retangulo"));
            this.lstTipoTexto.add(this.getValor("Inspector.lst.tipotexto.retanguloarred"));
        }
        return this.lstTipoTexto;
    }

    public List<String> getLstTextoAlin() {
        if (this.lstTextoAlin.isEmpty()) {
            this.lstTextoAlin.add(this.getValor("Inspector.lst.textoalin.centro"));
            this.lstTextoAlin.add(this.getValor("Inspector.lst.textoalin.esquerda"));
            this.lstTextoAlin.add(this.getValor("Inspector.lst.textoalin.direita"));
        }
        return this.lstTextoAlin;
    }

    public List<String> getLstTipoLegenda() {
        if (this.lstLegTipo.isEmpty()) {
            this.lstLegTipo.add(this.getValor("Inspector.lst.legenda.tpcores"));
            this.lstLegTipo.add(this.getValor("Inspector.lst.legenda.tplinhas"));
            this.lstLegTipo.add(this.getValor("Inspector.lst.legenda.tpobjetos"));
        }
        return this.lstLegTipo;
    }

    public static ResourceBundle getResourceMap() {
        if (bundle == null) {
            Locale ptBr = new Locale("pt", "BR");
            bundle = ResourceBundle.getBundle("principal/Propriedades", ptBr);
        }
        return bundle;
    }

    public static Image getImageFromResource(String keyImg) {
        String tmp = "/imagens/" + Configuer.getResourceMap().getString(keyImg);
        Image res = new ImageIcon(Configuer.class.getResource(tmp)).getImage();
        return res;
    }

    public static ImageIcon getImageIconFromResource(String keyImg) {
        String tmp = "/imagens/" + Configuer.getResourceMap().getString(keyImg);
        return new ImageIcon(Configuer.class.getResource(tmp));
    }

    public String getAutoSaveFile() {
        String tmp = System.getProperty("user.dir") + File.separator + "autosave.chc";
        return tmp;
    }
}

