#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QTimeLine>
#include <QtGui/QGraphicsItemAnimation>
#include <QtGui/QListWidgetItem>

#include "mycircle.h"
#include "circlememento.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    m_side(0)
{
    ui->setupUi(this);
    QGraphicsScene *scene = new QGraphicsScene;
    ui->graphicsView->setScene(scene);
    ui->graphicsView->setRenderHint(QPainter::Antialiasing);
    m_circle = new MyCircle(-25, -25, 50, 50);
    m_circle->setBrush(QBrush(Qt::red, Qt::SolidPattern));
    scene->addItem(m_circle);
    m_timer = new QTimeLine(1000);
    m_animation = new QGraphicsItemAnimation;
    m_animation->setItem((QGraphicsItem *) m_circle);
    m_animation->setTimeLine(m_timer);
    connect(m_timer, SIGNAL(finished()), SLOT(startTimer()));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::resizeEvent(QResizeEvent *event)
{
    ui->graphicsView->setSceneRect(-ui->graphicsView->width()/2-10, -ui->graphicsView->height()/2-10, ui->graphicsView->width()-10, ui->graphicsView->height()-10);
}

void MainWindow::on_psbStart_clicked()
{
    if (m_timer->state() != QTimeLine::Running)
    {
        startTimer();
    }
}

void MainWindow::on_psbStop_clicked()
{
    m_timer->stop();
}

void MainWindow::on_psbSnapshot_clicked()
{
    QListWidgetItem *item = new QListWidgetItem(QString("Memento %1").arg(ui->listWidget->count()));
    item->setData(Qt::UserRole, QVariant::fromValue(m_circle->createMemento()));
    ui->listWidget->addItem(item);
}

void MainWindow::on_listWidget_itemClicked(QListWidgetItem *item)
{
    CircleMemento *memento = item->data(Qt::UserRole).value<CircleMemento *>();
    m_circle->setMemento(memento);
}

void MainWindow::startTimer()
{
    m_animation->setPosAt(0, m_circle->pos());
    int tmp;
    while ((tmp = qrand() % 4) == m_side);
    m_side = tmp;
    int pos = 0;
    if (m_side == 0 || m_side == 2)
        pos = qrand() % ui->graphicsView->height()/2-25;
    else
        pos = qrand() % ui->graphicsView->width()/2-25;
    switch (m_side)
    {
    case 0: m_animation->setPosAt(1, QPointF(ui->graphicsView->width()/2-25, pos)); break;
    case 1: m_animation->setPosAt(1, QPointF(pos, ui->graphicsView->height()/2-25)); break;
    case 2: m_animation->setPosAt(1, QPointF(-ui->graphicsView->width()/2-25, pos)); break;
    case 3: m_animation->setPosAt(1, QPointF(pos, -ui->graphicsView->height()/2-25)); break;
    }

    m_timer->start();
}
