public class Projeto{
    private String nome;
    private Pessoa[] responsaveis;
    private Atividade[] atividades;
    
    public Projeto(String nome){
        this.nome = nome;
        this.atividades = new Atividade[0];
    } 
    
    public Atividade[] findAll(){
        return this.atividades;
    }    
    
    
    public int getDuracao(){
        CalculadoraDuracao cd = new CalculadoraDuracao(this.atividades);
        return cd.getDuracao();
    }    
   
    protected Atividade[] addAtividade(Atividade atividade, Atividade[] atividades){
        Atividade[] novo = new Atividade[atividades.length + 1];
        for(int i = 0; i < atividades.length; i++)
          novo[i] = atividades[i];
        novo[novo.length - 1] = atividade;
        return novo;
    };     
    
    public void addAtividade(Atividade atividade){
        this.atividades = this.addAtividade(atividade, this.atividades);
    };   
    
    public Atividade findById(String id){
        for(Atividade a : this.atividades)
          if(a.getId().equals(id))
            return a;
        return null;    
    }    
    
    public int getDuracao(String id){
        return this.findById(id).getDuracao();
    };      
    

}
