public class Macro extends Atividade{
    private Atividade[] atividades;
    
    
    public Macro(String id, String descricao){
        super(id, descricao);
        this.atividades = new Atividade[0];
    }    
    
    public boolean isConcluida(){
        for(Atividade atividade : this.atividades)
          if(!atividade.isConcluida())
            return false;
        return true;    
    };
    
    public void addAtividade(Atividade atividade){
        this.atividades = this.addAtividade(atividade, this.atividades);
    } 
    
    public int getDuracao(){
        int duracao = 0;
        for(Atividade a : this.getAtividadeTerminais())
          if(a.getTempoMelhorCaso() + a.getDuracao() > duracao)
            duracao = a.getTempoMelhorCaso() + a.getDuracao();
        return duracao;
    };     
    
    public Atividade[] getAtividadeTerminais(){
        Atividade[] terminais = new Atividade[0];
        for(Atividade a : this.atividades)
          if(a.isFinal())
            terminais = this.addAtividade(a, terminais);
        return terminais;
    }      
    

    
}
