public class Dicionario{
    private Verbete[] verbetes;
    
    public Dicionario(){
        this.verbetes = new Verbete[0];
    }  
    
    public void addVerbete(Verbete verbete){
        this.verbetes = this.adicionarVerbete(this.verbetes, verbete);
    }  
    
    private Verbete[] adicionarVerbete(Verbete[] velho, Verbete verbete){
        Verbete[] novo = new Verbete[velho.length + 1];
        for(int i = 0; i < velho.length; i++)
          novo[i] = velho[i];
        novo[novo.length - 1] = verbete;
        return novo;        
    }    
    
    
    public Verbete[] getVerbetes(String[] strings){
        Verbete[] verbetes = new Verbete[0];
        for(int i = 0; i < strings.length; i++){
          Verbete v = this.findByEntrada(strings[i]);
          if(v != null)
            verbetes = this.adicionarVerbete(verbetes, v);
        }  
        return verbetes;  
    }    
    
    public Verbete findByEntrada(String string){
        for(Verbete verbete : this.verbetes){
            if(verbete.isEntrada(string))
              return verbete;
        }          
        return null;
    }    
    
    
    private boolean possuiEquivalencia(Verbete[] verbetes, Verbete verbete){
        for(Verbete v : verbetes)
          if(v.isEquivalente(verbete))
            return true;
        return false;    
    } 
    
    private boolean possuiEquivalencia(Verbete[] fonte, Verbete[] destino){
        for(Verbete v : fonte)
          if(v.isPalavra() && !this.possuiEquivalencia(destino, v))
            return false;
        return true;    
    }  
    
    public boolean frasesEquivalentes(String[] frase1, String[] frase2){
        Verbete[] verbetesFrase1 = this.getVerbetes(frase1);
        Verbete[] verbetesFrase2 = this.getVerbetes(frase2); 
        
        return this.possuiEquivalencia(verbetesFrase1, verbetesFrase2) &&
               this.possuiEquivalencia(verbetesFrase2, verbetesFrase1);
        
    }    
    
    
}
