public class ImagemRGB{
    private CorRGB[][] pixels;
    
    public ImagemRGB(int altura, int largura){
        this.pixels = new CorRGB[altura][largura];
        for(int i = 0; i < this.pixels.length; i++)
         for(int j = 0; j < this.pixels[i].length; j++)
            this.setPixel(i, j, new CorRGB(255, 0, 0));  
    } 
    
    public int getAltura(){
        return this.pixels.length;
    }    
    
    public int getLargura(){
        return this.pixels[0].length;
    }    
    
    
    public CorRGB getPixel(int i, int j){
        return this.pixels[i][j];
    }    
    
    public void setPixel(int i, int j, CorRGB pixel){
        this.pixels[i][j] = pixel;
    }    
    
    public ImagemRGB toGrayScale(){
        ImagemRGB gray = new ImagemRGB(this.getAltura(), this.getLargura());
        for(int i = 0; i < this.pixels.length; i++)
         for(int j = 0; j < this.pixels[i].length; j++){
             int luminosidade = this.getPixel(i, j).getLuminosidade();
             gray.setPixel(i, j, 
                           new CorRGB(luminosidade, luminosidade, luminosidade));
         } 
        return gray; 
    }  
    
    
    private boolean corresponde(int x, int y, ImagemRGB imagem){
        for(int i = 0; i < imagem.getAltura(); i++)
            for(int j = 0; j < imagem.getLargura(); j++)
              if(!imagem.getPixel(i, j).equals(this.getPixel(i+x, j+y)))
                return false;
        return true;        
    }    
    
    public boolean contida(ImagemRGB imagem){
        for(int i = 0; i <= this.getAltura() - imagem.getAltura(); i++)
            for(int j = 0; j <= this.getLargura() - imagem.getLargura(); j++)
               if(this.corresponde(i, j, imagem))
                 return true;
        return false;         
    }    
    
    
    public String toString(){
        String rep = "";
        for(int i = 0; i < this.pixels.length; i++){
         for(int j = 0; j < this.pixels[i].length; j++)
           rep+= this.getPixel(i, j) + " ";
         rep+= "\n";  
        }
        return rep;
    }    
    
}
