public class Tabela{
    private String nome;
    private Coluna[] colunas;
    
    
    public Tabela(String nome){
        this.setNome(nome);
        this.colunas = new Coluna[0];
    };    
    
    private void setNome(String nome){
        this.nome = nome;
    };   
    
    public String getNome(){
        return this.nome;
    };     
    
    public void adicionarColuna(Coluna coluna){
        this.colunas = this.addColuna(this.colunas, coluna);
    };    
    
    public Coluna[] getChavesPrimarias(){
        Coluna[] chavesPrimarias = new Coluna[0];
        for(Coluna coluna : this.colunas)
          if(coluna.isChavePrimaria()) 
            chavesPrimarias = this.addColuna(chavesPrimarias, coluna);
        return chavesPrimarias;    
    };  
    
    private Coluna[] addColuna(Coluna[] colunas, Coluna coluna){
        Coluna[] novo = new Coluna[colunas.length + 1]; 
        for(int iCont = 0; iCont < colunas.length; iCont++)
          novo[iCont] = colunas[iCont];
        novo[novo.length - 1] =  coluna;
        return novo;
    }; 
    
    public boolean pertence(Coluna coluna){
        for(Coluna atual : this.colunas)
          if(atual.equals(coluna))
            return true;
        return false;    
    }    
    
    public Tabela merge(String nome, Tabela tabela){
        Tabela merge = new Tabela(nome);
        
        for(Coluna atual : this.colunas)
          if(!tabela.pertence(atual))
            merge.adicionarColuna(new Coluna(atual));
          else{
              Coluna coluna = tabela.getColuna(atual.getNome(), atual.getTipo());
              merge.adicionarColuna(new Coluna(atual.getNome(), atual.getTipo(), 
                                    !coluna.isNotNull() || !atual.isNotNull(), 
                                    coluna.isChavePrimaria() && atual.isChavePrimaria()));
          }    
            
        for(Coluna atual : tabela.colunas)
          if(!this.pertence(atual))
            merge.adicionarColuna(new Coluna(atual));
            
        return merge;    
            
    }
    
    
    public Coluna getColuna(String nome, TipoColuna tipo){
        for(Coluna atual : this.colunas)
          if(atual.getNome().equals(nome) && atual.getTipo() == tipo)
            return atual;
        return null;    
    }    
    
    public String toString(){
        Coluna[] pks = this.getChavesPrimarias();
        String rep = "CREATE TABLE " + this.getNome() + "(\n";
        
        for(int iCont = 0; iCont < this.colunas.length - 1; iCont++)
            rep += "\t" + this.colunas[iCont] + ",\n";
        
        rep +=  "\t" + this.colunas[this.colunas.length - 1] + "\n";  

        if(pks.length > 0){
            rep += "CONSTRAINT PRIMARY KEY(";
            for(int iCont = 0; iCont < pks.length - 1; iCont++)
              rep += pks[iCont].getNome() + ", ";
            
                rep +=  pks[pks.length - 1].getNome();           
            rep += ")\n";
        }    
        
        return rep + ")";  
        
        
    }    
    
    
    
    
    
}
