package br.edu.ifba.inf008.lock;

import java.util.HashSet;
import java.util.Set;

public class Consulta extends ElementoBD{
    private Set<Coluna> colunas;
    
    
    public Consulta(String objectId, String nome) {
		super(objectId, nome);
		this.colunas = new HashSet<Coluna>();
	}
    

    public void addColuna(Coluna coluna){
    	this.colunas.add(coluna);
    }
    
    
	public boolean podeBloquearLeitura(){
        for(Coluna coluna : this.colunas)
          if(coluna.getLock() == TipoLock.ESCRITA)
          return false;
        return true;  
        
   };       
    
    
    public boolean podeBloquearEscrita(){
        for(Coluna coluna : this.colunas)
          if(coluna.getLock() != TipoLock.LIVRE)
          return false;
        return true;  
    };       
     
    

    public void liberarLock(){
    };
    
    public  void bloquearLeitura(){
        for(Coluna coluna : this.colunas)
          coluna.bloquearLeitura();        
    };
    
    public  void bloquearEscrita(){
        for(Coluna coluna : this.colunas)
          coluna.bloquearEscrita();        
    };       
    
        
}
