package br.edu.ifba.inf008.lock;
public abstract class ElementoBD{
    private String objectId;
    private String nome;
    
    public ElementoBD(String objectId, String nome) {
		super();
		this.objectId = objectId;
		this.nome = nome;
	}

	public String getObjectId(){
        return this.objectId;
    }  
    
    public boolean podeLock(TipoLock lock){
        if(lock == TipoLock.LEITURA) 
            return podeBloquearLeitura(); 
        else if(lock == TipoLock.ESCRITA) 
            return podeBloquearEscrita(); 
        else if(lock == TipoLock.LIVRE) 
            return podeLiberarLock(); 
        return false;    
    };
    
    
    public void fazerLock(TipoLock lock){
        if(lock == TipoLock.LEITURA) bloquearLeitura(); 
        else if(lock == TipoLock.ESCRITA) bloquearEscrita(); 
        else if(lock == TipoLock.LIVRE) liberarLock(); 
    }    
    
    public abstract void liberarLock();
    public abstract void bloquearLeitura();    
    public abstract void bloquearEscrita(); 
    
    public boolean podeLiberarLock(){
        return true;
    };
    
    public abstract boolean podeBloquearLeitura();    
    public abstract boolean podeBloquearEscrita();

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((objectId == null) ? 0 : objectId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ElementoBD other = (ElementoBD) obj;
		if (objectId == null) {
			if (other.objectId != null)
				return false;
		} else if (!objectId.equals(other.objectId))
			return false;
		return true;
	}       
    
    
    
}