package br.edu.ifba.inf008.mediaCenter.session;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import br.edu.ifba.inf008.mediaCenter.model.Servidor;
import br.edu.ifba.inf008.mediaCenter.model.ServidorBasico;
import br.edu.ifba.inf008.mediaCenter.model.ServidorReplicado;
import br.edu.ifba.inf008.mediaCenter.persistencia.ServidorDAO;
import br.edu.ifba.inf008.mediaCenter.persistencia.ServidorDAOMem;
import br.edu.ifba.inf008.mediaCenter.persistencia.ServidorDAOSQL;

public class MediaCenter{
	
	public ServidorDAO servidorDAO;
    
    public MediaCenter() throws SQLException{
    	this.servidorDAO = new ServidorDAOSQL();
    }  
    
    public void init() throws Exception{
    	
        ServidorReplicado s1 = new ServidorReplicado("anubis");
        ServidorReplicado s11 = new ServidorReplicado("thot");        
        
        s11.addServidor(new ServidorBasico("osiris", 512, 0.25, 0.25));
        s11.addServidor(new ServidorBasico("isis", 256, 0.1, 0.1));        
        
        s1.addServidor(s11);
        s1.addServidor(new ServidorBasico("bast", 512, 0.05, 0.05));
        
        this.servidorDAO.save(new ServidorBasico("horus", 1024, 0.5, 0.8));
        this.servidorDAO.save(new ServidorBasico("ra", 1024, 0.4, 1.0));        
        this.servidorDAO.save(s1);        
    }

    public double getTempoArmazenamento(long tamanho) throws Exception{
        double tempo = 0;
        Collection<Servidor> servidores = this.servidorDAO.findAll();	
        Servidor destino = null;  
	    for(Servidor s : servidores)
	      if(s.temCapacidade(tamanho) && 
	        ((destino== null)|| (destino != null && destino.getLatenciaEscrita() > s.getLatenciaEscrita())))
	          destino = s;
	      tempo += destino.gravar(tamanho); 
        return tempo;
    }  
    
    public void addServidor(Servidor servidor) throws Exception{
    	this.servidorDAO.save(servidor);
    }  
    
    public String toString(){
        String str = "Servidores\n";
        Collection<Servidor> servidores;
		try {
			servidores = this.servidorDAO.findAll();
	        for(Servidor s : servidores)
	            str += s.toString() + "\n";
		} catch (Exception e) {
			e.printStackTrace();
		}	
        return str + "\n"; 
        
    }    
    
}
