public class PixelRGB extends Pixel {
    
    public static final PixelRGB RED = new PixelRGB((short)255, (short)0, (short)0);
    public static final PixelRGB GREEN = new PixelRGB((short)0, (short)255, (short)0);    
    public static final PixelRGB BLUE = new PixelRGB((short)0, (short)0, (short)255);
    public static final PixelRGB WHITE = new PixelRGB((short)255, (short)255, (short)255);    
    public static final PixelRGB BLACK = new PixelRGB((short)255, (short)255, (short)255);        
    
    
    private short red;
    private short green;    
    private short blue; 
    
    public PixelRGB(short red, short green, short blue){
        this.red = red;
        this.green = green;
        this.blue = blue;
    }    
    
    public short getLuminosidade(){
          return (short)((this.red * 0.3 + this.green * 0.59 +
               this.blue * 0.11));
    }  
    
    public String toString(){
        return "< r=" + this.red + ", g=" + this.green + ", b=" 
                      + this.blue + ">";
    }    
}
