public class SistemaMilitar{
    
    private Atlas atlas;
    
    public SistemaMilitar(){
        this.atlas = new Atlas();
    }    
    
    public void init(){
        PixelRGB[][] pixelsW = {{PixelRGB.WHITE, PixelRGB.WHITE, PixelRGB.WHITE},
                               {PixelRGB.WHITE, PixelRGB.WHITE, PixelRGB.WHITE},
                               {PixelRGB.WHITE, PixelRGB.WHITE, PixelRGB.WHITE}};
        PixelRGB[][] pixelsB = {{PixelRGB.BLACK, PixelRGB.BLACK, PixelRGB.BLACK},
                                {PixelRGB.BLACK, PixelRGB.BLACK, PixelRGB.BLACK},
                                {PixelRGB.BLACK, PixelRGB.BLACK, PixelRGB.BLACK}};
        PixelRGB[][] pixelsBW = {{PixelRGB.WHITE, PixelRGB.BLACK, PixelRGB.WHITE},
                               {PixelRGB.BLACK, PixelRGB.WHITE, PixelRGB.BLACK},
                               {PixelRGB.WHITE, PixelRGB.BLACK, PixelRGB.WHITE}};
        PixelRGB[][] pixelsIT = {{PixelRGB.RED, PixelRGB.WHITE, PixelRGB.GREEN},
                                {PixelRGB.RED, PixelRGB.WHITE, PixelRGB.GREEN},
                                {PixelRGB.RED, PixelRGB.WHITE, PixelRGB.GREEN}};

        PixelCMYK[][] pixelsWB = {{PixelCMYK.BLACK, PixelCMYK.WHITE, PixelCMYK.BLACK},
                                  {PixelCMYK.WHITE, PixelCMYK.BLACK, PixelCMYK.WHITE},
                                  {PixelCMYK.BLACK, PixelCMYK.WHITE, PixelCMYK.BLACK}};
        PixelCMYK[][] pixelsES = {{PixelCMYK.CIANO, PixelCMYK.WHITE, PixelCMYK.PINK},
                                {PixelCMYK.CIANO, PixelCMYK.WHITE, PixelCMYK.PINK},
                                {PixelCMYK.CIANO, PixelCMYK.WHITE, PixelCMYK.PINK}};
                                
                                
        this.atlas.addMapa(new MapaRGB("Branco RGB", pixelsW));
        this.atlas.addMapa(new MapaRGB("Preto RGB", pixelsB));
        this.atlas.addMapa(new MapaRGB("Xadrez RGB", pixelsBW));        
        this.atlas.addMapa(new MapaRGB("Italia RGB", pixelsIT));        
        this.atlas.addMapa(new MapaCMYK("Xadrez CMYK", pixelsWB));        
        this.atlas.addMapa(new MapaCMYK("ES CMYK", pixelsES));        
        
    }
    
    public void run(){
//        Pixel[][] pixels = {{PixelRGB.RED, PixelCMYK.WHITE, PixelCMYK.GREEN},
//                            {PixelRGB.RED, PixelRGB.WHITE, PixelCMYK.GREEN}};
//        Pixel[][] pixels = {{PixelRGB.BLACK, PixelRGB.WHITE, PixelRGB.BLACK},
//                            {PixelRGB.BLACK, PixelRGB.WHITE, PixelRGB.BLACK}};
        Pixel[][] pixels = {{PixelRGB.WHITE, PixelRGB.WHITE, PixelRGB.WHITE},
                            {PixelRGB.WHITE, PixelRGB.WHITE, PixelRGB.WHITE}};

        Fragmento fragmento = new Fragmento(pixels);                    
        System.out.println(this.atlas.getMapaMaisSimilar(fragmento));                                   
    }    
    
    public static void main(String[] args){
        SistemaMilitar sm = new  SistemaMilitar();
        sm.init();
        sm.run();
    }    
        
    
}
