public class ImagemRGB{
    private CorRGB[][] pixels;
    
    public ImagemRGB(int altura, int largura){
        
        this.pixels = new CorRGB[altura][largura];
        
        for(int i = 0; i < this.pixels.length; i++)
            for(int j = 0; j < this.pixels[i].length; j++)
              this.pixels[i][j] = CorRGB.COR_BRANCA; 
              //this.pixels[i][j] = new CorRGB((short)255, (short)255, (short)255);
    }    
    
    public void setPixel(int x, int y, CorRGB cor){
        this.pixels[x][y] = cor;
    }    
    
    public void fillRect(int x, int y, int largura, int altura, CorRGB cor){
        for(int i = x; i < largura + x && i < this.pixels.length ; i++)
            for(int j = y; j < altura + y && j < this.pixels[i].length; j++)
                this.setPixel(i, j, cor);
    }  
    
    public int getAltura(){
        return this.pixels[0].length;
    }    
    
    public int getLargura(){
        return this.pixels.length;
    }    
    
    public CorRGB getPixel(int x, int y){
        return this.pixels[x][y];
    }    
    
    
    public ImagemRGB toGrayscale(){
        ImagemRGB gray = new ImagemRGB(this.getLargura(), this.getAltura());
        for(int i = 0; i < this.pixels.length; i++)
            for(int j = 0; j < this.pixels[i].length; j++){
                short tomCinza = (short) this.getPixel(i, j).getLuminosidade();
                gray.setPixel(i, j, new CorRGB(tomCinza, tomCinza, tomCinza));
            }    
        return gray;    
    }  


    public boolean in(ImagemRGB imagem){
        for(int i = 0; i < this.getLargura(); i++)
            for(int j = 0; j < this.getAltura(); j++)
              if(this.in(imagem, i, j))
                return true;
        return false;        
    }    
    
    
    public boolean in(ImagemRGB imagem, int i, int j){
        if(!(imagem.getLargura() <= this.getLargura() - i && 
             imagem.getAltura() <= this.getAltura() - j))
             return false;
                         
        for(int xIm = 0, xMe = i; 
            xIm < imagem.getLargura();
            xIm++, xMe++)
                for(int yIm = 0, yMe = j; 
                   yIm < imagem.getAltura();
                   yIm++, yMe++)
                     if(!imagem.getPixel(xIm, yIm)
                               .equals(this.getPixel(xMe, yMe)))
                         return false;
        return true;                 
    }    
    
    public String toString(){
        String str = "";
        for(int i = 0; i < this.pixels.length; i++){
            for(int j = 0; j < this.pixels[i].length; j++)
                str += this.pixels[i][j] + " ";
            str += "\n";    
        }        
        return str;
    }    
    
    
}
