/*
 * Na abstração desenvolvida, o átomo de um elemento químico possui 
 * um número atômico, 
 * um número de massa, 
 * o nome do elemento químico 
 * 
 */


public class Atomo{
    
    public static boolean REPRESENTACAO_ESTENDIDA;
    
    public static final int K = 0;
    public static final int L = 1;    
    public static final int M = 2;
    public static final int N = 3;    
    public static final int O = 4;    
    public static final int P = 5;
    public static final int Q = 6;    
    
    
    private String simbolo;
    private int numeroAtomico;
    private int numeroMassa;
    private String nome;
    private int[] qtdeEletrons;
    
    public Atomo(String simbolo, int numeroAtomico, int numeroMassa, String nome){
        this.setSimbolo(simbolo);
        this.setNumeroAtomico(numeroAtomico);
        this.setNumeroMassa(numeroMassa);
        this.setNome(nome);
        this.qtdeEletrons = new int[7];
    }  
    
    public Atomo(){
        this("H", 1, 2, "Hidrogênio");
    }    
    
    private void setSimbolo(String simbolo){
        this.simbolo = simbolo;
    }    
    
    private void setNumeroAtomico(int numeroAtomico){
        if(numeroAtomico > 0)
            this.numeroAtomico = numeroAtomico;
    }    
    
    private void setNumeroMassa(int numeroMassa){
        if(numeroMassa > 0)
            this.numeroMassa = numeroMassa;
    }    

    private void setNome(String nome){
        this.nome = nome;
    }
    
    public void setQtdeEletrons(int numCamada, int qtdeEletrons){
        this.qtdeEletrons[numCamada] = qtdeEletrons; 
    }   
    
    public void setQtdeEletrons(Camadas camada, int qtdeEletrons){
        this.setQtdeEletrons(camada.valor(), qtdeEletrons);
    }    
    
    public void setQtdeEletrons(int[] qtdeEletrons){
        this.qtdeEletrons = qtdeEletrons; 
    } 
    
    public int getQtdeEletrons(int numCamada){
        return this.qtdeEletrons[numCamada]; 
    }     
    
    
    public int getNumeroAtomico(){
        return this.numeroAtomico;
    } 
    
    private String getNome(){
        return this.nome;
    }
    
    private String getSimbolo(){
        return this.simbolo;
    }     
    

    
/*    public static void estenderRepresentacao(){
        Atomo.representacaoEstendida = true;
    }    
    
    public static void encurtarRepresentacao(){
        Atomo.representacaoEstendida = false;
    }    
*/    
    
    private String repEstendida(){
        String ret = this.getNome() + " [";
        
        for(int eletrons : this.qtdeEletrons)
          ret = ret + eletrons + " ";
        return ret += "]";  
    }    

    public String toString(){
        if(Atomo.REPRESENTACAO_ESTENDIDA) 
            return this.repEstendida();        
        else    
            return this.getSimbolo();
    }  
    
    public boolean equals(Atomo atomo){
       return this.getNumeroAtomico() == atomo.getNumeroAtomico();
    }     
    
    
}
