public class Molecula{
    private Atomo[] atomos;
    
    public Molecula(int tamanho){
        this.atomos = new Atomo[tamanho];
    }    
    
    public void setAtomo(int posicao, Atomo atomo){
        this.atomos[posicao] = atomo;
    }    
    
    public Atomo getMenorNumeroAtomico(){
        Atomo menor = this.atomos[0];
        for(Atomo atual : this.atomos)
          if(menor.getNumeroAtomico() > atual.getNumeroAtomico())
            menor = atual;
        return menor;    
    } 
    
    public int getQuantidade(Atomo atomo){
        int qtdAtomos = 0;
        
        for(Atomo atual : this.atomos)
          if(atomo.equals(atual))
            qtdAtomos++;
            
        return qtdAtomos;    
    }   
    
    public boolean contem(Atomo atomo){
       return  this.getQuantidade(atomo) > 0;
    }    
    
    public boolean contemTodos(Molecula molecula){
        for(Atomo atual : molecula.atomos)
          if(!this.contem(atual))
            return false;
        return true;    
    }  
    
    public boolean mesmosAtomos(Molecula molecula){
        return this.contemTodos(molecula) && molecula.contemTodos(this);
    }    
    
}
