public class LampadaComDimmer{
    private int valor;
    
    public LampadaComDimmer(int valor){
        this.setValor(valor);
    }  
    
    public LampadaComDimmer(LampadaComDimmer lampada){
        this(lampada.getValor());
    }     

    public LampadaComDimmer(){
        this(100);
    }       
    
    public void apagar(){
        this.setValor(0);
    }    
    
    public void acender(){
        this.setValor(100);
    }    
    
    public void incrementar(){
        this.incrementar(1);
    }  
    
    public void incrementar(int valor){
        this.setValor(this.getValor() + valor);
    }       

    public void decrementar(){
        this.decrementar(1);    
    }  
    
    public void decrementar(int valor){
        this.setValor(this.getValor() - valor); 
    }     

    public boolean estaAceso(){
        return (this.getValor() == 100);
    } 
    
    private int getValor(){
        return this.valor; 
    }   
    
    private void setValor(int valor){
        if(valor > 100)
          this.valor = 100;
        else if(valor < 0) 
          this.valor = 0;
        else  
          this.valor = valor;
    }    
    
    public boolean ehMaisBrilhante(LampadaComDimmer outra){
        return this.getValor() > outra.getValor();
    }    
    
    
}    