public abstract class Mapa{
    
    public abstract Pixel[][] getPixels();
    
    public Pixel getPixel(int x, int y){
        return this.getPixels()[x][y];
    };
    
    public abstract void setPixel(int x, int y, Pixel pixel);
    
    
    public int getLargura(){
        return this.getPixels().length;
    }    
    
    public int getAltura(){
        return this.getPixels().length;
    }  
    
    public double getSimilaridade(Fragmento f){
        double similaridade = 0;
        for(int x = 0; x <= this.getLargura() - f.getLargura(); x++)
            for(int y = 0; y <= this.getAltura() - f.getAltura(); y++){ 
              double novaSimilaridade = this.getSimilaridade(x, y, f);  
              if(similaridade < novaSimilaridade)
                similaridade = novaSimilaridade;  
            }  
        return similaridade;
    }  
    
    private double getSimilaridade(int x, int y, Fragmento f){
        double similaridade = 0;
        for(int i = 0; i < f.getLargura(); i++)
          for(int j = 0; j < f.getAltura(); j++)
            similaridade += this.getPixel(x+i, y+j).distancia(f.getPixel(i,j)); 
        return  similaridade / f.getTamanho();   
    }    
    
    
}
