package br.edu.ifba.inf008.contabil.ui;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import br.edu.ifba.inf008.contabil.dao.ContaDAOIF;
import br.edu.ifba.inf008.contabil.dao.LancamentoDAOIF;
import br.edu.ifba.inf008.contabil.dao.sql.ContaDAOSQL;
import br.edu.ifba.inf008.contabil.dao.sql.LancamentoDAOSQL;
import br.edu.ifba.inf008.contabil.session.AppContabil;

import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

import java.awt.GridBagConstraints;
import javax.swing.JTextField;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

public class JContabilFrame extends JFrame implements ActionListener {

	private JPanel contentPane;
	private JTextField txtTimeStamp;
	private JTextField txtDescricao;
	private JTextField txtValor;
	private JTextField txtDebito;
	private JTextField txtCredito;
	
	private AppContabilIF logica;
	

	
	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					JContabilFrame frame = new JContabilFrame();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public JContabilFrame() {
		
		this.init();
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 580, 427);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		GridBagLayout gbl_contentPane = new GridBagLayout();
		gbl_contentPane.columnWidths = new int[]{0, 0, 0, 0, 0};
		gbl_contentPane.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
		gbl_contentPane.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
		gbl_contentPane.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
		contentPane.setLayout(gbl_contentPane);
		
		JLabel lblTs = new JLabel("TS:");
		GridBagConstraints gbc_lblTs = new GridBagConstraints();
		gbc_lblTs.insets = new Insets(0, 0, 5, 5);
		gbc_lblTs.gridx = 0;
		gbc_lblTs.gridy = 0;
		contentPane.add(lblTs, gbc_lblTs);
		
		txtTimeStamp = new JTextField();
		GridBagConstraints gbc_txtTimeStamp = new GridBagConstraints();
		gbc_txtTimeStamp.insets = new Insets(0, 0, 5, 0);
		gbc_txtTimeStamp.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtTimeStamp.gridx = 3;
		gbc_txtTimeStamp.gridy = 0;
		contentPane.add(txtTimeStamp, gbc_txtTimeStamp);
		txtTimeStamp.setColumns(10);
		
		JLabel lblDescrio = new JLabel("Descri\u00E7\u00E3o:");
		GridBagConstraints gbc_lblDescrio = new GridBagConstraints();
		gbc_lblDescrio.insets = new Insets(0, 0, 5, 5);
		gbc_lblDescrio.gridx = 0;
		gbc_lblDescrio.gridy = 1;
		contentPane.add(lblDescrio, gbc_lblDescrio);
		
		txtDescricao = new JTextField();
		GridBagConstraints gbc_txtDescricao = new GridBagConstraints();
		gbc_txtDescricao.insets = new Insets(0, 0, 5, 0);
		gbc_txtDescricao.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtDescricao.gridx = 3;
		gbc_txtDescricao.gridy = 1;
		contentPane.add(txtDescricao, gbc_txtDescricao);
		txtDescricao.setColumns(10);
		
		JLabel lblValor = new JLabel("Valor");
		GridBagConstraints gbc_lblValor = new GridBagConstraints();
		gbc_lblValor.insets = new Insets(0, 0, 5, 5);
		gbc_lblValor.gridx = 0;
		gbc_lblValor.gridy = 2;
		contentPane.add(lblValor, gbc_lblValor);
		
		txtValor = new JTextField();
		GridBagConstraints gbc_txtValor = new GridBagConstraints();
		gbc_txtValor.insets = new Insets(0, 0, 5, 0);
		gbc_txtValor.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtValor.gridx = 3;
		gbc_txtValor.gridy = 2;
		contentPane.add(txtValor, gbc_txtValor);
		txtValor.setColumns(10);
		
		JLabel lblDebito = new JLabel("Debito:");
		GridBagConstraints gbc_lblDebito = new GridBagConstraints();
		gbc_lblDebito.insets = new Insets(0, 0, 5, 5);
		gbc_lblDebito.gridx = 0;
		gbc_lblDebito.gridy = 3;
		contentPane.add(lblDebito, gbc_lblDebito);
		
		txtDebito = new JTextField();
		GridBagConstraints gbc_txtDebito = new GridBagConstraints();
		gbc_txtDebito.insets = new Insets(0, 0, 5, 0);
		gbc_txtDebito.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtDebito.gridx = 3;
		gbc_txtDebito.gridy = 3;
		contentPane.add(txtDebito, gbc_txtDebito);
		txtDebito.setColumns(10);
		
		JLabel lblCrdito = new JLabel("Cr\u00E9dito");
		GridBagConstraints gbc_lblCrdito = new GridBagConstraints();
		gbc_lblCrdito.insets = new Insets(0, 0, 5, 5);
		gbc_lblCrdito.gridx = 0;
		gbc_lblCrdito.gridy = 4;
		contentPane.add(lblCrdito, gbc_lblCrdito);
		
		txtCredito = new JTextField();
		GridBagConstraints gbc_txtCredito = new GridBagConstraints();
		gbc_txtCredito.insets = new Insets(0, 0, 5, 0);
		gbc_txtCredito.fill = GridBagConstraints.HORIZONTAL;
		gbc_txtCredito.gridx = 3;
		gbc_txtCredito.gridy = 4;
		contentPane.add(txtCredito, gbc_txtCredito);
		txtCredito.setColumns(10);
		
		JButton btnLanar = new JButton("Lan\u00E7ar");
		GridBagConstraints gbc_btnLanar = new GridBagConstraints();
		gbc_btnLanar.gridx = 3;
		gbc_btnLanar.gridy = 6;
		
		btnLanar.addActionListener(this);
		
		contentPane.add(btnLanar, gbc_btnLanar);
	}
	
	private void init(){
		ContaDAOIF contaDAO = new ContaDAOSQL();
		LancamentoDAOIF lancamentoDAO = new LancamentoDAOSQL(contaDAO);
		this.logica = new AppContabil();
		this.logica.init(contaDAO, lancamentoDAO);
	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		long ts;
		try{
			ts = Long.parseLong(this.txtTimeStamp.getText());
			String descricao = this.txtDescricao.getText();
			double valor = Double.parseDouble(this.txtValor.getText());
			String debito = this.txtDebito.getText();
			String credito = this.txtCredito.getText();
			
			System.out.println(credito + "-" + debito);
			
			try {
				this.logica.registrarFatoContabil(ts, descricao, credito, debito, valor);
				JOptionPane.showMessageDialog(this, "Fato Lanado");
			}catch (Exception e) {
				JOptionPane.showMessageDialog(this,
					    "No foi possivel registrar o fato: " + e,
					    "Erro no Lancamento",
					    JOptionPane.ERROR_MESSAGE);
			}
		}catch(java.lang.NumberFormatException e){
			JOptionPane.showMessageDialog(this,
				    "O Campo TS precisa ser numerico: ",
				    "Erro no Lancamento",
				    JOptionPane.ERROR_MESSAGE);
		}
	}

}
