package br.edu.ifba.inf008.contabil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import br.edu.ifba.inf008.contabil.dao.ContaDAOIF;
import br.edu.ifba.inf008.contabil.dao.LancamentoDAOIF;
import br.edu.ifba.inf008.contabil.dao.mem.ContaDAOMemory;
import br.edu.ifba.inf008.contabil.dao.mem.LancamentoDAOMemory;
import br.edu.ifba.inf008.contabil.dao.sql.ContaDAOSQL;
import br.edu.ifba.inf008.contabil.dao.sql.LancamentoDAOSQL;
import br.edu.ifba.inf008.contabil.model.Ativo;
import br.edu.ifba.inf008.contabil.model.Conta;
import br.edu.ifba.inf008.contabil.model.Lancamento;
import br.edu.ifba.inf008.contabil.model.Passivo;
import br.edu.ifba.inf008.contabil.model.PatrimonioLiquido;
import br.edu.ifba.inf008.contabil.model.RegistroContabil;
import br.edu.ifba.inf008.contabil.session.AppContabil;
import br.edu.ifba.inf008.contabil.ui.JContabilUI;

public class App{
    
/*    public void run(){
        RegistroContabil registro = new RegistroContabil("NOME", "0000");
        registro.registrarNovaConta(RegistroContabil.ATIVO, "1.0", "CAIXA");
        registro.registrarNovaConta(RegistroContabil.PASSIVO, "2.0", "EMPRESTIMO");
        registro.registrarNovaConta(RegistroContabil.PATRIMONIO_LIQUIDO, "3.0", "CAPITAL");
        registro.registrarNovaConta(RegistroContabil.ATIVO, "1.1", "IMOVEIS");
        registro.registrarNovaConta(RegistroContabil.PASSIVO, "2.1", "IMPOSTOS A PAGAR");        

        registro.registrarFatoContabil(0, "Integralizacao de Capital", "CAPITAL", "CAIXA", 1000);
        registro.registrarFatoContabil(1, "Emprestimo no Banco de Desenvolvimento do NE", "EMPRESTIMO", "CAIXA", 5000);        
        registro.registrarFatoContabil(2, "Compra de Sede na Rua XXX", "CAIXA", "IMOVEIS", 2000);
        registro.registrarFatoContabil(3, "Integralizacao de capital - Aumento", "CAPITAL", "EMPRESTIMO", 4000);        
        registro.registrarFatoContabil(4, "Recolhimento de Impostos",   "IMPOSTOS A PAGAR", "CAIXA", 500);                
        registro.registrarFatoContabil(5, "dummy", "CAIXA", "XYZ", 2000);        
        
        System.out.println(registro);
        
    }
    
    public void run2(){
    	
    	Conta caixa = new Ativo("1.0", "CAIXA");
    	
    	Set<Conta> contas = new HashSet<Conta>();
//    	Collection contas = new ArrayList();

    	contas.add(new Ativo("1.0", "CAIXA"));
    	contas.add(new Passivo("2.0", "EMPRESTIMO"));    	
    	contas.add(new PatrimonioLiquido("3.0", "CAPITAL"));
    	contas.add(new Ativo("1.1", "IMOVEIS"));
    	contas.add(new Passivo("2.1", "IMPOSTOS A PAGAR"));
    	contas.add(caixa);
    	
//    	contas.remove(1);
    	
//    	contas.add(new Lancamento(0, "NADA", caixa, caixa, 0));
    	
 //   	Iterator<Conta> it = contas.iterator();
    	
    	for(Conta c : contas)
    		System.out.println(c);
    	
    	System.out.println(contas.size());
        
    }
    
    public void run3(){
    	Map<String, Conta> dict = new HashMap<String, Conta>();

    	Conta conta;
    	
    	conta = new Ativo("1.0", "CAIXA");
    	dict.put(conta.getId(), conta);
    	conta = new Passivo("2.0", "EMPRESTIMO");
    	dict.put(conta.getId(), conta);
    	conta = new PatrimonioLiquido("3.0", "CAPITAL");
    	dict.put(conta.getId(), conta);
    	conta = new Ativo("1.1", "IMOVEIS");
    	dict.put(conta.getId(), conta);
    	conta = new Passivo("2.1", "IMPOSTOS A PAGAR");
    	dict.put(conta.getId(), conta);
 	
    	
    	System.out.println(dict.get("2.0"));
    	
    	
    }
*/

	
	private void run4() throws Exception {
		ContaDAOIF contaDAO = new ContaDAOSQL();
		LancamentoDAOIF lancamentoDAO = new LancamentoDAOSQL(contaDAO);
		AppContabil logica = new AppContabil();
		
		logica.init(contaDAO, lancamentoDAO);
		List<Conta> contas = logica.buscarBalanco();
		
		for(Conta c : contas)
			System.out.println(c);
		
	}		
	
	private void run3() throws Exception {
		ContaDAOIF contaDAO = new ContaDAOSQL();
		LancamentoDAOIF lancamentoDAO = new LancamentoDAOSQL(contaDAO);
		AppContabil logica = new AppContabil();
		
		logica.init(contaDAO, lancamentoDAO);
		List<Lancamento> lancamentos = logica.buscarLivro();
		
		for(Lancamento l : lancamentos)
			System.out.println(l);
		
	}		
	
	
	private void run2() throws Exception {
		ContaDAOIF contaDAO = new ContaDAOSQL();
		LancamentoDAOIF lancamentoDAO = new LancamentoDAOSQL(contaDAO);
		AppContabil logica = new AppContabil();
		
		logica.init(contaDAO, lancamentoDAO);
		logica.registrarConta(1, "150", "VEICULOS");
	}	
	
	
	private void run() throws Exception {
		ContaDAOIF contaDAO = new ContaDAOSQL();
		LancamentoDAOIF lancamentoDAO = new LancamentoDAOSQL(contaDAO);
		AppContabil logica = new AppContabil();
		
		logica.init(contaDAO, lancamentoDAO);
		logica.registrarFatoContabil(0, "Integralizacao de Capital", "CAPITAL", "CAIXA", 1000);
	}	
    
	private void run5() throws Exception{
		JContabilUI frame = new JContabilUI();
		frame.setVisible(true);
	}
	
    public static void main(String[] args) throws Exception {
		(new App()).run5();
		System.out.println("RODOU!");
	}


    
    
}
