package br.edu.ifba.inf008.contabil.ui;

import java.util.List;

import br.edu.ifba.inf008.contabil.dao.ContaDAOIF;
import br.edu.ifba.inf008.contabil.dao.LancamentoDAOIF;
import br.edu.ifba.inf008.contabil.model.Conta;
import br.edu.ifba.inf008.contabil.model.Lancamento;

public interface AppContabilIF {
	
	public void init(ContaDAOIF contaDAO, LancamentoDAOIF lancamentoDAO);
	
	public void registrarConta(int tipo, String id, String nome) throws Exception;
	
	public List<Conta> buscarBalanco() throws Exception;
	
	public List<Lancamento> buscarLivro() throws Exception;
	
	public void registrarFatoContabil(long timestamp,
            String descricao, 
            String nomeContaCredito, 
            String nomeContaDebito, 
            double valor) throws Exception;

}
