package br.edu.ifba.inf008.contabil.model;

import br.edu.inf008.contabil.exceptions.SaldoInsuficienteException;

public class Ativo extends Conta{
    
    public Ativo(String id, String nome){
        super(id, nome);
    }
    
    public void creditar(double valor) throws SaldoInsuficienteException{
      if(!canDo(valor))	
    	  throw new SaldoInsuficienteException(this.getNome(), this.valor(), valor);
      this.saldo -= valor;
    }    
    
    public void debitar(double valor){
      this.saldo += valor;
    }
    
    public String tipo(){
        return "A";
    }    
    
}
