package br.edu.ifba.inf008.contabil.model;
import br.edu.ifba.inf008.contabil.util.Ordenavel;

public class Lancamento implements Comparable<Lancamento>{
    
    private long timestamp;
    private String descricao;
    private double valor;
    private Conta debito;
    private Conta credito;
    
    public Lancamento(long timestamp, 
                      String descricao, 
                      Conta credito,
                      Conta debito,
                      double valor){
      this.setTimeStamp(timestamp);                          
      this.setDescricao(descricao);
      this.setCredito(credito);
      this.setDebito(debito);
      this.setValor(valor);
    } 

    private void setTimeStamp(long timestamp){
        this.timestamp = timestamp;
    }
    
    
    private void setDescricao(String descricao){
        this.descricao = descricao;
    }

    private void setCredito(Conta credito){
        this.credito = credito;
    }    
    
    private void setDebito(Conta debito){
        this.debito = debito;
    }    
    
    private void setValor(double valor){
        this.valor = valor;
    } 
    
    public String toString(){
        return "[" + this.timestamp + "]" + 
               "Descricao: " + this.descricao + "\n" + 
               "Valor: " + this.valor + "\n" +
               "Credito: " + this.credito.getNome() + "\n" +
               "Debito: " + this.debito.getNome() + "\n";               
    } 
    

	public long getTimestamp() {
		return timestamp;
	}

	public String getDescricao() {
		return descricao;
	}

	public double getValor() {
		return valor;
	}

	public Conta getDebito() {
		return debito;
	}

	public Conta getCredito() {
		return credito;
	}

	@Override
	public int compareTo(Lancamento arg0) {
      return (int)(this.timestamp - arg0.timestamp);
	}  
    
    
    
}
