package br.edu.ifba.inf008.contabil.dao.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import br.edu.ifba.inf008.contabil.dao.ContaDAOIF;
import br.edu.ifba.inf008.contabil.model.Ativo;
import br.edu.ifba.inf008.contabil.model.Conta;
import br.edu.ifba.inf008.contabil.model.Passivo;
import br.edu.ifba.inf008.contabil.model.PatrimonioLiquido;
import br.edu.inf008.contabil.exceptions.ContaNaoExistenteException;

public class ContaDAOSQL extends AbstractDAOSQL implements ContaDAOIF{

	
  
	
	private static final String SELECT_ALL = "SELECT id, nome, saldo, tipo FROM CONTA";	
	private static final String SELECT_BY_NAME = "SELECT id, nome, saldo, tipo FROM CONTA WHERE nome = ?";
	private static final String SELECT_BY_ID = "SELECT id, nome, saldo, tipo FROM CONTA WHERE id = ?";	
	private static final String UPDATE = "UPDATE CONTA SET nome = ?, " +
														   "saldo = ?, " +
														   "tipo = ? " +
										  "WHERE id = ?";
	
	private static final String INSERT = "INSERT INTO CONTA(id, nome, saldo, tipo) " +
								         "VALUES(?, ?, ?, ?)";

	
	
	@Override
	public Conta buscarPeloNome(String nomeConta) throws ContaNaoExistenteException{
		Conta conta = null;
		PreparedStatement stmt;
		try {
			stmt = this.getConnection().prepareStatement(SELECT_BY_NAME);
			stmt.setString(1, nomeConta);
			ResultSet rSet = stmt.executeQuery();
			if(rSet.next()){
				String id = rSet.getString("id");
				String nome = rSet.getString("nome");
				double saldo = rSet.getDouble("saldo");
				int tipo = rSet.getInt("tipo");
				conta = createConta(id, nome, saldo, tipo);
			}else{
				throw new ContaNaoExistenteException(nomeConta);
			}
		} catch (SQLException e) {
			throw new ContaNaoExistenteException(e, nomeConta);
		}
		return conta;
	}

	private Conta createConta(String id, String nome, double saldo, int tipo) {
		Conta conta = null;
		if(tipo == Conta.ATIVO)
			conta = new Ativo(id, nome);
		else if(tipo == Conta.PASSIVO)
			conta = new Passivo(id, nome);
		else if(tipo == Conta.PATRIMONIO_LIQUIDO)
			conta = new PatrimonioLiquido(id, nome);
		conta.setSaldo(saldo);
		return conta;
	}
	
	private int getTipo(Conta conta) {
		if(conta.getClass() == Ativo.class)
			return Conta.ATIVO;
		else if(conta.getClass() == Passivo.class)
			return Conta.PASSIVO;
		else if(conta.getClass() ==  PatrimonioLiquido.class)
			return Conta.PATRIMONIO_LIQUIDO;
		return -1;
	}	

	@Override
	public void salvar(Conta conta) throws Exception {
		PreparedStatement stmt = this.getConnection().prepareStatement(ContaDAOSQL.UPDATE);
		stmt.setString(1, conta.getNome());
		stmt.setDouble(2, conta.valor());
		stmt.setInt(3, this.getTipo(conta));
		stmt.setString(4, conta.getId());
		stmt.executeUpdate();
	}

	@Override
	public void criar(Conta conta) throws Exception {
		PreparedStatement stmt = this.getConnection().prepareStatement(ContaDAOSQL.INSERT);
		stmt.setString(1, conta.getId());
		stmt.setString(2, conta.getNome());
		stmt.setDouble(3, conta.valor());
		stmt.setInt(4, this.getTipo(conta));
		stmt.executeUpdate();
	}

	@Override
	public Conta buscarPeloId(String id) throws Exception {
		Conta conta = null;
		PreparedStatement stmt;
		try {
			stmt = this.getConnection().prepareStatement(SELECT_BY_ID);
			stmt.setString(1, id);
			ResultSet rSet = stmt.executeQuery();
			if(rSet.next()){
				String nome = rSet.getString("nome");
				double saldo = rSet.getDouble("saldo");
				int tipo = rSet.getInt("tipo");
				conta = createConta(id, nome, saldo, tipo);
			}else{
				throw new ContaNaoExistenteException(id);
			}
		} catch (SQLException e) {
			throw new ContaNaoExistenteException(e, id);
		}
		return conta;
	}

	@Override
	public Collection<Conta> buscarTodos() throws Exception {
		Collection <Conta> contas = new ArrayList<Conta>();
		PreparedStatement stmt = this.getConnection().prepareStatement(SELECT_ALL);
		ResultSet rSet = stmt.executeQuery();
		while(rSet.next()){
			String id = rSet.getString("id");
			String nome = rSet.getString("nome");
			double saldo = rSet.getDouble("saldo");
			int tipo = rSet.getInt("tipo");
			Conta conta = this.createConta(id, nome, saldo, tipo);
			contas.add(conta);
		}
		return contas;
	}

}
