package br.edu.ifba.inf008.contabil.dao.sql;

import java.sql.PreparedStatement;

import br.edu.ifba.inf008.contabil.dao.LancamentoDAOIF;
import br.edu.ifba.inf008.contabil.model.Lancamento;

public class LancamentoDAOSQL extends AbstractDAOSQL  implements LancamentoDAOIF {

	private static final String INSERT = 
			"INSERT INTO lancamento(instante, descricao, id_conta_debito, id_conta_credito, valor) " +
			"VALUES(?, ?, ?, ?, ?)";
	
	@Override
	public void criar(Lancamento lancamento) throws Exception {
		PreparedStatement stmt = this.getConnection().prepareStatement(LancamentoDAOSQL.INSERT);
		stmt.setLong(1, lancamento.getTimestamp());
		stmt.setString(2, lancamento.getDescricao());
		stmt.setString(3, lancamento.getDebito().getId());
		stmt.setString(4, lancamento.getCredito().getId());
		stmt.setDouble(5, lancamento.getValor());
		stmt.executeUpdate();
	}

}
