package br.edu.ifba.inf008.contabil.model;
import br.edu.ifba.inf008.contabil.util.ComparadorContaPeloSaldo;
import br.edu.ifba.inf008.contabil.util.Ordenador;
import br.edu.inf008.contabil.exceptions.ContaNaoExistenteException;
import br.edu.inf008.contabil.exceptions.SaldoInsuficienteException;

public class BalancoContabil{
    private Conta[] contas;
    
    public BalancoContabil(){
        this.contas = new Conta[0];
    }    
    
    public void adicionar(Conta conta){
      Conta[] novo = new Conta[this.contas.length + 1];
      for(int i = 0; i < this.contas.length; i++)
        novo[i] = this.contas[i];
      novo[novo.length - 1] = conta;  
      this.contas = novo;
        
    } 
    
    public Conta buscarPeloNome(String nome) throws ContaNaoExistenteException{
        for(Conta conta : this.contas)
          if(conta.getNome().equals(nome))
            return conta;
        throw new ContaNaoExistenteException(nome);    
    }
    
    public void ajustar(String nomeContaCredito, 
                        String nomeContaDebito, 
                        double valor) throws ContaNaoExistenteException, 
    										 SaldoInsuficienteException{
      this.buscarPeloNome(nomeContaCredito).creditar(valor);
      this.buscarPeloNome(nomeContaDebito).debitar(valor);
    }
    
    public String toString(){
        Ordenador ordenador = new Ordenador();
        String rep = "";
        ordenador.ordenar(this.contas, new ComparadorContaPeloSaldo());
        for(Conta conta : this.contas)
            rep += conta + "\n";
        return rep;    
    }    
    
}
