package br.edu.ifba.inf008.contabil.session;

import br.edu.ifba.inf008.contabil.dao.ContaDAOIF;
import br.edu.ifba.inf008.contabil.dao.LancamentoDAOIF;
import br.edu.ifba.inf008.contabil.model.Ativo;
import br.edu.ifba.inf008.contabil.model.Conta;
import br.edu.ifba.inf008.contabil.model.Lancamento;
import br.edu.ifba.inf008.contabil.model.Passivo;
import br.edu.ifba.inf008.contabil.model.PatrimonioLiquido;
import br.edu.ifba.inf008.contabil.model.RegistroContabil;
import br.edu.inf008.contabil.exceptions.ContaNaoExistenteException;
import br.edu.inf008.contabil.exceptions.SaldoInsuficienteException;

public class AppContabil {
	
	private ContaDAOIF contaDAO;
	private LancamentoDAOIF lancamentoDAO;
	
	
	public void init(ContaDAOIF contaDAO, LancamentoDAOIF lancamentoDAO){
		this.contaDAO = contaDAO;
		this.lancamentoDAO = lancamentoDAO;
	}
	
    public void registrarFatoContabil(long timestamp,
            String descricao, 
            String nomeContaCredito, 
            String nomeContaDebito, 
            double valor) throws Exception{
    	Conta credito = null;
    	Conta debito = null;
		credito = this.contaDAO.buscarPeloNome(nomeContaCredito);                                    
		debito = this.contaDAO.buscarPeloNome(nomeContaDebito);
		credito.creditar(valor);
		debito.debitar(valor);
		this.contaDAO.salvar(credito);
		this.contaDAO.salvar(debito);
		Lancamento lancamento = new Lancamento(timestamp, descricao, credito, debito, valor);
		this.lancamentoDAO.criar(lancamento);
		
    } 

	
	

}
